//
// CalcApp.cpp
//

#include "CalcApp.h"
#include "AboutWindow.h"
#include "CalcWindow.h"
#include "DvBeUtils.h"
#include <assert.h>

CalcApp::CalcApp() : BApplication("application/x-vnd.Devachan-DevaCalc")
{
	fWindowPos.Set(-1, -1);
	ReadUserSettings();
	
	// Use previous position user left window at unless this is the
	// first time and their is no previous position
	//
	const float kWindowWidth = 230;
	const float kWindowHeight = 245;
	const float kTitleBarHeight = 25;
	BRect frameRect(0, 0, kWindowWidth, kWindowHeight);
	if (fWindowPos.x == -1 && fWindowPos.y == -1)
		frameRect.OffsetTo(6, kTitleBarHeight);
	else
		frameRect.OffsetTo(fWindowPos.x, fWindowPos.y); 
	CalcWindow* theWindow = new CalcWindow(frameRect);
}

CalcApp::~CalcApp(void)
{
	if (fPrefs)
		delete fPrefs;
}

void CalcApp::AboutRequested()
{
	BWindow* aboutWindow;
	
	if (CountWindows() == 1)
	{
		aboutWindow = new AboutWindow;
		aboutWindow->Show();
	}
	else
	{
		aboutWindow = WindowAt(1);
		aboutWindow->Activate();
	}
}

bool CalcApp::QuitRequested()
{
	// This routine assumes CalcWindow calls SetWindowPosition when it closes
	//
	
	// Save the window position for future use
	//
	if (BApplication::QuitRequested()) 
	{
		if (fPrefs) 
		{
			fPrefs->Seek(0, 0);
			fPrefs->Write(&fWindowPos, sizeof(BPoint));
			
			/*
			fPrefs->Write(&level, sizeof(level));
			fPrefs->Write(&f_family, sizeof(font_family));
			fPrefs->Write(&f_style, sizeof(font_style));
			fPrefs->Write(&size, sizeof(float));
			fPrefs->Write(&signature_window, sizeof(BRect));
			fPrefs->Write(&header_flag, sizeof(bool));
			fPrefs->Write(&wrap_mode, sizeof(bool));
			fPrefs->Write(&prefs_window, sizeof(BPoint));
			len = strlen(signature) + 1;
			fPrefs->Write(&len, sizeof(int32));
			fPrefs->Write(signature, len);
			*/
		}
		return true;
	}
	else
		return false;
}

void CalcApp::ReadUserSettings()
{
	BDirectory 	dir;
	BEntry		entry;
	BPath 		path;
	const char*	kSettingsFile = "DevaCalc settings";

	find_directory(B_USER_SETTINGS_DIRECTORY, &path, true);
	dir.SetTo(path.Path());
	if (dir.FindEntry(kSettingsFile, &entry) == B_NO_ERROR) 
	{
		fPrefs = new BFile(&entry, O_RDWR);
		if (fPrefs->InitCheck() == B_NO_ERROR) 
		{
			fPrefs->Read(&fWindowPos, sizeof(BPoint));
			/*
			fPrefs->Read(&level, sizeof(level));
			fPrefs->Read(&f_family, sizeof(font_family));
			fPrefs->Read(&f_style, sizeof(font_style));
			fPrefs->Read(&size, sizeof(float));
			fPrefs->Read(&signature_window, sizeof(BRect));
			fPrefs->Read(&header_flag, sizeof(bool));
			fPrefs->Read(&wrap_mode, sizeof(bool));
			fPrefs->Read(&prefs_window, sizeof(BPoint));
			if (fPrefs->Read(&len, sizeof(int32)) > 0) {
				free(signature);
				signature = (char *)malloc(len);
				fPrefs->Read(signature, len);
			}
			*/
		}
		else 
		{
			delete fPrefs;
			fPrefs = NULL;
		}
	}
	else 
	{
		fPrefs = new BFile();
		if (dir.CreateFile(kSettingsFile, fPrefs) != B_NO_ERROR) 
		{
			delete fPrefs;
			fPrefs = NULL;
		}
	}
}

void CalcApp::SetWindowPos(BPoint p)
{
	fWindowPos = p;
}
