#include "CommandTimerView.h"

CommandTimerView::CommandTimerView(BRect cTViewRect)
	: BView(cTViewRect, "CommandTimerView", B_FOLLOW_ALL, B_WILL_DRAW | B_PULSE_NEEDED)
{
}

void CommandTimerView::AttachedToWindow()
{
	BRect tempRect(15, 15, 235, 25);
	commandTextControl = new BTextControl(tempRect, "commandTextControl", NULL, NULL,
		new BMessage('CMND'), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE); 
	AddChild(commandTextControl);

	tempRect.Set(40, 48, 62, 60);
	hoursTextControl = new BTextControl(tempRect, "hoursTextControl", NULL, "00",
		NULL, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	AddChild(hoursTextControl);
	
	tempRect.Set(65, 48, 87, 60);
	minsTextControl = new BTextControl(tempRect, "minsTextControl", NULL, "00",
		NULL, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	AddChild(minsTextControl);
	
	tempRect.Set(90, 48, 112, 60);
	secsTextControl = new BTextControl(tempRect, "minsTextControl", NULL, "00", 
		NULL, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	AddChild(secsTextControl);

	tempRect.Set(140, 45, 205, 55);
	startStopButton = new BButton(tempRect, "startStopButton", "Start/Stop",
		new BMessage('CLOK'));
	AddChild(startStopButton);
	
	tempRect.Set(40, 75, 120, 85);
	repeatCheckBox = new BCheckBox(tempRect, "repeatCheckBox", "Repeat", 
		new BMessage('REPT'), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	AddChild(repeatCheckBox);

	tempRect.Set(150, 75, 230, 85);
	alarmCheckBox = new BCheckBox(tempRect, "alarmCheckBox", "Alarm", 
		new BMessage('BEEP'), B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
	AddChild(alarmCheckBox);

	isRunning = false;
	alarm = false;
	repeat = false;
}	

void CommandTimerView::Pulse()
{
	if(isRunning)
	{
		if(seconds)
			seconds--;
		else
		{
			if(isRunning)
			{
				seconds = secondsBackup;
				system(commandTextControl->Text());
				if(alarm)
					beep();
				if(!repeat) 
				{
					isRunning = false;
					setPermissions(true);
				}
			}
		}
		updateTime();
	}
}

void CommandTimerView::updateTime()
{
	char digits[3];
	sprintf(digits, "%02ld", seconds / 3600);
	hoursTextControl->SetText(digits);
	sprintf(digits, "%02ld", (seconds / 60) % 60);
	minsTextControl->SetText(digits);
	sprintf(digits, "%02ld", seconds % 60);
	secsTextControl->SetText(digits);
}

void CommandTimerView::startStopClock()
{
	if(isRunning)
	{
		setPermissions(true);
		isRunning = false;
	}
	else
	{
		setPermissions(false);
		isRunning = true;
		getTime();
	}
}

void CommandTimerView::toggleRepeat()
{
	repeat = !repeat;
}

void CommandTimerView::toggleAlarm()
{
	alarm = !alarm;
}

void CommandTimerView::setPermissions(bool permission)
{
	commandTextControl->SetEnabled(permission);
	hoursTextControl->SetEnabled(permission);
	minsTextControl->SetEnabled(permission);
	secsTextControl->SetEnabled(permission);
}

void CommandTimerView::getTime()
{
	seconds = atoi(hoursTextControl->Text()) * 3600
		+ atoi(minsTextControl->Text()) * 60
		+ atoi(secsTextControl->Text());
	secondsBackup = seconds;
}
