/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#ifndef _CRC_VIEW_H
#define _CRC_VIEW_H

#include <Be.h> 
#include <FilePanel.h>
#include "convCR.h"

enum {
	MSG_OPEN_PRESSED = 1000,
	MSG_SAVE_PRESSED,
	MSG_EXEC_PRESSED,
	MSG_QUIT_PRESSED,

	MSG_INTEXT_KEYIN,
	MSG_OUTEXT_KEYIN,

    MSG_B2W_PRESSED,
    MSG_B2M_PRESSED,
    MSG_W2B_PRESSED,
    MSG_M2B_PRESSED
} ;

class CRcView : public BView 
{ 
    private: 
           BStringView *string ;
           rgb_color    color ;
           
           entry_ref    openref ;
           entry_ref    saveref ;
           char        *savename ;
           int          convFlg ;
           
           char        *retmsg ;
           
           BView        *base ;
            
           BRadioButton *radio0 ;
           BRadioButton *radio1 ;
           BRadioButton *radio2 ;
           BRadioButton *radio3 ; 
   
           BButton *inputButton ; 
           BButton *outputButton ; 
           BButton *exeButton ; 
           BButton *dismisButton ; 
           
           BStringView *inputtext ; 
           BStringView *outputtext ; 

           BBox *box0 ; 
           BBox *box10 ;
           BBox *box20 ;
            
           BFilePanel  *openPanel ;
           BFilePanel  *savePanel ;
           
           convCR *convcr ;

        void   AttachedToWindow(); 
        void   _initWindow     ( BRect frame ) ;
        void   _setColor       () ;
        void   _deleteWindow   () ;
        void   _BAlert( alert_type type, char *msg ) ;
               
    public: 
               CRcView       ( BRect frame ) ; 
              ~CRcView       () ;
        void   openpanel     () ;
        void   savepanel     () ;
        void   getOpenfname  ( BMessage* msg ) ;
        void   getSavefname  ( BMessage* msg ) ;
        void   resetSaveFname() ;
        void   setConvflg    ( int flg ) ;
        void   convertCR     () ;

} ; 

#endif
