#include <AppKit.h>
#include "PrefsPanel/ViEdMainWindow.h"

sem_id ViEdMainWindow::WindowSemaphore= B_BAD_VALUE;
BWindow *ViEdMainWindow::the_win= NULL;

ViEdMainWindow::ViEdMainWindow(BRect frame, const char *title, 
	window_look look, window_feel feel, uint32 flags, uint32 workspaces) :
	BWindow(frame, title, look, feel, flags, workspaces)
{
	the_win= this;

	BRect rect = Bounds();

// creating and adding main view within the main window
	view_L0S0 = new ViEdView_L0S0(rect, "view_L0S0", B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

// specifying background color for view_L0S0
	rgb_color color = {216,216,216,0};
	view_L0S0->SetViewColor(color);
	
	AddChild(view_L0S0);
}

ViEdMainWindow::~ViEdMainWindow()
{
	FreeWindow();
}

void ViEdMainWindow::MessageReceived(BMessage *message)
{
	switch ( message->what )
	{
		case 'ShoW':
			if (!IsHidden())
				Hide();
			Minimize(false);
			Show();
			break;
		case B_SIMPLE_DATA:
			break;
		case B_QUIT_REQUESTED:
			//be_app->PostMessage(B_QUIT_REQUESTED);
			break;
   		default:
			BWindow::MessageReceived(message);
			break;
	}
}

bool ViEdMainWindow::QuitRequested()
{
	return true;
}

void ViEdMainWindow::CreateWindow()
{
	ViEdMainWindow *win;
	BRect ScreenRect = BScreen(B_MAIN_SCREEN_ID).Frame();
	BRect WinRect(10, 20, 250, 100);
	BPoint WinPos(ScreenRect.right, ScreenRect.bottom);

	WinPos.x/= 2;
	WinPos.y/= 2;
	WinPos.x-= (WinRect.right-WinRect.left)/2;
	WinPos.y-= (WinRect.bottom-WinRect.top)/2;
	WinRect.OffsetTo(WinPos);
	win = new ViEdMainWindow(WinRect, "Simple VU-Meter Prefs", B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, 0, B_CURRENT_WORKSPACE);
	win->Show();
}