
#ifndef CLAMP_OUTPUT_PLUGIN_H
#define CLAMP_OUTPUT_PLUGIN_H

#include <AppKit.h>
#include <StorageKit.h>
#include <interface/View.h>

#ifndef CLAMP_PLUGIN_MSGS_H
 #include "Plugin_Messages.h"
#endif


// The following is for the GetFlags() return value
#define OUTPLUG_AFTER_MIXER			0x0001	// The plugin will always get 44100Hz, 16bit, Stereo sound with cross fadings and DSP effects included.
											// Without OUTPLUG_AFTER_MIXER it will get the raw decoded audio data from the current file.
#define OUTPLUG_CROSSFADE_START		0x0002	// The start of a cross fade section will be treated as the beginning of a new song
#define OUTPLUG_CROSSFADE_END		0x0004	// The ending of a cross fade section will be treated as the beginning of a new song
											// Without OUTPLUG_CROSSFADE_FIRST or OUTPLUG_CROSSFADE_LAST the crossfading will be treated as an own file
#define OUTPLUG_FORBID_FADE			0x0008	// Fading will NOT be done when this output plugin is used

// The class description of the object that will be returned when CL-Amp ask the AddOn (Plugin) for its object...
class OutputPlugin {
public:
// Used by CL-Amp. Don't bother about these functions!
	OutputPlugin(char *label, char *desc) { CLAmpHandler=NULL; Label= label; Description= desc; }
	virtual ~OutputPlugin() { }
	void SetHandler(BView *handler) { CLAmpHandler= handler; }

// =================================================================
// Here comes the functions you have to provide in your plugin code!

// No thread considerations with this function!
	virtual bool Init()=0;
	virtual void Cleanup() {};

// These functions will run in thread A, dont let functions from A use data from B or vice verse...
	virtual bool About(bool Question)=0;
	virtual bool Prefs(bool Question)=0;
	virtual unsigned long GetFlags()=0;

// These functions will run in thread B, dont let functions from B use data from A or vice verse...
	// Filename2 is used if the Recording is a crossfade section between two songs. (only if OUTPLUG_CROSSFADE_FIRST or OUTPLUG_CROSSFADE_LAST is not given)
	// Filename2 will normally be NULL
	virtual bool InitRecording(const char *FileName, const char *FileName2, long Frequency, short Channels, bool SampleIsOnly8Bits)=0;
	virtual bool PutAudio(const char *Buff, long Size)=0;
	virtual void CleanupRecording()=0;

// End of the functions you have to provide in your plugin code!
// =================================================================

// Help functions you can call to get data from the InputPlugin class itself
	const char *GetLabel() { return Label; }
	const char *GetDescription() { return Description; }
	BHandler *GetCLAmpHandler() { return CLAmpHandler; }
	void SendToCLAmp_ChangedFile(const char *FileName) { BMessage Msg(CLAMP_MSG_CHANGED); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_CHANGED_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
	void SendToCLAmp_AddFile(const char *FileName) { BMessage Msg(CLAMP_MSG_ADD); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_ADD_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
	void SendToCLAmp_DelFile(const char *FileName) { BMessage Msg(CLAMP_MSG_DEL); BLooper *l; if (CLAmpHandler && (l=CLAmpHandler->Looper())) { Msg.AddString(CLAMP_DEL_LABEL, FileName); l->PostMessage (&Msg, CLAmpHandler); } }
private:
	char *Label, *Description;
	BView *CLAmpHandler;
};

#define CURRENT_OUTPUT_PLUGIN_VERSION  1
#define OUTPUT_PLUGIN_VERSION_MASK	0x0fff

#endif
