#include <View.h>
#include <Slider.h>
#include <CheckBox.h>
#include <ListView.h>
#include <StringView.h>
#include <ListItem.h>
#include <ScrollView.h>
#include <Button.h>
#include <Rect.h>
#include <Font.h>
#include <Window.h>
#include <TextControl.h> 
#include <Alert.h>
#include <string.h>
#include <stdio.h>
#include <Invoker.h>
#include <math.h>
#include "PrefData.h"
#include "message_labels.h"

#ifndef TEXT_TOOL_VIEW

#ifndef MIN
	#define MIN(a,b)	(a<b)?a:b
#endif

#ifndef MAX
	#define MAX(a,b)	(a>b)?a:b
#endif

class FontDrawView : public BView
{
public:
	FontDrawView(BRect rect, char *fonttext);
	~FontDrawView(void);
	
	void Draw(BRect r);
	void CheckStringPlacement(void);
	virtual void MessageReceived(BMessage *message);
	char text[255];
	BFont currentfont;
	BPoint fontlocation;
};

class FontListView : public BListView
{
public:
	FontListView(BRect rect, const char *name, BHandler *target, BMessage *message);
	~FontListView(void);
	virtual void SelectionChanged();
	BHandler *recipient;
	BInvoker *fontinvoker;
};

class TextToolView : public BView
{
public:
	TextToolView(BRect rect);
	~TextToolView(void);

	virtual void MessageReceived(BMessage *message);
	virtual void AttachedToWindow(void); 

	// Controls for font config

	BTextControl *textedit;	
	BListView *fontlist;
	BListView *stylelist;
	BScrollView *fontscrollview;
	FontDrawView *fontview;

	BSlider *outlineslider;
	BSlider *sizeslider;
	BSlider *shearslider;
	BSlider *rotationslider;
	BSlider *spacingslider;

	BButton *renderbutton;
	BCheckBox *aacheckbox;
	BButton *fontviewtoggle;
};

#define TEXT_TOOL_VIEW
#endif
