#include "PluginWindow.h"

PluginWindow::PluginWindow(BView *pconfig, share *sh, bool convert) : 
	BWindow( BRect(100,100,200,200),"", B_FLOATING_WINDOW, B_NOT_ZOOMABLE | B_NOT_MINIMIZABLE | B_NOT_RESIZABLE )
{
	// rect for setting up window
	BRect workrect(pconfig->Bounds());
	workrect.Set(workrect.left,workrect.top,workrect.right,workrect.bottom+40);

	is_convert=convert;
	shared=sh;	
	// Set up plugin's view
	configview=pconfig;
	ResizeTo(workrect.Width(),workrect.Height());
	AddChild(configview);

	// Buttons for controlling the filter
	applybutton=new BButton(
			BRect(10,workrect.IntegerHeight()-30,60,workrect.IntegerHeight()-5),
			"applybutton","Apply",new BMessage(APPLY_PLUGIN) );
	AddChild(applybutton);
	
	cancelbutton=new BButton(
			BRect(80,workrect.IntegerHeight()-30,130,workrect.IntegerHeight()-5),
			"cancelbutton","Cancel",new BMessage(CANCEL_PLUGIN) );
	AddChild(cancelbutton);
}

PluginWindow::~PluginWindow(void)
{
}

void PluginWindow::MessageReceived(BMessage *msg)
{
	switch(msg->what)
	{	
		case APPLY_PLUGIN:
			Image_GetConfigurationMessage(shared->mAddonId,
					&(shared->pluginconfig),NULL);
			if(is_convert)
				shared->pluginconfig.what=(int32)APPLY_CONVERT;
			else
				shared->pluginconfig.what=(int32)APPLY_MANIP;
			be_app->PostMessage(&(shared->pluginconfig));
			Quit();
			break;
		case CANCEL_PLUGIN:
			Quit();
			break;
		default:
			BWindow::MessageReceived(msg);
	}
}
