// gnuplot_be
//
// An outboard graphical terminal driver for gnuplot
// Thomas Ryan Hays   1997
// trh@lns598.lns.cornell.edu

#ifndef BE_GNUPLOT__H
#define BE_GNUPLOT__H

#include <AppKit.h>
#include <InterfaceKit.h>
#include <KernelKit.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Constants
const char APP_SIGNATURE[] = "application/x-vnd.trh-gnuplot_be";

/* real coordinates */
const int DISPLAY_X = 490;
const int DISPLAY_Y = 360;
/* virtual coordinates */
/* XMAX = 4096   YMAX=4096 */

#define Nbuf 1024

//const uint32 MSG_TRY_ME = 1;

enum JUSTIFY { LEFT, CENTER, RIGHT };

// For text rotation
enum textrot {HORIZONTAL=0 ,VERTICAL=90};


class GnuplotWindow;
class PlotView;

// Global window construct for the single window terminal support.
typedef struct
{
  GnuplotWindow *theWindow;
  bool window_open;  
} globalBeOSterm;

// Application object
class GnuplotBe : public BApplication {
public:
	GnuplotBe();
	virtual void ReadyToRun(void);
	virtual void AboutRequested(void);
};

// Window object
class GnuplotWindow : public BWindow {
public:
	PlotView *main_view;
    GnuplotWindow();
	virtual bool QuitRequested(void);
	virtual void MessageReceived(BMessage *msg);
private:
	BPicture *the_picture;
};


// Plot view
class PlotView : public BView {
public:
	PlotView(BRect frame, BPicture *apicture);
	virtual void Draw(BRect update);
    void PlotGnuplotCommands();
private:
    BPicture *the_picture;
    int pointsize;	
 	void FrameResized(float new_width, float new_height);
    void PlotPoint(int which, int x, int y);
};


// Prototypes
long record(void *arg);
void display(void);


#endif
