//class definition for PlanetWeapon objects in Spheres of Influence 0.1

#ifndef PLANETWEAPON
#define PLANETWEAPON

#define PLANETWEAPON_TYPE 7
#define NO_PLANETWEAPON (-PLANETWEAPON_TYPE)

class MergeList;
class DataList;
class Doable;
extern DataList * dataListGlobal[];
extern const char * FailCreate[],
	* FailCreateName,
	* FailName,
	* badFileLength;

class PlanetWeapon : public SmallConstants {
private:
					PlanetWeapon(	const PlanetWeapon& copy);//not implimented on purpose
	PlanetWeapon&	operator = (	const PlanetWeapon& assign);//not implimented on purpose
public:
	float			defaultStrength;
	uint32			kind;
	Doable *		doable;
	Doable *		buildable;
	Doable *		maintainable;
	uint32			possibleOrders;
					PlanetWeapon();
					PlanetWeapon(	PlanetWeapon * fromPW, 
									const char * n);
					PlanetWeapon(	PlanetWeapon * fromPW, 
									MergeList * list);
					~PlanetWeapon();
	bool			Copy(	PlanetWeapon * fromItem);
	bool			Unique();
	bool			Save(	BFile * file);
	bool			Load(	BFile * file);
};
#endif