//class definition for Planet objects in Spheres of Influence 0.1

#ifndef PLANET
#define PLANET

#define PLANET_TYPE 5
#define NO_PLANET (-PLANET_TYPE)

//planatary characteristic messages:
#define TINYROCKMSG 'p TR'
#define TINYMOSTLYROCKMSG 'pTMR'
#define TINYMETALMSG 'p TM'
#define TINYMOSTLYMETALMSG 'pTMM'
#define TINYWATERMSG 'p TW'
#define TINYMOSTLYWATERMSG 'pTMW'
#define TINYLIQAMONMSG 'pTLA'
#define TINYMOSTLYLIQAMONMSG 'pTML'
#define TINYGASMSG 'p TG'
#define SMALLROCKMSG 'p SR'
#define SMALLMOSTLYROCKMSG 'pSMR'
#define SMALLMETALMSG 'p SM'
#define SMALLMOSTLYMETALMSG 'pMSM'
#define SMALLWATERMSG 'p SW'
#define SMALLMOSTLYWATERMSG 'pSMW'
#define SMALLLIQAMONMSG 'pSLA'
#define SMALLMOSTLYLIQAMONMSG 'pSML'
#define SMALLGASMSG 'p SG'
#define MEDIUMROCKMSG 'p MR'
#define MEDIUMMOSTLYROCKMSG 'pMMR'
#define MEDIUMMETALMSG 'p MM'
#define MEDIUMMOSTLYMETALMSG 'pMMM'
#define MEDIUMWATERMSG 'p MW'
#define MEDIUMMOSTLYWATERMSG 'pMMW'
#define MEDIUMLIQAMONMSG 'pMLA'
#define MEDIUMMOSTLYLIQAMONMSG 'pMML'
#define MEDIUMGASMSG 'p MG'
#define LARGEROCKMSG 'p LR'
#define LARGEMOSTLYROCKMSG 'pLMR'
#define LARGEMETALMSG 'p LM'
#define LARGEMOSTLYMETALMSG 'pLMM'
#define LARGEWATERMSG 'p LW'
#define LARGEMOSTLYWATERMSG 'pLMW'
#define LARGELIQAMONMSG 'pLLA'
#define LARGEMOSTLYLIQAMONMSG 'pLML'
#define LARGEGASMSG 'p LG'
#define GIANTROCKMSG 'p GR'
#define GIANTMOSTLYROCKMSG 'pGMR'
#define GIANTMETALMSG 'p GM'
#define GIANTMOSTLYMETALMSG 'pGMM'
#define GIANTWATERMSG 'p GW'
#define GIANTMOSTLYWATERMSG 'pGMW'
#define GIANTLIQAMONMSG 'pGLA'
#define GIANTMOSTLYLIQAMONMSG 'pGML'
#define GIANTGASMSG 'p GG'

//planatary characteristics:
#define TINYROCK 0
#define TINYMOSTLYROCK 1
#define TINYMETAL 2
#define TINYMOSTLYMETAL 3
#define TINYWATER 4
#define TINYMOSTLYWATER 5
#define TINYLIQAMON 6
#define TINYMOSTLYLIQAMON 7
#define TINYGAS 8
#define SMALLROCK 9
#define SMALLMOSTLYROCK 10
#define SMALLMETAL 11
#define SMALLMOSTLYMETAL 12
#define SMALLWATER 13
#define SMALLMOSTLYWATER 14
#define SMALLLIQAMON 15
#define SMALLMOSTLYLIQAMON 16
#define SMALLGAS 17
#define MEDIUMROCK 18
#define MEDIUMMOSTLYROCK 19
#define MEDIUMMETAL 20
#define MEDIUMMOSTLYMETAL 21
#define MEDIUMWATER 22
#define MEDIUMMOSTLYWATER 23
#define MEDIUMLIQAMON 24
#define MEDIUMMOSTLYLIQAMON 25
#define MEDIUMGAS 26
#define LARGEROCK 27
#define LARGEMOSTLYROCK 28
#define LARGEMETAL 29
#define LARGEMOSTLYMETAL 30
#define LARGEWATER 31
#define LARGEMOSTLYWATER 32
#define LARGELIQAMON 33
#define LARGEMOSTLYLIQAMON 34
#define LARGEGAS 35
#define GIANTROCK 36
#define GIANTMOSTLYROCK 37
#define GIANTMETAL 38
#define GIANTMOSTLYMETAL 39
#define GIANTWATER 40
#define GIANTMOSTLYWATER 41
#define GIANTLIQAMON 42
#define GIANTMOSTLYLIQAMON 43
#define GIANTGAS 44

#define NAMEPLANETMSG 'nmPL'

class MergeList;
class DataList;
extern DataList * dataListGlobal[];
extern const char * FailCreate[],
	* FailCreateName,
	* FailName,
	* badFileLength;

class Planet : 
public BuildConstants 
{
private:
			Planet(	const Planet& copy);//not implimented on purpose
	Planet&	operator = (	const Planet& assign);//not implimented on purpose
public:
	uint32	mass;
			Planet();
			Planet(	Planet * fromP, 
					const char * n);
			Planet(	Planet * fromP, 
					MergeList * list);
			~Planet();
	bool	Copy(	Planet * fromItem);
	bool	Unique();
	bool	Save(	BFile * file);
	bool	Load(	BFile * file);
};
#endif