//scrolling window

#include "XwindowGuts.h"
#include "windowGuts.h"
#include <memory>
#include "scrollView.h"
#include "XlayoutMatrixItem.h"
#include "DlayoutMatrix.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "uInt32Gadget.h"
#include "floatGadget.h"
#include "myButton.h"
#include "myPopUpMenu.h"
#include "textItem.h"
#include "myTextView.h"
#include "myListView.h"
#include "myCheckBox.h"
#include "myStringDrawer.h"
#include "stringGadget.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myRadioView.h"
#include "myStatusBar.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "colorWell.h"
#include "titleWindow.h"

//ctor 
WindowGuts	::	WindowGuts(	BRect paramBound,
							const char * paramWindowTitle,
							const char * paramScrollViewName,
							const char * paramNamePrefFrame)
			: 
				BWindow(	paramBound, 
							paramWindowTitle,
							B_DOCUMENT_WINDOW, 
							/*B_WILL_ACCEPT_FIRST_CLICK*/0), 
				baseView(NULL), 
				scrollView(NULL),
				pMenuBar(	new BMenuBar(	BRect(0, 0, 1000, 15), "WindowGutsMenuBar")),
				scrollViewName(new char[strlen(paramScrollViewName) + 1]),
				NamePrefFrame(paramNamePrefFrame),
				pLayoutMatrixList(new BList())
{
	strcpy(scrollViewName, paramScrollViewName);
	BRect	br(0, 0, 32, 32);
	BView	bv(br, NoShowView, B_FOLLOW_NONE, NULL);
	fTitleWidth = bv.StringWidth(paramWindowTitle) + 64/*width of close + zoom gadgets + padding*/;
}//end


//dtor
WindowGuts	::	~WindowGuts() 
{
	delete [] scrollViewName;
}//end


//do all the real work of construction so we can Fail gracefully
bool 
WindowGuts	::	Initialize(	void) 
{
	AddChild(pMenuBar);
	float mb_height = pMenuBar->Bounds().Height();
	float maxRight = 50;
	float maxBottom = 20;
	LayoutMatrix * tempLayoutMatrix;
	int32 numItems = pLayoutMatrixList->CountItems();
	if (numItems)
	{
		tempLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(0);
		maxRight = tempLayoutMatrix->right;
		maxBottom = tempLayoutMatrix->bottom;
		for (	int32 i = 1;
				i < numItems;
				i++)
		{
			tempLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(i);//dynamic cast??
			if (tempLayoutMatrix->right > maxRight)
			{
				maxRight = tempLayoutMatrix->right;
			}
			if (tempLayoutMatrix->bottom > maxBottom)
			{
				maxBottom = tempLayoutMatrix->bottom;
			}
		}
	}
	maxRight += MATRIXHORIZONTALOFFSETGUTS;
	if (maxRight < fTitleWidth)
	{
		maxRight = fTitleWidth;
	}
	maxBottom += (2 * MATRIXVERTICALOFFSETGUTS);
	//gives a bit of pad spacing between the items and the view's right & lower edges
	
	//insure the widow is appropriately sized--as small as
	//needed, or if need be (underlaying view larger than screen
	//resolution) as large as will fit on the screen nicely
	BRect	screenResolutionRect;
	{
		BScreen	screen(B_MAIN_SCREEN_ID);
		if(!screen.IsValid()) 
		{
			warning(ScreenNotValid);
			return false;
		}
		screenResolutionRect = screen.Frame();
	}
	float horizFudge = 9;//so our window nicely fits inside screen
	float vertFudge = 8;//so our window nicely fits inside screen
	float newWindowWidth = screenResolutionRect.IntegerWidth() - (B_V_SCROLL_BAR_WIDTH + horizFudge);
	if (maxRight < newWindowWidth)
	{
		newWindowWidth = maxRight;
	}
	float newWindowHeight = screenResolutionRect.IntegerHeight() - (B_H_SCROLL_BAR_HEIGHT + MATRIXVERTICALOFFSETGUTS + mb_height + vertFudge);
	if (maxBottom < newWindowHeight)
	{
		newWindowHeight = maxBottom;
	}
	ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH, 
				newWindowHeight + B_H_SCROLL_BAR_HEIGHT + mb_height);

	underViewWidth = maxRight;
	underViewHeight = maxBottom;
	try 
	{
		//this is the view into which we will place our buttons
		//notice the "mb_height + 1", in the second element
		baseView = new ScrollView(	BRect(	0, 
											mb_height + 1, 
											maxRight, 
											maxBottom + mb_height - 1));
		baseView->SetFont(myPrefs->GetPreferredFont());
	}
	catch(...) 
	{
		warning(FailScrollView);
		return false;
	}
	try 
	{
		//this is the scroll bar stuff:
		scrollView = new BScrollView(	scrollViewName, 
										(BView *)baseView, 
										B_FOLLOW_ALL, 
										B_WILL_DRAW, 
										true, 
										true, 
										B_NO_BORDER);
	}
	catch(...) 
	{
		warning(FailMemory);
		return false;
	}
	AddChild(scrollView);
	//to the older sized window
	
	scrollView->ResizeTo(	newWindowWidth + B_V_SCROLL_BAR_WIDTH + 1, 
							newWindowHeight + B_H_SCROLL_BAR_HEIGHT - 1);
	//BScrollViews get thier initial size from the underlaying BView (baseView)
	
	//now we have a baseView with permenent homes for the created buttons:
	int32 numLayoutMatrixListItems = pLayoutMatrixList->CountItems();
	for (	int32 j = 0;
			j < numLayoutMatrixListItems;
			j++)
	{
		LayoutMatrix * holdLayoutMatrix = (LayoutMatrix *)pLayoutMatrixList->ItemAt(j);
		int32 numThingsTo = holdLayoutMatrix->mpChildrenToAdd->CountItems();
		for (	int32 intd = 0;
				intd < numThingsTo;
				intd++)
		{
			uint32 itemKind = ~0;
			BView * item = (BView *)holdLayoutMatrix->mpChildrenToAdd->ItemAt(intd);
			MyButton * myB = dynamic_cast<MyButton *>(item);
			UInt32Gadget * ig = dynamic_cast<UInt32Gadget *>(item);
			FloatGadget * fg = dynamic_cast<FloatGadget *>(item);
			MyPopUpMenu * pum = dynamic_cast<MyPopUpMenu *>(item);
			MyTextView * mtv = dynamic_cast<MyTextView *>(item);
			StringGadget * msg = dynamic_cast<StringGadget *>(item);
			MyCheckBox * mcb = dynamic_cast<MyCheckBox *>(item);
			MyPictureButton * mpb = dynamic_cast<MyPictureButton *>(item);
			TextItem * ti = dynamic_cast<TextItem *>(item);
			ColorWell * cw = dynamic_cast<ColorWell *>(item);
			MyColorControl * mcc = dynamic_cast<MyColorControl *>(item);
			MyStatusBar * msb = dynamic_cast<MyStatusBar *>(item);
			MyStringDrawer * msd = dynamic_cast<MyStringDrawer *>(item);
			MyRadioView * rv = dynamic_cast<MyRadioView *>(item);
			MyListView * mlv = dynamic_cast<MyListView *>(item);
			if (!myB)
			{
				if (!ig)
				{
					if (!pum)
					{
						if (!mtv)
						{
							if (!msg)
							{
								if (!mcb)
								{
									if (!mpb)
									{
										if (!ti)
										{
											if (!cw)
											{
												if (!mcc)
												{
													if (!msb)
													{
														if (!msd)
														{
															if (!rv)
															{
																if (!fg)
																{
																	if (mlv)
																	{
																		itemKind = KIND_MYLISTVIEW;
																	}
																}
																else
																{
																	itemKind = KIND_FLOATGADG;
																}
															}
															else
															{
																itemKind = KIND_MYRADIOVIEW;
															}
														}
														else
														{
															itemKind = KIND_STRINGDRAWER;
														}
													}
													else
													{
														itemKind = KIND_MYSTATUSBAR;
													}
												}
												else
												{
													itemKind = KIND_MYCOLORCONTROL;
												}
											}
											else
											{
												itemKind = KIND_COLORWELLGADG;
											}
										}
										else
										{
											itemKind = KIND_TEXT;
										}
									}
									else
									{
										itemKind = KIND_MYPICTUREBUTTON;
									}
								}
								else
								{
									itemKind = KIND_MYCHECKBOX;
								}
							}
							else
							{
								itemKind = KIND_STRINGGADG;
							}
						}
						else
						{
							itemKind = KIND_MYTEXTVIEW;
						}
					}
					else
					{
						itemKind = KIND_MYPOPUPMENU;
					}
				}
				else
				{
					itemKind = KIND_INTGADG;
				}
			}
			else
			{
				itemKind = KIND_MYBUTTON;
			}
			switch (itemKind)
			{	//item->SetTarget(this);is needed for some, not others???
				case KIND_TEXT:
				{
					warning("TextItem not a real gadget kind\n");
				break;
				}
				case KIND_MYPOPUPMENU:
				{
					MyPopUpMenu * bmb = pum;
					bmb->MoveTo((bmb->GetLeft() + bmb->fmLabelWidth + 5), bmb->GetTop());
					baseView->AddChild(bmb);
				break;
				}
				case KIND_MYTEXTVIEW:
				{
					BTextView * btv = (BTextView *)mtv;
					baseView->AddChild(btv);
				break;
				}
				case KIND_MYLISTVIEW:
				{
					BListView * blv = (BListView *)mlv;
					baseView->AddChild(blv);
				break;
				}
				case KIND_STRINGGADG:
				{
					BTextControl * btc = (BTextControl *)msg;
					baseView->AddChild(btc);
				break;
				}
				case KIND_MYCHECKBOX:
				{
					BCheckBox * bcb = (BCheckBox *)mcb;
					baseView->AddChild(bcb);
					bcb->SetTarget(this);
				break;
				}
				case KIND_MYPICTUREBUTTON:
				{
					BPictureButton * bpb = (BPictureButton *)mpb;
					baseView->AddChild(bpb);
					bpb->SetTarget(this);
				break;
				}
				case KIND_MYBUTTON:
				{
					MyButton * mbg = (MyButton *)myB;
					baseView->AddChild(mbg);
					mbg->SetTarget(this);
				break;
				}
				case KIND_INTGADG:
				{
					UInt32Gadget * uInt32Gadget = (UInt32Gadget *)ig;
					baseView->AddChild(uInt32Gadget);
					uInt32Gadget->SetTarget(this);
				break;
				}
				case KIND_FLOATGADG:
				{
					FloatGadget * floatGadget = (FloatGadget *)fg;
					baseView->AddChild(floatGadget);
					floatGadget->SetTarget(this);
				break;
				}
				case KIND_COLORWELLGADG:
				{
					ColorWell * cwg = (ColorWell *)cw;
					cwg->MoveTo(cwg->GetLeft(), cwg->GetTop());
					baseView->AddChild(cwg);
				break;
				}
				case KIND_MYCOLORCONTROL:
				{
					MyColorControl * myColorControl = (MyColorControl *)mcc;
					baseView->AddChild(myColorControl);
					myColorControl->SetTarget(this);
				break;
				}
				case KIND_MYSTATUSBAR:
				{
					MyStatusBar * myStatusBar = (MyStatusBar *)msb;
					rgb_color rgb;
					myPrefs->GetPreferredMyBarColor(&rgb);
					myStatusBar->SetMaxValue(100);
					baseView->AddChild(myStatusBar);
					myStatusBar->SetBarColor(rgb);
				break;
				}
				case KIND_STRINGDRAWER:
				{
					MyStringDrawer * stringDrawer = (MyStringDrawer *)msd;
					baseView->pmStringViewList->AddItem((void *)stringDrawer);
				break;
				}
				case KIND_MYRADIOVIEW:
				{
					MyRadioView * radioView = (MyRadioView *)rv;
					baseView->AddChild(radioView);
				break;
				}
				default :
				{
					warning("wrong kind lmi\n");
				break;
				}				
			}
		}
		numThingsTo = holdLayoutMatrix->mpItemsToDraw->CountItems();
		for (	int32 i = 0;
				i < numThingsTo;
				i++)
		{
			baseView->pmTextItemList->AddItem(holdLayoutMatrix->mpItemsToDraw->ItemAt(i));
		}
	}
	//from above, numItems = pLayoutMatrixList->CountItems();
	for (	int32 i = 0;
			i < numItems;
			i++)
	{
		delete (LayoutMatrix *)pLayoutMatrixList->ItemAt(i);
	}
	delete pLayoutMatrixList;
	UpdateScrollBars();//adjust knobs position and proportions
	Show();
	return true;
}//end


//adjust scroll bars to reflect new situation
void 
WindowGuts	::	UpdateScrollBars() 
{
	//puts the scroll bars in the proper perspective
	//this code was grabbed from the mandx sample
	//and converted from BBitMap to BView stuff
	if (LockLooper())
	{
		BScrollView * scrollview;
		BScrollBar * scrollbar;
		BRect visibleExtent;
		BRect totalExtent;
		BRect bound;
		BRect myBounds;
		long max;	
		scrollview = (BScrollView *)FindView(scrollViewName);
		if (scrollview) 
		{
			bound.Set(0, 0, underViewWidth, underViewHeight);
			myBounds = Bounds();
			visibleExtent = bound & myBounds;
			totalExtent = bound | myBounds;
			scrollbar = scrollview->ScrollBar(B_HORIZONTAL);
			max = bound.Width() - myBounds.Width();
			if (max < 0) 
			{
				max = 0;
			}
			scrollbar->SetRange(0, max);
			float proportion = visibleExtent.Width() / totalExtent.Width();
			scrollbar->SetProportion(proportion);
			float smallStep;
			float bigStep;
			if (proportion == .5)
			{
				smallStep = visibleExtent.Width() * .015;
				bigStep = visibleExtent.Width() / 2;
			}
			else if (proportion > .5)
			{
				smallStep = visibleExtent.Width() * .006;
				bigStep = totalExtent.Width() - visibleExtent.Width();
			}
			else 
			{
				smallStep = visibleExtent.Width() * .015;
				bigStep = totalExtent.Width() * proportion;
			}
			scrollbar->SetSteps(smallStep, bigStep);
			scrollbar = scrollview->ScrollBar(B_VERTICAL);
			max = bound.Height() - myBounds.Height();
			if (max < 0) 
			{
				max = 0;
			}
			scrollbar->SetRange(0, max);
			proportion = visibleExtent.Width() / totalExtent.Width();
			scrollbar->SetProportion(proportion);
			if (proportion == .5)
			{
				smallStep = visibleExtent.Width() * .015;
				bigStep = visibleExtent.Width() / 2;
			}
			else if (proportion > .5)
			{
				smallStep = visibleExtent.Width() * .006;
				bigStep = totalExtent.Width() - visibleExtent.Width();
			}
			else 
			{
				smallStep = visibleExtent.Width() * .015;
				bigStep = totalExtent.Width() * proportion;
			}
			scrollbar->SetSteps(smallStep, bigStep);
			baseView->Invalidate(baseView->Bounds());
		}
		else 
		{
			warning(NotFoundScrollView);
		}
		UnlockLooper();
	}
	else
	{
		warning(FailLockLooper);
	}
}//end


void 
WindowGuts	::	FrameResized(	float, /*note that by NOT naming these we avoid the "unused parameter" warning*/
								float) 
{
	UpdateScrollBars();
}//end


bool
WindowGuts	::	QuitRequested(	void) 
{
	Preferences appsPreferences(PrefSignature);
	PreferenceSet appsPreferenceSet(	appsPreferences,  
										"hierarchical/extendable/settings", 
										true);
	if (appsPreferences.InitCheck())
	{
		puts(PrefFailInit);
		exit(1);
	}
	if (appsPreferenceSet.InitCheck())
	{
		puts(PrefFailGetSettings);
		exit(2);
	}
	/*	save our position	*/
	bool allSetsOK = true;
	BRect frame = Frame();
	if (appsPreferenceSet.SetData(NamePrefFrame, &frame, sizeof(frame), B_RECT_TYPE))
	{
		warning(PrefNoSetGutFrame);
		allSetsOK = false;
	}
	if (allSetsOK)
	{
		if (appsPreferenceSet.Save())
		{
			warning(PrefsNoSaveSet);
		}
	}
	return true;
}//end


void
WindowGuts	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_WINDOWGUTS:	
		{
			warning(AboutGutMsg);//should never get here!
		break;
		}
		default:
			BWindow::MessageReceived(pparamMessage);
		break;
	}
}//end


void
WindowGuts	::	AddToLayoutMatrixList(	LayoutMatrix * pparamLayoutMatrix)
{
	pLayoutMatrixList->AddItem((void *)pparamLayoutMatrix);
}//end