//stringGadget.cpp

#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "XstringGadget.h"
#include "stringGadget.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"

StringGadget	::	~StringGadget() 
{
	//left blank
};//end


//ctor
StringGadget	::	StringGadget(	const char * paramName, 
									const char * paramLabel, 
									const char * paramText, 
									uint32 ui32paramMsg, 
									uint32 ui32paramMode, 
									uint32 ui32paramFlags,
									float fparamPixWidth,
									LayoutMatrix * lpparamLayoutMatrix,
									bool bparamMakeFocus) 
		: 
			BTextControl(	BRect(0, 0, 32, 32), 
							paramName, 
							paramLabel, 
							paramText, 
							new BMessage(ui32paramMsg), 
							ui32paramMode, 
							ui32paramFlags),
			 bmMakeFocus(	bparamMakeFocus)
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	SetFont(myPrefs->GetPreferredFont());
	if (fparamPixWidth)
	{
		mfPixWidth = fparamPixWidth;
	}
	else
	{
		BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		bv.SetFont(myPrefs->GetPreferredFont());
		mfPixWidth = bv.StringWidth(paramLabel);
	}
}//end


void 
StringGadget	::	AttachedToWindow(	void)
{
	SetDrawingMode(B_OP_ADD);
	BTextControl	::	AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredStringGadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredStringGadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredStringGadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	if (bmMakeFocus) 
	{
		MakeFocus();
	}
}//end