//myCheckBox.h

#include "layoutMatrixItem.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"
#include "XmyCheckBox.h"
#include "myCheckBox.h"
#include "layoutMatrix.h"

MyCheckBox	::	~MyCheckBox() 
{
	//left blank
};//end


//ctor
MyCheckBox	::	MyCheckBox(	const char * paramName, 
							const char * paramLabel,
							int32 i32Value,
							uint32 ui32paramMsg,
							uint32 ui32paramResizeMask,
							uint32 ui32paramFlags,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BCheckBox(	BRect(0, 0, 32, 32),
								paramName, 
								paramLabel,
								new BMessage(ui32paramMsg),
								ui32paramResizeMask, 
								ui32paramFlags)
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	SetFont(myPrefs->GetPreferredFont());
	SetValue(i32Value);
}//end


void 
MyCheckBox	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyCheckBoxHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyCheckBoxLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyCheckBoxViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end