//layoutMatrixItem.cpp

#include <memory>
#include "uInt32Gadget.h"
#include "floatGadget.h"
#include "stringGadget.h"
#include "Xwarning.h"
#include "XcolorWell.h"
#include "colorWell.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myStatusBar.h"
#include "myPopUpMenu.h"
#include "myTextView.h"
#include "myListView.h"
#include "myRadioView.h"
#include "XlayoutMatrixItem.h"
#include "layoutMatrixItem.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"
#include "dataNode.h"

//dtor
LayoutMatrixItem	::	~LayoutMatrixItem()
{
	//left blank
}


//ctor
LayoutMatrixItem	::	LayoutMatrixItem(	void * paramItem, 
											BList * pparamMatrixItemList,
											const uint32 paramKind)
					: 	item(paramItem), 
						kind(paramKind),
						last(false)
{
	pparamMatrixItemList->AddItem(this);
}//end


//calculates the minimum appropriate width and height
//of a matrix item
void 
LayoutMatrixItem	::	Calc() 
{
	const float pad = 11;
	const float cfAlignPad = 6;
	//use pad to give a bit of room at each end of the
	//button to set off the button text
	BRect br(0, 0, 32, 32);
	BWindow bw(	br, 
				NoShowWindow, 
				B_DOCUMENT_WINDOW, 
				/*B_WILL_ACCEPT_FIRST_CLICK*/0);
	BView view(br, NoShowView, B_FOLLOW_NONE, NULL);
	//need to attach these items to a BView before they can be measured
	bw.AddChild(&view);
	view.SetFont(myPrefs->GetPreferredFont());
	//set the view's font so the buttons will inherit them
	//when size is checked
	switch (kind) 
	{
		case KIND_STRINGDRAWER:
		{
			view.AddChild((BStringView *)item);
			view.SetFont(((MyStringDrawer *)item)->GetFont());
			float labelWidth = pad + view.StringWidth(((BStringView *)item)->Text());
			((MyStringDrawer *)item)->MyGetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BStringView *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BStringView *)item);
		break;
		}
		case KIND_MYPOPUPMENU:
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			float totalHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			//((MyPopUpMenu *)item)->descender = (fontHeight.ascent - fontHeight.descent) / 2;
			((MyPopUpMenu *)item)->descender = (totalHeight - fontHeight.descent);
			float prefWidth;
			float prefHeight;
			((BMenuBar *)item)->GetPreferredSize(&prefWidth, &prefHeight);
			heightPref = totalHeight;
			if (prefHeight > heightPref)
			{
				heightPref = prefHeight;
			}
			((MyPopUpMenu *)item)->SetTop(heightPref);//store this temp value until time to really place item
			widthPref = ((MyPopUpMenu *)item)->fmWidest;
			if (prefWidth > widthPref)
			{
				widthPref = prefWidth;
			}
			((MyPopUpMenu *)item)->ResizeTo(heightPref, widthPref);
		break;
		case KIND_MYTEXTVIEW:
			((MyTextView *)item)->MyGetPreferredSize(&widthPref, &heightPref);
		break;
		case KIND_MYLISTVIEW:
		{
			((BListView *)item)->GetPreferredSize(&widthPref, &heightPref);
			float	width,
					height;
			((MyListView *)item)->MyGetPreferredSize(&width, &height);
			if (width > widthPref)
			{
				if (height > heightPref)
					{
					((BListView *)item)->ResizeTo(width, height);
				}
				else
				{
					((BListView *)item)->ResizeTo(width, heightPref);
				}
			}
			if (height > heightPref)
			{
				if (width > widthPref)
				{
					((BListView *)item)->ResizeTo(width, height);
				}
				else
				{
					((BListView *)item)->ResizeTo(widthPref, height);
				}
			}
		break;
		}
		case KIND_MYBUTTON: 
		{
			view.AddChild((BButton *)item);
			float labelWidth = pad + view.StringWidth(((BButton *)item)->Label());
			((BButton *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			//If I added the following 8 lines back normal system padding returns--ugly!
//			if (labelWidth > widthPref) 
//			{
//				widthPref = labelWidth;
//			}
//			else 
//			{
//				labelWidth = widthPref;
//			}
//			//then use the smaller width--might be good to perform
//			//the same opperation for height, though the preferred 
//			//height seems OK--though the more I look less I like
//			//the height--debug
//			if (labelHeight > heightPref) 
//			{
//				heightPref = labelHeight;
//			}
//			else 
//			{
//				labelHeight = heightPref;
//			}
			((BButton *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BButton *)item);
		break;
		}
		case KIND_MYCHECKBOX: 
		{
			view.AddChild((BCheckBox *)item);
			float labelWidth = pad + view.StringWidth(((BCheckBox *)item)->Label());
			((BCheckBox *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BCheckBox *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BCheckBox *)item);
		break;
		}
		case KIND_MYSTATUSBAR: 
		{
			view.AddChild((BStatusBar *)item);
			((MyStatusBar *)item)->MyGetPreferredSize(&widthPref, &heightPref);
			((BStatusBar *)item)->ResizeTo(widthPref, heightPref);
			view.RemoveChild((BStatusBar *)item);
		break;
		}
		case KIND_MYPICTUREBUTTON: 
		{
			view.AddChild((BPictureButton *)item);
			float labelWidth = pad + view.StringWidth(((BPictureButton *)item)->Label());
			((BPictureButton *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BPictureButton *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BPictureButton *)item);
		break;
		}
		case KIND_MYCOLORCONTROL: 
		{
			view.AddChild((BColorControl *)item);
			((BColorControl *)item)->GetPreferredSize(&widthPref, &heightPref);
			view.RemoveChild((BColorControl *)item);
		break;
		}
		case KIND_MYRADIOVIEW: 
		{
			view.AddChild((MyRadioView *)item);
			((MyRadioView *)item)->GetPreferredSize(&widthPref, &heightPref);
			view.RemoveChild((MyRadioView *)item);
		break;
		}
		case KIND_INTGADG: 
		{
			view.AddChild((UInt32Gadget *)item);
			((UInt32Gadget *)item)->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
			((UInt32Gadget *)item)->GetPreferredSize(&widthPref, &heightPref);
			((UInt32Gadget *)item)->SetDivider(((UInt32Gadget *)item)->mfPixWidth + cfAlignPad);
			float inputWidth = view.StringWidth("0404040404");
			widthPref = pad + inputWidth + ((UInt32Gadget *)item)->mfPixWidth + cfAlignPad;
			((UInt32Gadget *)item)->ResizeTo(widthPref, heightPref);
			//BView * child = ((BView *)item)->ChildAt(0);
			//float excess = 20;//debug calculate??
			//child->ResizeBy(0, heightPref - excess);
			//child->SetFont(paramFont);//doesn't do any good
			view.RemoveChild((UInt32Gadget *)item);
		break;
		}
		case KIND_FLOATGADG: 
		{
			view.AddChild((FloatGadget *)item);
			((FloatGadget *)item)->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
			((FloatGadget *)item)->GetPreferredSize(&widthPref, &heightPref);
			((FloatGadget *)item)->SetDivider(((UInt32Gadget *)item)->mfPixWidth + cfAlignPad);
			float inputWidth = view.StringWidth("0404040404");
			widthPref = pad + inputWidth + ((FloatGadget *)item)->mfPixWidth + cfAlignPad;
			((FloatGadget *)item)->ResizeTo(widthPref, heightPref);
			//BView * child = ((BView *)item)->ChildAt(0);
			//float excess = 20;//debug calculate??
			//child->ResizeBy(0, heightPref - excess);
			//child->SetFont(paramFont);//doesn't do any good
			view.RemoveChild((FloatGadget *)item);
		break;
		}
		case KIND_STRINGGADG: 
		{
			view.AddChild((StringGadget *)item);
			((StringGadget *)item)->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
			float labelWidth = pad + view.StringWidth(((StringGadget *)item)->Label());
			((StringGadget *)item)->GetPreferredSize(&widthPref, &heightPref);
			((StringGadget *)item)->SetDivider(labelWidth + cfAlignPad);
			widthPref = labelWidth + ((StringGadget *)item)->mfPixWidth + cfAlignPad;
			((StringGadget *)item)->ResizeTo(widthPref, heightPref);
			view.RemoveChild((StringGadget *)item);
		break;
		}
		case KIND_TEXT: 
		{
			widthPref = pad + view.StringWidth(((TextItem *)item)->text);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			heightPref = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		break;
		}
		case KIND_COLORWELLGADG: 
		{
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			float totalHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			((ColorWell *)item)->descender = (fontHeight.ascent - fontHeight.descent) / 2;
			if (COLORWELLHEIGHT > totalHeight)
			{
				heightPref = COLORWELLHEIGHT;
			}
			else
			{
				heightPref = totalHeight;
			}
			((ColorWell *)item)->SetTop(heightPref);//store this temp value until time to really place item
			widthPref = pad + view.StringWidth((((ColorWell *)item)->GetTextItem())->text) + heightPref;
			((ColorWell *)item)->SetLeft(widthPref - heightPref - pad);//store this temp value until time to really place item
			float framing = ((ColorWell *)item)->Frame().Width();
			int32 int32Framing = ((ColorWell *)item)->Frame().IntegerWidth();
			if (framing > heightPref)
			{
				if (!(int32Framing % 2))
				{
					framing--;
				}
				((ColorWell *)item)->ResizeTo(framing, framing);
			}
			else
			{
				int32 int32HeightPref = heightPref;
				if (!(int32HeightPref % 2))
				{
					heightPref--;
				}
				((ColorWell *)item)->ResizeTo(heightPref, heightPref);
			}
		break;
		}
	}
	bw.RemoveChild(&view);
}//end
