//functions of EditPlanetWindow soi0.1

#include "windowGuts.h"
#include "editPlanetWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditPlanetWindow::SaveRequested(const char * fileName) 
{

SavePlanets(fileName);
}//end


EditPlanetWindow::EditPlanetWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

editPlanetWindow = this;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANET]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
}
else err = CREATEDNOTADDED;
if (!planetCurrent) if (dataListGlobal[PLANET_TYPE]->list->CountItems()) planetCurrent = (Planet *)((DataNode *)dataListGlobal[PLANET_TYPE]->list->ItemAt(0))->data;
}//end


EditPlanetWindow::~EditPlanetWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_PLANET]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
editPlanetWindow = NULL;
}//end


void EditPlanetWindow::AddPlanet(void) 
{

Planet * g = new Planet(planet, nameStrGadget->Text(), dataListGlobal[PLANET_TYPE]);
if (g) 
{
	if (err != CREATED) 
	{
		delete g;
		return;
	}
}
else err = NO_PLANET;
}//end


void EditPlanetWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[PLANET_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editPlanetWindow, dataListGlobal[PLANET_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidatePlanet();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanet();
			planetCurrent = planetNewCurrent;
			nameStrGadget->SetText(planetCurrent->name);
			thisDNPtr = dataListGlobal[PLANET_TYPE]->NextPrevItems((void *)planetCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Planet * prevPlanet = (Planet *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidatePlanet();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanet();
			planetCurrent = prevPlanet;
			nameStrGadget->SetText(planetCurrent->name);
			thisDNPtr = dataListGlobal[PLANET_TYPE]->NextPrevItems((void *)planetCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidatePlanet();
			if (err == NO_ERR) 
			{
				UpdatePlanet();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidatePlanet();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanet();
			planetCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidatePlanet();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddPlanet();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_PLANET]->SetLabel(editThe[PLANET_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidatePlanet();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanet();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadPlanets("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Planet * nextPlanet = (Planet *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidatePlanet();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdatePlanet();
			planetCurrent = nextPlanet;
			nameStrGadget->SetText(planetCurrent->name);
			thisDNPtr = dataListGlobal[PLANET_TYPE]->NextPrevItems((void *)planetCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditPlanetWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (planetCurrent) 
	{
		ValidatePlanet();
		if (err == NO_ERR) 
		{
			UpdatePlanet();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditPlanetWindow::ValidatePlanet(void) 
{

UniqueName(dataListGlobal[PLANET_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[PLANET_TYPE]);
	return;
}
if (planet->name) 
{
	if (strcmp(planet->name, nameStrGadget->Text())) 
	{
		free(planet->name);
		planet->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (planet->name) strcpy(planet->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditPlanetWindow::UpdatePlanet(void) 
{

err = NO_ERR;
if (planetCurrent) 
{
	if (strcmp(planetCurrent->name, nameStrGadget->Text())) 
	{
		if (planetCurrent->name) free(planetCurrent->name);
		planetCurrent->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (planetCurrent->name) strcpy(planetCurrent->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well
}
}//end


void EditPlanetWindow::SavePlanets(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditPlanetWindow::LoadPlanets(const char * fileName) 
{

LoadUniverse(fileName);
}//end
