/******************************************************************************/
/* MikAgent header file.                                                      */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MikAgent_h
#define __MikAgent_h

// PolyKit headers
#include "PString.h"
#include "PList.h"

// APlayer headers
#include "APAddOns.h"
#include "APList.h"


/******************************************************************************/
/* MikAgent class                                                             */
/******************************************************************************/
class MikConverter;

class MikAgent : public APAddOnAgent
{
public:
	MikAgent(APGlobalData *global);
	virtual ~MikAgent(void);

	float GetVersion(void);

	PString GetName(uint32 number);
	PString GetDescription(uint32 number);

	uint32 GetSupportFlags(void);

	bool InitAgent(void);
	void EndAgent(void);

	ap_result Plugin_AfterLoadingBeforeCheck(AfterLoadingBeforeCheckInfo *info);

protected:
	uint32 strings;

	PList<MikConverter *> converters;
};

#endif
