/******************************************************************************/
/* APList header file.                                                        */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __APList_h
#define __APList_h

// PolyKit headers
#include "POS.h"
#include "PSynchronize.h"
#include "PList.h"


/******************************************************************************/
/* APList class                                                               */
/******************************************************************************/
template<class TYPE>
class APList : public PList<TYPE>
{
public:
	inline void LockList(void) { locker.Lock(); };
	inline void UnlockList(void) { locker.Unlock(); };

protected:
	PMutex locker;
};

#endif
