//
// ControlWindow Implemention
//
// this belongs to the 'Tower of Benoi' Project
// Copyright 1998
//
// Written by: Marco Zinn
//

#ifndef	CONTROL_WINDOW_H
#define	CONTROL_WINDOW_H

//#include <InterfaceKit.h> // for the BSlider
//#include <string.h>

// Message-Constants
const uint32 STOP_PRESSED = 'Stop'; // Command for the message, that is send, when Stop-Button is pressed

// Forward declaration for DiscTowerView class. You'll find the definition in TowerWindow.h
class DiscTowerView; 

// Definition of ControlWindow class
//  This window controls the auto-solving-process
//  As it has no other use, it is only visible, when auto-solving is running.
//  It contains a slider which determins the speed of the solving (delay between moves)
//  and a Button to stop the whole process.
class ControlWindow : public BWindow {
	public:
		ControlWindow(BRect frame, const char* name);
		void SolveGame(DiscTowerView *FromTower, DiscTowerView *ToTower, DiscTowerView *BufferTower);
			// Starts the solving process
		void StopSolving();
			// Stops it
	private:
		void MessageReceived(BMessage *message);
		void MoveTower(DiscTowerView *FromTower, DiscTowerView *ToTower, DiscTowerView *BufferTower, int Discs);
			// Recursively called routine used for solving
		BSlider* SpeedSlider;
			// Pointer to the Slider
		bool StopFlag;
			// Flag for stopping the solving process
};
 
#endif /* CONTROL_WINDOW_H */ 