// in_beos.c

#include "quakedef.h"

#include <WindowScreen.h>
#include <Window.h>
#include <View.h>

extern BView *qview;
extern qboolean vid_connected;

int UseMouse = 1;

cvar_t  mouse_button_commands[3] =
{
    {"mouse1","+attack"},
    {"mouse2","+strafe"},
    {"mouse3","+forward"},
};

cvar_t	m_filter = {"m_filter","0"};

void Force_CenterView_f(void)
{
	cl.viewangles[PITCH] = 0;
}

void IN_Init (void)
{
	Cvar_RegisterVariable (&m_filter);

	if(UseMouse)
	{
		Cvar_RegisterVariable (&mouse_button_commands[0]);
		Cvar_RegisterVariable (&mouse_button_commands[1]);
		Cvar_RegisterVariable (&mouse_button_commands[2]);
		Cmd_AddCommand ("force_centerview", Force_CenterView_f);
	}
}

void IN_Shutdown (void)
{
}

void IN_Commands (void)
{
	static	uint32	 mbuttons_old;
			uint32   mbuttons_new;
			uint32	 mbuttons_diff;
	BPoint	point;

	if((qview!=NULL) && UseMouse)
		if(qview->Window()->Lock())
		{
			qview->GetMouse(&point, &mbuttons_new);
			mbuttons_diff = mbuttons_new ^ mbuttons_old;
			if(mbuttons_diff & B_PRIMARY_MOUSE_BUTTON)
				Key_Event( K_MOUSE1, (mbuttons_new&B_PRIMARY_MOUSE_BUTTON)?qtrue:qfalse);
			if(mbuttons_diff & B_SECONDARY_MOUSE_BUTTON)
				Key_Event( K_MOUSE2, (mbuttons_new&B_SECONDARY_MOUSE_BUTTON)?qtrue:qfalse);
			if(mbuttons_diff & B_TERTIARY_MOUSE_BUTTON)
				Key_Event( K_MOUSE3, (mbuttons_new&B_TERTIARY_MOUSE_BUTTON)?qtrue:qfalse);
			mbuttons_old = mbuttons_new;
			qview->Window()->Unlock();
		}
}

void IN_Move (usercmd_t *cmd)
{
	BPoint	point;
	float	dx,dy;
	uint32	mbuttons;

	if((qview!=NULL) && UseMouse && vid_connected)
		if(qview->Window()->Lock())
		{
			qview->GetMouse(&point, &mbuttons);
			if(m_filter.value)
			{
				dx = (point.x-(vid.width>>1))  * 0.5;
				dy = (point.y-(vid.height>>1)) * 0.5;
			}
			else
			{
				dx = point.x-(vid.width>>1);
				dy = point.y-(vid.height>>1);
			}
			dx *= sensitivity.value;
			dy *= sensitivity.value;

			if( (in_strafe.state & 1) || (lookstrafe.value && (in_mlook.state & 1) ))
				cmd->sidemove += (short)(m_side.value * dx);
			else
				cl.viewangles[YAW] -= m_yaw.value * dx;

			if( in_mlook.state & 1 )
				V_StopPitchDrift();

			if ( (in_mlook.state & 1) && !(in_strafe.state & 1))
			{
				cl.viewangles[PITCH] += m_pitch.value * dy;
				if (cl.viewangles[PITCH] > 80)
					cl.viewangles[PITCH] = 80;
				if (cl.viewangles[PITCH] < -70)
					cl.viewangles[PITCH] = -70;
			}
			else
			{
				if ((in_strafe.state & 1) && noclip_anglehack)
					cmd->upmove -= (short)(m_forward.value * dy);
				else
					cmd->forwardmove -= (short)(m_forward.value * dy);
			}

			set_mouse_position(vid.width>>1, vid.height>>1);
			qview->Window()->Unlock();
		}
}

/*
===========
IN_ModeChanged
===========
*/
void IN_ModeChanged (void)
{
}

