//Name:		TetrisView.h
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


#ifndef _TETRIS_VIEW_H_
#define _TETRIS_VIEW_H_


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <View.h>


//******************************************************************************************************
//**** TetrisView
//******************************************************************************************************
class TetrisView : public BView
{
	public:
		TetrisView(BRect frame, int8 width, int8 height, const BFont* font);

		void Reset();
		bool AddFallingBlock(int8 type);	//Returns false if the block can't be added (game over)
		bool MoveFallingBlockDown();		//Returns false if the block can't drop.  If
											//FallingBlockY()<0, game over
		inline int8 FallingBlockY() {return m_falling_block_y;}
		void MoveFallingBlockLeft();
		void MoveFallingBlockRight();
		void RotateFallingBlock();
		int8 AddFallingBlockToGrid();		//Adds the falling block to the grid, removes any full rows
											//Returns the number of rows removed, if any
		void SetGameOver();

		//BView overrides
		virtual void Draw(BRect update_rect);

	private:
		bool IsBlockOKAt(int8 type, int8 center_x, int8 center_y, int8 rotation);
		inline int8 GridBrickAt(int8 x, int8 y) {return m_grid[y*m_grid_width+x];}
		inline void SetGridBrickAt(int8 x, int8 y, int8 type) {m_grid[y*m_grid_width+x] = type;}											//rows, returns the number of rows removed.
		void AddFallingBlockToBitmap();
		void RemoveFallingBlockFromBitmap();

		int8* m_grid;						//0 = clear; 1-7 = landscape bricks
		int8 m_grid_width;
		int8 m_grid_height;
		BBitmap* m_grid_bitmap;
		uint32* m_grid_bitmap_data;
		int8 m_falling_block_type;			//-1 for none
		int8 m_falling_block_x;			//Position of center point of falling block
		int8 m_falling_block_y;
		int8 m_falling_block_rotation;		//0,1,2,3
		bool m_game_over;
		float m_font_ascent;
		BRect m_game_over_rect;
};


#endif //_TETRIS_VIEW_H_
