#ifndef BeNaLifeAppH
#define BeNaLifeAppH
//------------------------------------------------------------------------------
#include <Alert.h>
#include <Application.h>
#include <Directory.h>
#include <Entry.h>
#include <FindDirectory.h>
#include <Path.h>
#include <add/IniFile.h>
#include "BeNaLifeWindow.h"
#include "FieldView.h"
//------------------------------------------------------------------------------
const char	CustomSetSection[] = "CustomSet";	//環境設定セクション
const char	ExitStateSection[] = "ExitState";	//終了時の状態セクション
const char	IniFName[] = "BeNaLife.ini";			//初期化ファイル名
const char	IniFPath[] = "SHINTA";				//初期化ファイルパス
const char	LLMsgFName[][32] = { "BeNaLifeJp.llm","BeNaLifeEn.llm" };	//ローカライズファイル名
const int	MaxFLen = 2048;						//ファイルの１行の最大長
//------------------------------------------------------------------------------
class TBeNaLifeApp : public BApplication
{
private:
	virtual void	AboutRequested();
	void			LoadExitState();		//終了時の状態を読込む
	void			LoadLLMsg();			//メッセージを読込む
	void			MenuHelpClicked();
	virtual void	MessageReceived(BMessage *xMsg);
	void			ReadLLMsg(TSHIFile &xLLMsgF,BString &xMsg);	//メッセージを読込む
	virtual void	RefsReceived(BMessage *xMsg);
	void			SaveExitState();		//終了時の状態を保存
	
	TBeNaLifeWindow	*mxBLWin;				//メインウィンドウ
	TFieldView		*mxFieldView;			//フィールドビュー
protected:
public:
	TBeNaLifeApp();
	~TBeNaLifeApp();
};
//------------------------------------------------------------------------------
#endif	//BeNaLifeAppH
