/*============================================================================*/
const char	*gszAppName = "ＢeなＬife";
const char	*gszVer = "Ver 2.41";
const char	*gszCright = "Copyright (C) 1999 by ＳＨＩＮＴＡ";
const char	*gszFileType = "application/x-vnd.SHINTA-BeNaLife";
const char	*gszBuild = "1999.04.06";
/*============================================================================*/

/*==============================================================================
 Ver. |					主な改良点
--------------------------------------------------------------------------------
 ---- | 1999.02.03.We 開発着手。
 1.00 | 1999.02.10.We オリジナルバージョン。
 1.10 | 1999.02.11.Th ステップ実行できるようにした。
 1.20 | 1999.02.12.Fr 一括実行できるようにした。
 1.30 | 1999.02.14.Su データの保存・読み込みができるようにした。
 1.40 | 1999.02.16.Tu 環境設定コマンドをつけた。
 1.50 | 1999.02.17.We 終了時の状態を保存するようにした。
 1.60 | 1999.02.17.We ウィンドウサイズ最適化コマンドをつけた。
 1.70 | 1999.02.18.Th ランダム配置コマンドをつけた。
 1.80 | 1999.02.18.Th バージョン情報コマンドをつけた。
 1.90 | 1999.02.18.Th ヘルプコマンドをつけた。初公開。
 2.00 | 1999.03.07.Su ファイルのドロップを受け付けるようにした。
 2.10 | 1999.03.09.Tu ドラッグして生命体を配置できるようにした。
 2.20 | 1999.03.11.Th 編集メニューをつけた。
 2.30 | 1999.04.02.Fr 多言語対応にした。
 2.40 | 1999.04.06.Tu .lifファイルを読めるようにした。
==============================================================================*/

/*=== Memo =====================================================================
==============================================================================*/

#include "BeNaLifeApp.h"
//------------------------------------------------------------------------------
TBeNaLifeApp::TBeNaLifeApp() : BApplication(gszFileType)
{
	BRect			xBLWinFrame;
	
	LoadExitState();
	LoadLLMsg();
	xBLWinFrame = gxExitState->mxFrame;
	mxBLWin = new TBeNaLifeWindow(xBLWinFrame);
	mxFieldView = mxBLWin->FieldView();
	mxBLWin->Show();
}
//------------------------------------------------------------------------------
TBeNaLifeApp::~TBeNaLifeApp()
{
	SaveExitState();
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::AboutRequested()
{
	char	szTmp[512];
	BAlert	*xAlert;
	
	strcpy(szTmp,gxLLMsg->mxAppInfo[0].String());
	strcat(szTmp,"    ");
	strcat(szTmp,gszVer);
	strcat(szTmp,"\n");
	strcat(szTmp,gxLLMsg->mxAppInfo[1].String());
	xAlert = new BAlert("Title",szTmp,gxLLMsg->mxButtonOK.String());
	xAlert->Go();
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::LoadExitState()
{
//	app_info	xAppInfo;
//	BDirectory	xDirTmp;
//	BEntry		xEntry;
//	BEntry		xEntryTmp;
	BPath		xPath;
	TIniFile	xIniF;
	
	if ( find_directory(B_USER_SETTINGS_DIRECTORY,&xPath) != B_OK )
		return;
	xPath.Append(IniFPath);
	xPath.Append(IniFName);
	if ( xIniF.SetTo(xPath.Path(),B_READ_ONLY) != B_OK )
		return;
	xIniF.ChangeSection(ExitStateSection);
	xIniF.ReadValue("Left",&gxExitState->mxFrame.left);
	xIniF.ReadValue("Top",&gxExitState->mxFrame.top);
	xIniF.ReadValue("Right",&gxExitState->mxFrame.right);
	xIniF.ReadValue("Bottom",&gxExitState->mxFrame.bottom);
	xIniF.ReadValue("OPanelPath",gxExitState->mszOPanelPath);
	xIniF.ReadValue("SPanelPath",gxExitState->mszSPanelPath);
	xIniF.ChangeSection(CustomSetSection);
	xIniF.ReadValue("XBlocks",(int32*)&gxCustomSet->miXBlocks);
	xIniF.ReadValue("YBlocks",(int32*)&gxCustomSet->miYBlocks);
	xIniF.ReadValue("XBlockSize",(int32*)&gxCustomSet->miXBlockSize);
	xIniF.ReadValue("YBlockSize",(int32*)&gxCustomSet->miYBlockSize);
	xIniF.ReadValue("CtrlViewColor",&gxCustomSet->mxCtrlViewColor);
	xIniF.ReadValue("LifeColor",&gxCustomSet->mxLifeColor);
	xIniF.ReadValue("EmptyColor",&gxCustomSet->mxEmptyColor);
	xIniF.ReadValue("Interval",(int32*)&gxCustomSet->miInterval);
	xIniF.ReadValue("Language",(int32*)&gxCustomSet->miLang);
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::LoadLLMsg()
{
//	char		cTmp[MaxFLen+1];
	int			i;
	app_info	xAppInfo;
	BDirectory	xDirTmp;
	BEntry		xEntry;
	BEntry		xEntryTmp;
	BString		xErrMsg;
	BString		xStrTmp;
	TSHIFile	xLLMsgF;

	be_app->GetAppInfo(&xAppInfo);
	xEntryTmp.SetTo(&xAppInfo.ref);
	xEntryTmp.GetParent(&xDirTmp);
	xEntry.SetTo(&xDirTmp,LLMsgFName[gxCustomSet->miLang]);
	if ( xLLMsgF.SetTo(&xEntry,B_READ_ONLY) != B_NO_ERROR )
		return;
	ReadLLMsg(xLLMsgF,gxLLMsg->mxLLMsgFErr);
	for ( i = 0 ; i < 2 ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxHelpErr[i]);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxNotOpenErr);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxDiffeFmtErr);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxNotSaveErr);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxNewConfirm);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxOWConfirm);
	for ( i = 0 ; i <= miQuit ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxMenuFile[i]);
	for ( i = 0 ; i <= miSelAll ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxMenuEdit[i]);
	for ( i = 0 ; i <= miEnbloc ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxMenuGene[i]);
	for ( i = 0 ; i <= miRandom ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxMenuTool[i]);
	for ( i = 0 ; i <= miAbout ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxMenuHelp[i]);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxMItemEnbloc);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxSetFCmt);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxSetWinTitle);
	for ( i = 0 ; i < 2 ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxAlertCaption[i]);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxOPanelTitle);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxSPanelTitle);
	for ( i = 0 ; i < 2 ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxAppInfo[i]);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonHelp);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonCancel);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonOK);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonNo);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonYes);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonOpen);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonSave);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonGo);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonStop);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonStep);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonEnbloc);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxEditEnbloc);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxLabelEnbloc);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxBoxField);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxBoxBlock);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxLabelWidth);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxLabelHeight);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxBoxCol);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonPanelCol);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonLifeCol);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxButtonEmptyCol);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxLabelInterval);
	ReadLLMsg(xLLMsgF,gxLLMsg->mxBoxLang);
	for ( i = 0 ; i < 2 ; i++ )
		ReadLLMsg(xLLMsgF,gxLLMsg->mxRButtonLang[i]);
	ReadLLMsg(xLLMsgF,xStrTmp);
#ifdef DEBUGz
	char cTmp[256];
	strcpy(cTmp,xStrTmp.String());
#endif
	if ( xStrTmp != "@End" ) {
		xErrMsg = gxLLMsg->mxLLMsgFErr << "\n" << LLMsgFName[gxCustomSet->miLang];
		AlertErr(xErrMsg);
	}
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::MenuHelpClicked()
{
	ShowHelp();
}
//------------------------------------------------------------------------------
void TBeNaLifeApp::MessageReceived(BMessage *xMsg)
{
	switch( xMsg->what ) {
	case MENUHELP_CLICKED:
		MenuHelpClicked();
		break;
	default:
		BApplication::MessageReceived(xMsg);
	}
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::ReadLLMsg(TSHIFile &xLLMsgF,BString &xMsg)
{
	char	cTmp[MaxFLen+1];
	
	if ( xLLMsgF.ReadValidLine(cTmp,MaxFLen+1) == 0 )
		return;
	while ( repstr(cTmp,cTmp,"\\n","\n") != 0 ) {}
	xMsg = cTmp;
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::RefsReceived(BMessage *xMsg)
{
#if 0
	BAlert	*xAlert;
		xAlert = new BAlert("Title","RefRec","ＯＫ",NULL,NULL,B_WIDTH_AS_USUAL
				,B_OFFSET_SPACING,B_WARNING_ALERT);
		xAlert->Go();
#endif
	mxBLWin->Lock();
	DispatchMessage(xMsg,mxFieldView);
	mxBLWin->Unlock();
}
//------------------------------------------------------------------------------
void	TBeNaLifeApp::SaveExitState()
{
//	app_info	xAppInfo;
//	BDirectory	xDirTmp;
//	BEntry		xEntry;
//	BEntry		xEntryTmp;
	BPath		xPath;
	TIniFile	xIniF;
	
//	be_app->GetAppInfo(&xAppInfo);
//	xEntryTmp.SetTo(&xAppInfo.ref);
//	xEntryTmp.GetParent(&xDirTmp);
//	xEntry.SetTo(&xDirTmp,IniFName);
	if ( find_directory(B_USER_SETTINGS_DIRECTORY,&xPath,true) != B_OK )
		return;
	xPath.Append(IniFPath);
	create_directory(xPath.Path(),0777);
	xPath.Append(IniFName);
	if ( xIniF.SetTo(xPath.Path(),B_WRITE_ONLY|B_CREATE_FILE|B_ERASE_FILE) != B_OK )
		return;
	xIniF.WriteComment(gxLLMsg->mxSetFCmt.String());
	xIniF.ChangeSection(ExitStateSection);
	xIniF.WriteValue("Left",gxExitState->mxFrame.left);
	xIniF.WriteValue("Top",gxExitState->mxFrame.top);
	xIniF.WriteValue("Right",gxExitState->mxFrame.right);
	xIniF.WriteValue("Bottom",gxExitState->mxFrame.bottom);
	xIniF.WriteValue("OPanelPath",gxExitState->mszOPanelPath);
	xIniF.WriteValue("SPanelPath",gxExitState->mszSPanelPath);
	xIniF.ChangeSection(CustomSetSection);
	xIniF.WriteValue("XBlocks",(int32)gxCustomSet->miXBlocks);
	xIniF.WriteValue("YBlocks",(int32)gxCustomSet->miYBlocks);
	xIniF.WriteValue("XBlockSize",(int32)gxCustomSet->miXBlockSize);
	xIniF.WriteValue("YBlockSize",(int32)gxCustomSet->miYBlockSize);
	xIniF.WriteValue("CtrlViewColor",gxCustomSet->mxCtrlViewColor);
	xIniF.WriteValue("LifeColor",gxCustomSet->mxLifeColor);
	xIniF.WriteValue("EmptyColor",gxCustomSet->mxEmptyColor);
	xIniF.WriteValue("Interval",(int32)gxCustomSet->miInterval);
	xIniF.WriteValue("Language",(int32)gxCustomSet->miLang);
}
//------------------------------------------------------------------------------
int main()
{
	TBeNaLifeApp	*xBLApp;
	
	gxAppPrivacy = new TAppPrivacy();
	gxCustomSet = new TCustomSet();
	gxExitState = new TExitState();
	gxLLMsg = new TLLMsg();
	xBLApp = new TBeNaLifeApp();
	xBLApp->Run();
	delete xBLApp;
	delete gxLLMsg;
	delete gxExitState;
	delete gxCustomSet;
	delete gxAppPrivacy;
	return 1;
}
//------------------------------------------------------------------------------
