// CPalette.cpp

#include <BeHeaders>

#include "CPalette.h"
#include "osdepend.h"

rgb_color		CPalette::sInitPalette[kNumColors] = {
	{0x00, 0x00, 0x00},
	{0x11, 0x11, 0x11},
	{0x22, 0x22, 0x22},
	{0x33, 0x33, 0x33},
	{0x44, 0x44, 0x44},
	{0x55, 0x55, 0x55},
	{0x66, 0x66, 0x66},
	{0x77, 0x77, 0x77},
	{0x88, 0x88, 0x88},
	{0x99, 0x99, 0x99},
	{0xaa, 0xaa, 0xaa},
	{0xbb, 0xbb, 0xbb},
	{0xcc, 0xcc, 0xcc},
	{0xdd, 0xdd, 0xdd},
	{0xee, 0xee, 0xee},
	{0xff, 0xff, 0xff},

	{0x00, 0x00, 0x00},
	{0x11, 0x00, 0x00},
	{0x22, 0x00, 0x00},
	{0x33, 0x00, 0x00},
	{0x44, 0x00, 0x00},
	{0x55, 0x00, 0x00},
	{0x66, 0x00, 0x00},
	{0x77, 0x00, 0x00},
	{0x88, 0x00, 0x00},
	{0x99, 0x00, 0x00},
	{0xaa, 0x00, 0x00},
	{0xbb, 0x00, 0x00},
	{0xcc, 0x00, 0x00},
	{0xdd, 0x00, 0x00},
	{0xee, 0x00, 0x00},
	{0xff, 0x00, 0x00},

	{0x00, 0x00, 0x00},
	{0x00, 0x11, 0x00},
	{0x00, 0x22, 0x00},
	{0x00, 0x33, 0x00},
	{0x00, 0x44, 0x00},
	{0x00, 0x55, 0x00},
	{0x00, 0x66, 0x00},
	{0x00, 0x77, 0x00},
	{0x00, 0x88, 0x00},
	{0x00, 0x99, 0x00},
	{0x00, 0xaa, 0x00},
	{0x00, 0xbb, 0x00},
	{0x00, 0xcc, 0x00},
	{0x00, 0xdd, 0x00},
	{0x00, 0xee, 0x00},
	{0x00, 0xff, 0x00},
	
	{0x00, 0x00, 0x00},
	{0x00, 0x00, 0x11},
	{0x00, 0x00, 0x22},
	{0x00, 0x00, 0x33},
	{0x00, 0x00, 0x44},
	{0x00, 0x00, 0x55},
	{0x00, 0x00, 0x66},
	{0x00, 0x00, 0x77},
	{0x00, 0x00, 0x88},
	{0x00, 0x00, 0x99},
	{0x00, 0x00, 0xaa},
	{0x00, 0x00, 0xbb},
	{0x00, 0x00, 0xcc},
	{0x00, 0x00, 0xdd},
	{0x00, 0x00, 0xee},
	{0x00, 0x00, 0xff},

	{0x00, 0x00, 0x00},
	{0x11, 0x11, 0x00},
	{0x22, 0x22, 0x00},
	{0x33, 0x33, 0x00},
	{0x44, 0x44, 0x00},
	{0x55, 0x55, 0x00},
	{0x66, 0x66, 0x00},
	{0x77, 0x77, 0x00},
	{0x88, 0x88, 0x00},
	{0x99, 0x99, 0x00},
	{0xaa, 0xaa, 0x00},
	{0xbb, 0xbb, 0x00},
	{0xcc, 0xcc, 0x00},
	{0xdd, 0xdd, 0x00},
	{0xee, 0xee, 0x00},
	{0xff, 0xff, 0x00},

	{0x00, 0x00, 0x00},
	{0x11, 0x00, 0x11},
	{0x22, 0x00, 0x22},
	{0x33, 0x00, 0x33},
	{0x44, 0x00, 0x44},
	{0x55, 0x00, 0x55},
	{0x66, 0x00, 0x66},
	{0x77, 0x00, 0x77},
	{0x88, 0x00, 0x88},
	{0x99, 0x00, 0x99},
	{0xaa, 0x00, 0xaa},
	{0xbb, 0x00, 0xbb},
	{0xcc, 0x00, 0xcc},
	{0xdd, 0x00, 0xdd},
	{0xee, 0x00, 0xee},
	{0xff, 0x00, 0xff},

	{0x00, 0x00, 0x00},
	{0x00, 0x11, 0x11},
	{0x00, 0x22, 0x22},
	{0x00, 0x33, 0x33},
	{0x00, 0x44, 0x44},
	{0x00, 0x55, 0x55},
	{0x00, 0x66, 0x66},
	{0x00, 0x77, 0x77},
	{0x00, 0x88, 0x88},
	{0x00, 0x99, 0x99},
	{0x00, 0xaa, 0xaa},
	{0x00, 0xbb, 0xbb},
	{0x00, 0xcc, 0xcc},
	{0x00, 0xdd, 0xdd},
	{0x00, 0xee, 0xee},
	{0x00, 0xff, 0xff},
};

CPalette::CPalette(
	BWindowScreen		*inWindow)
{
	rgb_color		*colorList;
	uint32		i;
	
	mQuitting = false;
	mWindow = inWindow;
	colorList = mWindow->ColorList();
	
	for (i=0; i<256; i++) {
		mColors[i] = colorList[i];
		mDirtyColor[i] = false;
	}
}

CPalette::~CPalette()
{
	status_t		val;
	
	mQuitting = true;

	wait_for_thread(mID, &val);
}

void
CPalette::InitPalette()
{
	int32	i;
	
	for (i=0; i<kNumColors; i++)
		SetPen(i, sInitPalette[i].red, sInitPalette[i].green, sInitPalette[i].blue);
}

void
CPalette::SetPen(
	uint8		inPenIndex,
	uint8		inRed,
	uint8		inGreen,
	uint8		inBlue)
{
	mColors[inPenIndex].red = inRed;
	mColors[inPenIndex].green = inGreen;
	mColors[inPenIndex].blue = inBlue;
	mDirtyColor[inPenIndex] = true;
}

void
CPalette::GetPen(
	uint8		inPenIndex,
	uint8		*outRed,
	uint8		*outGreen,
	uint8		*outBlue)
{
	*outRed = mColors[inPenIndex].red;
	*outGreen = mColors[inPenIndex].green;
	*outBlue = mColors[inPenIndex].blue;
}

int32
CPalette::Entry(
	void		*arg)
{
	CPalette	*obj = (CPalette *)arg;
	
	return (obj->MainLoop());
}

void
CPalette::WaitForVBlank()
{
//	BScreen		theScreen(mWindow);
	
//	theScreen.WaitForRetrace();
	snooze(1000000/60);		// 60 times a second
}

int32
CPalette::MainLoop()
{
	uint32		i;
	
	while (!mQuitting) {
		WaitForVBlank();
		
		for (i=0; i<256 && !mQuitting; i++) {
			if (mDirtyColor[i]) {
				mWindow->SetColorList(&mColors[i], i, i);
				mDirtyColor[i] = false;
			}
		}
	}

	return 0;
}

int32
CPalette::Go()
{
	mID = spawn_thread(Entry, "Color Wathcher", B_URGENT_PRIORITY, this);
	return (resume_thread(mID));
}

