// CMAMEDisplay.h

#pragma once

class CMAMEDisplay {
public:
	static CMAMEDisplay	*CreateMAMEDisplay(
							int			argc,
							char 		**argv);
						CMAMEDisplay();
						~CMAMEDisplay();
						
	virtual void			Init() = 0;
	virtual void			Exit() = 0;
	virtual void			InitPalette() = 0;
	virtual void			SetPen(
							int16		inPen,
							uchar		inRed,
							uchar		inGreen,
							uchar		inBlue) = 0;
	virtual void			GetPen(
							int16		inPen,
							uchar		*outRed,
							uchar		*outGreen,
							uchar		*outBlue) = 0;
	virtual void			Resize(
							int16		inWidth,
							int16		inHeight) = 0;
	virtual void			CopyBits(
							void			*inSrc,
							int16		inHeight,
							int16		inWidth) = 0;
	virtual void			PollMouse() = 0;
	virtual void			ReadMouse(
							int16		*outX,
							int16		*outY) = 0;
	
private:
	static status_t		sWinErr;
};