/*** konami: Portable Konami cpu emulator ******************************************/

#ifndef _KONAMI_H
#define _KONAMI_H

#include "memory.h"
#include "osd_cpu.h"

enum {
	KONAMI_PC=1, KONAMI_S, KONAMI_CC ,KONAMI_A, KONAMI_B, KONAMI_U, KONAMI_X, KONAMI_Y,
	KONAMI_DP, KONAMI_NMI_STATE, KONAMI_IRQ_STATE, KONAMI_FIRQ_STATE };

#define KONAMI_INT_NONE  0   /* No interrupt required */
#define KONAMI_INT_IRQ	1	/* Standard IRQ interrupt */
#define KONAMI_INT_FIRQ	2	/* Fast IRQ */
#define KONAMI_INT_NMI	4	/* NMI */	/* NS 970909 */
#define KONAMI_IRQ_LINE	0	/* IRQ line number */
#define KONAMI_FIRQ_LINE 1   /* FIRQ line number */

/* PUBLIC GLOBALS */
extern int  konami_ICount;
extern void (*konami_cpu_setlines_callback)( int lines ); /* callback called when A16-A23 are set */

/* PUBLIC FUNCTIONS */
extern void konami_reset(void *param);
extern void konami_exit(void);
extern int konami_execute(int cycles);  /* NS 970908 */
extern unsigned konami_get_context(void *dst);
extern void konami_set_context(void *src);
extern unsigned konami_get_pc(void);
extern void konami_set_pc(unsigned val);
extern unsigned konami_get_sp(void);
extern void konami_set_sp(unsigned val);
extern unsigned konami_get_reg(int regnum);
extern void konami_set_reg(int regnum, unsigned val);
extern void konami_set_nmi_line(int state);
extern void konami_set_irq_line(int irqline, int state);
extern void konami_set_irq_callback(int (*callback)(int irqline));
extern void konami_state_save(void *file);
extern void konami_state_load(void *file);
extern const char *konami_info(void *context,int regnum);
extern unsigned konami_dasm(char *buffer, unsigned pc);

/****************************************************************************/
/* Read a byte from given memory location									*/
/****************************************************************************/
/* ASG 971005 -- changed to cpu_readmem16/cpu_writemem16 */
#define KONAMI_RDMEM(Addr) ((unsigned)cpu_readmem16(Addr))

/****************************************************************************/
/* Write a byte to given memory location                                    */
/****************************************************************************/
#define KONAMI_WRMEM(Addr,Value) (cpu_writemem16(Addr,Value))

/****************************************************************************/
/* Z80_RDOP() is identical to Z80_RDMEM() except it is used for reading     */
/* opcodes. In case of system with memory mapped I/O, this function can be  */
/* used to greatly speed up emulation                                       */
/****************************************************************************/
#define KONAMI_RDOP(Addr) ((unsigned)cpu_readop(Addr))

/****************************************************************************/
/* Z80_RDOP_ARG() is identical to Z80_RDOP() except it is used for reading  */
/* opcode arguments. This difference can be used to support systems that    */
/* use different encoding mechanisms for opcodes and opcode arguments       */
/****************************************************************************/
#define KONAMI_RDOP_ARG(Addr) ((unsigned)cpu_readop_arg(Addr))

/****************************************************************************/
/* Flags for optimizing memory access. Game drivers should set m6809_Flags  */
/* to a combination of these flags depending on what can be safely          */
/* optimized. For example, if M6809_FAST_OP is set, opcodes are fetched     */
/* directly from the ROM array, and cpu_readmem() is not called.            */
/* The flags affect reads and writes.                                       */
/****************************************************************************/
extern int konami_Flags;
#define KONAMI_FAST_NONE	0x00	/* no memory optimizations */
#define KONAMI_FAST_S	0x02	/* stack */
#define KONAMI_FAST_U	0x04	/* user stack */

#ifndef FALSE
#    define FALSE 0
#endif
#ifndef TRUE
#    define TRUE (!FALSE)
#endif

#ifdef MAME_DEBUG
extern unsigned Dasmknmi (char *buffer, unsigned pc);
#endif

#endif /* _KONAMI_H */
