/*
	CMameDisplay.cc
	The BeMAME Team
	Created: 07/15/99 08:23:33
*/

#include <DirectWindow.h>
#include "CMameDisplay.h"
#include "CMameScreen.h"
#include "CMameDirectWin.h"
#include "CMameWindow.h"
#include "CMameView.h"

CMameDisplay	*gDisplay = NULL;

void
CMameDisplay::CreateMameDisplay(
	status_t		*outRet,
	BRect			inFrame,
	int				inColorDepth,
	bool			inFullScreen)
{
	CMameView::ClearQuit();
	
	if (inFullScreen)
		gDisplay = new CMameScreen(outRet, inFrame, inColorDepth);
	else {
		if (BDirectWindow::SupportsWindowMode())
			gDisplay = new CMameDirectWin(outRet, inFrame, inColorDepth);
		else
			gDisplay = new CMameWindow(outRet, inFrame, inColorDepth);
	}
}

CMameDisplay::CMameDisplay()
{
}

CMameDisplay::~CMameDisplay()
{
	gDisplay = NULL;
}

void
CMameDisplay::WaitToQuit()
{
	extern volatile bool MameIsRunning;
	int			L;

	// Signal that user wants to exit...
	CMameView::SetQuit();

	// We should be sure that MAME has finished before,
	//  continuing, so wait for MameIsRunning to be set.

	// Give mame a chance to exit before we continue
	for (L=0; /*L<30 &&*/ MameIsRunning; ++L) {
		snooze (100000);	// .1 seconds
	}
}

void
CMameDisplay::GetMouseDelta(
	int				*outDeltaX,
	int				*outDeltaY)
{
	mView->GetMouseDelta(outDeltaX, outDeltaY);
}

int
CMameDisplay::ReadKey(
	int				inKeycode)
{
	return CMameView::ReadKey(inKeycode);
}

