//Hammurabi
//Matt Wronkiewicz, 1997 10 12


#include "HamAlert.h"
#include "Hammurabi.h"
#include "BitmapView.h"


HamAlert::HamAlert (const char* message, const char* image_name, bool new_is_end)
	:BWindow(BRect(100, 100, 256, 128), "Advisor's Report", B_MODAL_WINDOW, B_NOT_RESIZABLE, B_CURRENT_WORKSPACE)
	{
	is_end = new_is_end;
	
	BRect rect = Bounds();
	
	BMessage msg;
	((Hammurabi*)be_app)->GetResource(image_name, &msg);
	BitmapView* outView = new BitmapView(BBitmap::Instantiate(&msg), "");
	BRect extent = outView->Bounds();
	
	rect.right = rect.left + extent.Width();
	rect.bottom = rect.top + extent.Height();
	
	rect.right += 250;
	this->ResizeTo(rect.right, rect.bottom);
	
	BView* base = new BView(Bounds(), B_EMPTY_STRING, B_FOLLOW_NONE, B_WILL_DRAW);
	base->SetViewColor(230, 230, 230);
	outView->MoveBy(0, 0);
	base->AddChild(outView);
	
	BRect title_rect(0, 0, 234, 16);
	title_rect.OffsetTo(68, 8);
	BStringView* title = new BStringView(title_rect, "title", "Advisor's Report");
	base->AddChild(title);
	
	BRect message_rect(0, 0, 234, 50);
	message_rect.OffsetTo(68, 40);
	BTextView* message_label = new BTextView(message_rect, "message_label", message_rect, B_FOLLOW_NONE, B_WILL_DRAW);
	message_label->SetText(message);
	message_label->SetTextRect(message_label->Bounds());
	message_label->SetViewColor(230, 230, 230);
	message_label->MakeEditable(false);
	base->AddChild(message_label);
	
	BRect button_rect(0, 0, 64, 24);
	button_rect.OffsetTo(238, 102);
	BButton* close = new BButton(button_rect, "close", "OK", new BMessage(B_QUIT_REQUESTED));
	close->MakeDefault(true);
	base->AddChild(close);
	
	AddChild(base);
	}


bool HamAlert::QuitRequested ()
	{
	if (is_end)
		be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
	}
