//	XPMTranslator.cc
//	implements the constants and functions necessary for a Datatypes
//	addon.

#include "XPM.h"
#include "toXPM.h"
#include "fromXPM.h"
#include "Datatypes.h"
#include "DataHandler.h"

//	completely arbitrary of course
#define		XPM_TYPE_CODE		'XPM '

//	necessary
char handlerName[] = "XPMTranslator";
char handlerInfo[] = "XPMTranslator version 1.1, by E. Tomlinson";
int32 handlerVersion = 110;

//  optional.  Covers both read and write translation.
Format inputFormats[] =
{
	{
		XPM_TYPE_CODE,
		DATA_BITMAP,
		0.1,
		0.1,
		"image/x-xpixmap",
		"XPM image"
	},
	{
		DATA_BITMAP,
		DATA_BITMAP,
		0.1,
		0.1,
		"image/x-be-bitmap",
		"Be Bitmap Format"
	},
	NULL
};

Format outputFormats[] =
{
	{
		DATA_BITMAP,
		DATA_BITMAP,
		0.1,
		0.1,
		"image/x-be-bitmap",
		"Be Bitmap Format"
	},
	{
		XPM_TYPE_CODE,
		DATA_BITMAP,
		0.1,
		0.1,
		"image/x-xpixmap",
		"XPM image"
	},
	NULL
};

uint32 get_stream_type(BPositionIO &);

//	Identify()
//	check the identity of the input stream, and see if a match with the
//	output capabilities of the translator exists.  The legitimate possibilities
//	are:
//	input = DATA_BITMAP, output = XPM_TYPE_CODE or nothing -> output XPM data
//	input = XPM_TYPE_CODE, output = DATA_BITMAP or nothing -> output DATA_BITMAP

status_t Identify(BPositionIO &stream, \
	const Format *inFormat,	 \
	BMessage *ioExtension, \
	DATAInfo &info, \
	uint32 type)
{
	uint32 ourType;
	
	ourType = get_stream_type(stream);
	if (ourType == XPM_TYPE_CODE && (!type || type == DATA_BITMAP))
	{
		info.formatType = inputFormats[0].type;
		info.formatGroup = inputFormats[0].t_cls;
		info.formatQuality = inputFormats[0].quality;
		info.formatCapability = inputFormats[0].capability;
		strcpy(info.formatName,inputFormats[0].formatName);
		strcpy(info.MIMEName,inputFormats[0].MIME);
		return B_OK;
	}
	else if (ourType == DATA_BITMAP && (!type || type == XPM_TYPE_CODE))
	{
		info.formatType = inputFormats[1].type;
		info.formatGroup = inputFormats[1].t_cls;
		info.formatQuality = inputFormats[1].quality;
		info.formatCapability = inputFormats[1].capability;
		strcpy(info.formatName,inputFormats[1].formatName);
		strcpy(info.MIMEName,inputFormats[1].MIME);
		return B_OK;
	}
	else
		return DATA_NO_HANDLER;
}

//	Translate()
//	do the same identification job as above, and execute the translation
//	with either toXPM() or fromXPM(), as necessary.
status_t Translate(BPositionIO &input, \
	const DATAInfo &info, \
	BMessage *extension, \
	uint32 type, \
	BPositionIO &output)
{
	uint32 ourType;
	
	ourType = get_stream_type(input);
	if (ourType == XPM_TYPE_CODE && (!type || type == DATA_BITMAP))
		return fromXPM(input,output);
	else if (ourType == DATA_BITMAP && (!type || type == XPM_TYPE_CODE))
		return toXPM(input,output);
	else
		return DATA_NO_HANDLER;
}

//	get_stream_type()
//	accomplish the job of stream identification.  A DATA_BITMAP is
//	indicated by the first byte, which must equal the "magic" value of
//	'bits'.  An XPM file stream must begin with the XPM header, "/* XPM */".
//	Otherwise return zero, to indicate unknown type.
uint32 get_stream_type(BPositionIO &stream)
{
	status_t err;
	char buffer[16];
	uint32 bitsType = DATA_BITMAP;
	
	err = stream.Read(buffer,sizeof(buffer));
	if (err <= 0)
		return 0;
	stream.Seek(-err,SEEK_CUR);
	if (!strncmp(buffer,XPM_HEADER,strlen(XPM_HEADER)))
		return XPM_TYPE_CODE;
	else if (!memcmp(buffer,&bitsType,sizeof(bitsType)))
		return DATA_BITMAP;
	else
		return 0;
}
