//	ScanBitmap.cc
//
//	implements scan_bitmap(), which reads an DATA_BITMAP from a stream.
//	some attempt is made at covering all the possible bitmap color spaces, but only
//	B_RGBA32 has been tested at all, and that only on BeOS R3 Intel.  Endianness
//	issues will doubtless trip me up down the line.

#include "ScanBitmap.h"
#include "DataFormats.h"
#include <stdio.h>

//	scan_bitmap()
//	scans in a DATA_BITMAP from "stream", and fills out a bitmap_record
//	for use by other code.
status_t scan_bitmap(BPositionIO &stream, bitmap_record *br)
{
	status_t err;
	rgb_color *pixel;
	int i, j, k;
	uint16 word;
	int32 *pixint;
	uint8 *data, *addr, *t;
	const color_map *clut;
	DATABitmap bmap;
	rgb_color white = { 0xff, 0xff, 0xff, 0xff };
	rgb_color black = { 0x00, 0x00, 0x00, 0xff };

//	get the header first
	err = stream.Read(&bmap,sizeof(bmap));
	if (err <= 0)
		return B_ERROR;
	
//	confirm the "magic number"
	if (bmap.magic != DATA_BITMAP)
		return B_ERROR;
	
//	allocate and initialize the pixel data
	data = (uint8 *)calloc(bmap.dataSize,1);
	err = stream.Read(data,bmap.dataSize);
	if (err <= 0)
		return B_ERROR;
	br->width = 1+bmap.bounds.IntegerWidth();
	br->height = 1+bmap.bounds.IntegerHeight();
	br->pix = (rgb_color *)malloc(br->width*br->height*sizeof(rgb_color));
//	allocate the ctable, for the purpose of keeping track of all colors used in a particular
//	bitmap.  This could get nasty for 32-bit color bitmaps with thousands of distinct colors...
	br->ctable = new UTreeDictionary(sizeof(rgb_color));
	br->ncolors = 0;
	
	addr = data;
	pixel = br->pix;
	clut = system_colors();

	for (i = 0; i < br->height; i++)
	{
		t = addr;
		for (j = 0; j < br->width; j++)
		{
//	attempt to cover all possible formats.  Endianness resolutely ignored for the moment
//	until something breaks.
			switch (bmap.colors)
			{
				case B_RGB_32_BIT:
				case B_BIG_RGB_32_BIT:
					pixel->blue = *t++;
					pixel->green = *t++;
					pixel->red = *t++;
					pixel->alpha = *t++;	
					break;			
				case B_RGB_16_BIT:
				case B_BIG_RGB_16_BIT:
					word = *t;
					pixel->alpha = (word >> 15) << 7;
					pixel->red = (word >> 10) << 3;
					pixel->green = (word >> 5) << 3;
					pixel->blue = word << 3;
					t += 2;
					break;
				case B_COLOR_8_BIT:
					*pixel = clut->color_list[*t++];
					break;
				case B_GRAYSCALE_8_BIT:
					pixel->red = *t++;
					pixel->green = pixel->red;
					pixel->blue = pixel->red;
					pixel->alpha = 0xff;
					break;
				case B_MONOCHROME_1_BIT:
					k = i % 8;
					if (*t & (1 << (7-k)))
						*pixel = white;
					else
						*pixel = black;
					if (k == 7)
						t++;
					break;
				default:
					*pixel = black;
					break;
			}
			pixint = (int32 *)pixel;
			if (!br->ctable->Find(NULL,*pixint))
			{
				br->ncolors++;
				br->ctable->Insert(pixel,*pixint);
			}
			pixel++;
		}	
		addr += bmap.rowBytes;
	}
	
	free(data);
	return B_OK;
}
