//
//
//	Message list item
//
//								(C) Alain Gautherot 1999

#if !defined(_MESSAGE_LIST_ITEM_H_)
#define _MESSAGE_LIST_ITEM_H_

#include "HomerLibBuild.h"

#include <support/String.h>
#include <interface/ListItem.h>
#include <slist.h>


//---------------------------------------------------------
// Message list item
//---------------------------------------------------------
typedef enum
{
	HOMER_ERROR_MESSAGE,
	HOMER_WARNING_MESSAGE,
	HOMER_INFO_MESSAGE
} message_type;

class HOMER_LIB_SYMBOL	MessageListItem: public BListItem
{
public:
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		plain_item
	{
		char*			str;
		plain_item(char* s): str(s) {}
	} plain_item;
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		bold_item
	{
		char*			str;
		bold_item(char* s): str(s) {}
	} bold_item;
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		underlined_item
	{
		char*			str;
		underlined_item(char* s): str(s) {}
	} underlined_item;
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		italic_item
	{
		char*			str;
		italic_item(char* s): str(s) {}
	} italic_item;
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		space_item
	{
		float			value;
		space_item(float v): value(v) {}
	} space_item;
	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL		endl_item
	{} endl_item;

//protected:

	//---------------------------------------------------------
	typedef struct HOMER_LIB_SYMBOL message_item
	{
		bool					isString;
		union
		{
			struct space
			{
				float	value;
			} space;
			struct string_item
			{
				uint16			face;
				char*			value;
			} string;
		} data;
		message_item(char* s, uint16 f);
		message_item(float spc);
		~message_item();
		void					Draw(BFont* , BView* );
	} message_item;

	//---------------------------------------------------------
	typedef slist<message_item* > message_line;
	//---------------------------------------------------------
	typedef slist<message_line* > message_data;

	MessageListItem&	AddItem(message_item* );
	message_type		type;
	message_line*		currentLine;
	message_data*		lines;
	float				itemWidth;

public:
	MessageListItem(message_type );
	virtual ~MessageListItem();

	MessageListItem&	operator<<(MessageListItem& );
	MessageListItem&	operator<<(plain_item );
	MessageListItem&	operator<<(bold_item );
	MessageListItem&	operator<<(underlined_item );
	MessageListItem&	operator<<(italic_item );
	MessageListItem&	operator<<(endl_item );
	MessageListItem&	operator<<(space_item );

	bool				IsType(message_type ) const;

	virtual void		DrawItem(BView* , BRect , bool );
	virtual void		Update(BView* , const BFont* );
};


#endif /* _MESSAGE_LIST_ITEM_H_ */
