#!/bin/sh
#
# pnmindex - build a visual index of a bunch of anymaps
#
# Copyright (C) 1991 by Jef Poskanzer.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Translated into Bash by Chris Herborth (chrish@qnx.com).

size=100		# make the images about this big
across=6		# show this many images per row
colors=256		# quantize results to this many colors
back="-white"	# default background color

usage() {
	echo "usage: $(basename -- $0) [-size N] [-across N] [-colors N] [-black] pnmfile ..."
	exit 1
}

while true; do
	case "$1" in
		-s*)
			if [ "$2" = "" ]; then
				usage
			else
				size="$2"
				shift 2
			fi
			;;

		-a*)
			if [ "$2" = "" ]; then
				usage
			else
				across="$2"
				shift 2
			fi
			;;

		-c*)
			if [ "$2" = "" ]; then
				usage
			else
				colors="$2"
				shift 2
			fi
			;;

		-b*)
			back="-black"
			shift
			;;

		-w*)
			back="-white"
			shift
			;;

		-*)
			usage
			;;

		*)
			break
			;;
    esac
done

if [ $# = 0 ] ; then
	usage
fi

tmpfile=/tmp/pi.tmp.$$
rm -f $tmpfile
maxformat=PBM

rowfiles=""
imagefiles=""
row=1
col=1

trap "rm -f $rowfiles ; rm -f $imagefiles ; rm -f $tmpfile; exit 1" 1 2 15

ret() {
	local many=$1
	shift $many
	echo $1
}

for i in $@; do
	if [ ! -s $i ] ; then
		continue
	fi

	description=$(pnmfile $i)

	if [ $(ret 4 $description) -le $size ] && \
		[ $(ret 6 $description) -le $size ] ; then
		cat $i > $tmpfile
	else
		case $(ret 2 $description) in
			PBM)
				pnmscale -quiet -xysize $size $size $i | pgmtopbm > $tmpfile
				;;
				
			PGM)
				pnmscale -quiet -xysize $size $size $i > $tmpfile
				if [ "$maxformat" = "PBM" ] ; then
					maxformat=PGM
				fi
				;;
				
			*)
				pnmscale -quiet -xysize $size $size $i | ppmquant -quiet $colors > $tmpfile
				maxformat=PPM
				;;
		esac
	fi

    imagefile=/tmp/pi.${row}.${col}.$$
    rm -f $imagefile
    if [ "$back" = "-white" ]; then
		pbmtext "$i" | pnmcat $back -tb $tmpfile - > $imagefile
    else
		pbmtext "$i" | pnminvert | pnmcat $back -tb $tmpfile - > $imagefile
    fi
    rm -f $tmpfile
    imagefiles="$imagefiles $imagefile"

    if [ $col -ge $across ]; then
		rowfile=/tmp/pi.${row}.$$
		rm -f $rowfile
		if [ "$maxformat" != "PPM" ]; then
	    	pnmcat $back -lr -jbottom $imagefiles > $rowfile
		else
		    pnmcat $back -lr -jbottom $imagefiles | ppmquant -quiet $colors > $rowfile
		fi
		rm -f $imagefiles
		imagefiles=""
		rowfiles="$rowfiles $rowfile"
		col=1
		let row+=1
    else
		let col+=1
    fi
done

count() {
	echo $#
}

if [ $(count $imagefiles) -gt 0 ]; then
	rowfile=/tmp/pi.${row}.$$
    rm -f $rowfile
    if [ "$maxformat" != "PPM" ]; then
		pnmcat $back -lr -jbottom $imagefiles > $rowfile
    else
		pnmcat $back -lr -jbottom $imagefiles | ppmquant -quiet $colors > $rowfile
	fi
    rm -f $imagefiles
    rowfiles="$rowfiles $rowfile"
fi

if [ $(count $rowfiles) = 1 ]; then
	cat $rowfiles
else
	if [ "$maxformat" != "PPM" ]; then
		pnmcat $back -tb $rowfiles
    else
		pnmcat $back -tb $rowfiles | ppmquant -quiet $colors
    fi
fi
rm -f $rowfiles

exit 0
