// Threads.h

#ifndef THREADS_H
#define THREADS_H

// Thread
class Thread
{
public:
	Thread(thread_func func, char *name, int32 priority, void *data)
		{ id = spawn_thread(func, name, priority, data); go = true; };
	~Thread() { go = false; status_t exitval; WaitFor(&exitval); };
	status_t Resume() { return resume_thread(id); };
	status_t Suspend() { return suspend_thread(id); };
	status_t WaitFor(status_t *exit_value)
		{ return wait_for_thread(id, exit_value); };
//	void Exit(status_t ret_val) { exit_thread(ret_val); };
	status_t Kill() { return kill_thread(id); };
protected:
	bool		go;
private:
	thread_id	id;
};

// CycleThread
class CycleThread : public Thread
{
public:
	CycleThread(BWindowScreen *screen);
	bool	cycle_2nd_palette;
private:
	static int32 Cycling(CycleThread *me);
	BWindowScreen	*screen;
};

// DrawThread
class DrawThread : public Thread
{
public:
	DrawThread(BWindowScreen *screen, CycleThread *cycle_thread);
private:
	static int32 Drawing(DrawThread *me);
	BWindowScreen	*screen;
	CycleThread		*cycle_thread;
};


#endif	// THREADS_H

