// Threads.cpp

#include "Threads.h"
#include "BrainWash.h"
#include "Functions.h"

// the cycle thread

// constructor
CycleThread::CycleThread(BWindowScreen *cscreen)
			: Thread((thread_func)(CycleThread::Cycling), "cycle colors", B_LOW_PRIORITY, this)
{
	screen = cscreen;
	cycle_2nd_palette = false;
	Resume();
}



inline void CalcColor(rgb_color src, rgb_color dest, rgb_color &cur,
	int steps, int curstep)
{
	cur.red = ((dest.red - src.red) * curstep) / steps + src.red;
	cur.green = ((dest.green - src.green) * curstep) / steps
		+ src.green;
	cur.blue = ((dest.blue - src.blue) * curstep) / steps
		+ src.blue;
}

inline void CalcPalette(rgb_color *colors, rgb_color &col, int pos)
{
	rgb_color black = {0, 0, 0, 0};
	for (int i = 0; i < 64; i++)
		CalcColor(black, col, colors[i + pos], 63, i);
}

static void NewDest(rgb_color &src, rgb_color &dest, int &steps)
{
	const int minval = 382;
	src = dest;
	dest.red = rand() % 256;
	int left = (minval - 255) - dest.red;
	if (left < 0)
		left = 0;
	dest.green = (rand() % (256 - left)) + left;
	left = minval - dest.red - dest.green;
	if (left < 0)
		left = 0;
	dest.blue = (rand() % (256 - left)) + left;
	steps = max(abs(dest.red - src.red), abs(dest.green - src.green));
	steps = max(steps, abs(dest.blue - src.blue));
}


// the cycle function
int32 CycleThread::Cycling(CycleThread *me)
{
	// set palette
	rgb_color *colors = new rgb_color[256];
	rgb_color *colors2 = new rgb_color[128];
	int i;
	int offset = 0;
	rgb_color src1, dest1 = {0, 0, 0, 0}, cur1;
	rgb_color src2, dest2 = {0, 0, 0, 0}, cur2;
	int steps1 = 0, curstep1 = 0;
	int steps2 = 0, curstep2 = 0;
	colors[128] = dest2;	// initialize the background color with black

	// color cycling
	while (me->go)
	{
		if (offset % 16 == 0)
		{
			// palette 1
			while (curstep1 == steps1)
			{
				NewDest(src1, dest1, steps1);
				curstep1 = 0;
			}

			CalcColor(src1, dest1, cur1, steps1, curstep1);
			CalcPalette(colors2, cur1, 0);
			curstep1++;

			// palette 2
			while (curstep2 == steps2)
			{
				NewDest(src2, dest2, steps2);
				curstep2 = 0;
			}
			CalcColor(src2, dest2, cur2, steps2, curstep2);
			CalcPalette(colors2, cur2, 64);
			curstep2++;
		}

		int i;
		for (i = 0; i < 64; i++)
			colors[(offset + 127 - i) % 128]
				= colors[(offset + i) % 128] = colors2[i];

		if (me->cycle_2nd_palette)
		{
			for (i = 0; i < 64; i++)
				colors[((offset + 127 - i) % 128) + 128]
					= colors[((offset + i) % 128) + 128] = colors2[i + 64];
		}

		me->screen->SetColorList(colors);
		offset = (offset + 1) % 128;
		snooze((11 - settings->cycle_speed) * 500);
	}
	delete colors2;
	delete colors;
	return B_OK;
}


// the drawing thread

// constructor
DrawThread::DrawThread(BWindowScreen *cscreen, CycleThread *ccycle_thread)
			: Thread((thread_func)Drawing, "cycle colors", B_LOW_PRIORITY, this)
{
	screen = cscreen;
	cycle_thread = ccycle_thread;
	Resume();
}

// the drawing function
int32 DrawThread::Drawing(DrawThread *me)
{
	int i;
	graphics_card_info *cardinfo = me->screen->CardInfo();
	char *fb = (char *)cardinfo->frame_buffer;
//	int w = cardinfo->width, h = cardinfo->height;
	int wi = 640, hi = 480;
	float w = wi, h = hi;
	srand(real_time_clock());

	// clear screen
	ClearScreen(fb, wi, hi, 128);

	// draw
	Function *func[2];
	func[0] = new Function(&me->go, fb, w, h, 0);
	func[1] = new Function(&me->go, fb, w, h, 128);
	int curfunc = 0;
	bool notified = false;	// tell the cycle thread to use the 2nd palette

	while (me->go)
	{
		float x0 = float(rand()) / RAND_MAX * (w / 2 - 1) + w / 4;
		float y0 = float(rand()) / RAND_MAX * (h / 2 - 1) + h / 4;
		func[curfunc]->Init();
		func[curfunc]->Draw(x0, y0);
		for (int i = 0; i < 100 * settings->drawing_gap && me->go; i++)
			snooze(10000);
		curfunc = 1 - curfunc;
		if (!notified)
		{
			notified = true;
			me->cycle_thread->cycle_2nd_palette = true;
		}
	}
	delete func[0];
	delete func[1];
	return 0;
}

