// ScreenSaver.cpp

#include "ScreenSaver.h"
#include "Threads.h"

// SaverScreen

// constructor
ScreenSaver::ScreenSaver(uint32 space, status_t *error)
{
	cycle_thread = 0;
	draw_thread = 0;
	screen = new BWindowScreen("saver screen", space, error);
	if (*error != B_OK)
	{
		screen->PostMessage(B_QUIT_REQUESTED, screen);
		screen = NULL;
	}
	else
	{
		screen->Show();
		cycle_thread = new CycleThread(screen);
		draw_thread = new DrawThread(screen, cycle_thread);
	}
}

// destructor
ScreenSaver::~ScreenSaver()
{
	if (draw_thread)
		delete draw_thread;
	if (cycle_thread)
		delete cycle_thread;
	if (screen)
		screen->PostMessage(B_QUIT_REQUESTED, screen);
}

