// Functions.h

#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#define min(a, b)	((a) < (b)) ? (a) : (b)
#define max(a, b)	((a) > (b)) ? (a) : (b)


// the precalc function types - used in Function::Init()
enum
{
	FUNC1			= 0,
	LENS1			= 1,
	TWIST			= 2,
	PRE_FUNC_COUNT
};

// the postcalc function types - used in Function::Init()
enum
{
	SPIRAL			= 0,
	SNAIL			= 1,
	CIRCLE			= 2,
	GRID			= 3,
	WAVES			= 4,
	FIELD			= 5,
	HOLE			= 6,
	POST_FUNC_COUNT
};

// the kinds of spirals
enum
{
	SPIRAL_COS		= 0,
	SPIRAL2_COS		= 1,
	SPIRAL_LIN		= 2,
	SPIRAL2_LIN		= 3,
	WHEEL_COS		= 4,
	WHEEL_LIN		= 5,
	SPIRAL_COUNT
};

// the kinds of circles
enum
{
	CIRCLE_COS		= 0,
	CIRCLE_LIN		= 1,
	CIRCLE_COUNT
};



// get the maximal distance
inline float GetMaxR(float w, float h, float x0, float y0)
{
	float maxx = max(x0, w - x0);
	float maxy = max(y0, h - y0);
	return sqrt(maxx * maxx + maxy * maxy);
}



// the precalculation class
class PreCalc
{
public:
	virtual void Calculate(float x, float y, float *xx, float *yy) = 0;
};

// Func1
class Func1 : public PreCalc
{
public:
	Func1(float cw, float ch) { w = cw; h = ch; };
	virtual void Calculate(float x, float y, float *xx, float *yy);
private:
	float	w;
	float	h;
};

// Lens1
class Lens1 : public PreCalc
{
public:
	Lens1(float cx0, float cy0, float cw, float ch, float cloc, float cinf)
		{ x0 = cx0; y0 = cy0; w = cw; h = ch; loc = cloc; inf = cinf;
	  maxr = GetMaxR(w, h, x0, y0); };
	virtual void Calculate(float x, float y, float *xx, float *yy);
private:
	float	x0;
	float	y0;
	float	w;
	float	h;
	float	loc;
	float	inf;
	float	maxr;
};

// Twist
class Twist : public PreCalc
{
public:
	Twist(float cx0, float cy0, float crad, float cfak)
		{ x0 = cx0; y0 = cy0; rad = crad; fak = cfak; };
	virtual void Calculate(float x, float y, float *xx, float *yy);
private:
	float	x0;
	float	y0;
	float	rad;
	float	fak;
};





// the postcalculation class
class PostCalc
{
public:
	virtual float Calculate(float x, float y) = 0;
};

// SpiralCos
class SpiralCos : public PostCalc
{
public:
	SpiralCos(float cw, float ch, float cx0, float cy0,
		float ctentacles = 2) : PostCalc()
			{ w = cw; h = ch; x0 = cx0; y0 = cy0; tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	w;
	float	h;
	float	x0;
	float	y0;
	float	tentacles;	// an integral number
};

// SpiralCos2
class SpiralCos2 : public PostCalc
{
public:
	SpiralCos2(float cw, float ch, float cx0, float cy0, float crad,
		float ctentacles = 2) : PostCalc()
			{ w = cw; h = ch; x0 = cx0; y0 = cy0; rad = crad;
				tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	w;
	float	h;
	float	x0;
	float	y0;
	float	tentacles;	// an integral number
	float	rad;
};

// SpiralLin
class SpiralLin : public PostCalc
{
public:
	SpiralLin(float cw, float ch, float cx0, float cy0,
		float ctentacles = 2) : PostCalc()
			{ w = cw; h = ch; x0 = cx0; y0 = cy0; tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	w;
	float	h;
	float	x0;
	float	y0;
	float	tentacles;	// an integral number
};

// SpiralLin2
class SpiralLin2 : public PostCalc
{
public:
	SpiralLin2(float cw, float ch, float cx0, float cy0, float crad,
		float ctentacles = 2) : PostCalc()
			{ w = cw; h = ch; x0 = cx0; y0 = cy0; rad = crad;
				tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	w;
	float	h;
	float	x0;
	float	y0;
	float	tentacles;	// an integral number
	float	rad;
};

// Snail
class Snail : public PostCalc
{
public:
	Snail(float cw, float ch, float cx0, float cy0, float cfak) : PostCalc()
			{ w = cw; h = ch; x0 = cx0; y0 = cy0; fak = cfak; };
	virtual float Calculate(float x, float y);
private:
	float	w;
	float	h;
	float	x0;
	float	y0;
	float	fak;
};

// Grid
class Grid : public PostCalc
{
public:
	Grid(float cx0, float cy0, float chor, float cver,
		float cweight = 1) : PostCalc()
		{ x0 = cx0; y0 = cy0; hor = chor; ver = cver; weight = cweight; };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	hor;
	float	ver;
	float	weight;
};

// Field
class Field : public PostCalc
{
public:
	Field(float cx0, float cy0, float cw, float ch, float chor,
		float cver, float cweight = 1) : PostCalc()
		{ x0 = cx0; y0 = cy0; w = cw; h = ch; hor = chor; ver = cver;
			weight = cweight; };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	w;
	float	h;
	float	hor;
	float	ver;
	float	weight;
};

// Waves
class Waves : public PostCalc
{
public:
	Waves (float cx0, float cy0, float cw, float ch, float chor,
		float cver) : PostCalc()
		{ x0 = cx0; y0 = cy0; w = cw, h = ch; hor = chor; ver = cver; };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	w;
	float	h;
	float	hor;
	float	ver;
};

// CircleCos
class CircleCos : public PostCalc
{
public:
	CircleCos(float cx0, float cy0, float cw, float ch,
		float cstretch = 1) : PostCalc()
		{ x0 = cx0; y0 = cy0; stretch = cstretch;
			maxr = GetMaxR(cw, ch, x0, y0); };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	maxr;
	float	stretch;
};

// WheelCos
class WheelCos : public PostCalc
{
public:
	WheelCos(float cx0, float cy0, float ctentacles = 1)
		: PostCalc() { x0 = cx0; y0 = cy0; tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	tentacles;
};

// WheelLin
class WheelLin : public PostCalc
{
public:
	WheelLin(float cx0, float cy0, float ctentacles = 1)
		: PostCalc() { x0 = cx0; y0 = cy0; tentacles = ctentacles; };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	tentacles;
};

// CircleLin
class CircleLin : public PostCalc
{
public:
	CircleLin(float cx0, float cy0, float cw, float ch,
		float cstretch = 1) : PostCalc()
		{ x0 = cx0; y0 = cy0; stretch = cstretch;
			maxr = GetMaxR(cw, ch, x0, y0); };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	maxr;
	float	stretch;
};

// Hole
class Hole : public PostCalc
{
public:
	Hole(float cx0, float cy0, float cw, float ch,
		float cstretch, float cdir) : PostCalc()
		{ x0 = cx0; y0 = cy0; stretch = cstretch; dir = cdir;
			maxr = GetMaxR(cw, ch, x0, y0); };
	virtual float Calculate(float x, float y);
private:
	float	x0;
	float	y0;
	float	maxr;
	float	stretch;
	float	dir;
};


// Function
class Function
{
public:
	Function(bool *go, char *fb, float w, float h, int cstartcol = 0);
	~Function();

	void DrawPixel(float x, float y, int wi);
	void Draw(float x0, float y0);
	void Init();

private:
	bool	*go;
	char	*fb;
	float	w;
	float	h;
	int		startcol;
	BList	*prelist;
	BList	*postlist;
};



#endif	// FUNCTIONS_H

