// Functions.cpp

#include "BrainWash.h"
#include "Functions.h"

const float pi = 3.14159265;
const float pi2 = pi * 2;


// precalculation

// Func1
void Func1::Calculate(float x, float y, float *xx, float *yy)
{
	*xx = (1 - cos(x / w * pi)) / 2 * w;
	*yy = (1 - cos(y / h * pi)) / 2 * h;
}

// Lens1
void Lens1::Calculate(float x, float y, float *xx, float *yy)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = pow(cos(dist / (maxr + 0.01) * pi / 2), loc) * inf;
	*xx = x + (x0 - x) * r;
	*yy = y + (y0 - y) * r;
}

// Twist
void Twist::Calculate(float x, float y, float *xx, float *yy)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;

//	r += sqrt(rad / (rad + dist)) * pi2;
	r += sqrt(dist / (1120)) * pi2;

	*xx = x0 + cos(r) * dist;
	*yy = y0 + sin(r) * dist;
}




// postcalculation

// SpiralCos
float SpiralCos::Calculate(float x, float y)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;
	r = (r + sqrt(dist / (w + h)) * 3) / pi2 * tentacles;
	r -= floor(r);
	float m = (cos(r * pi2) + 1) * 0.4999;
	return ((r < 0.5) ? -m : m);
}

// SpiralCos2
float SpiralCos2::Calculate(float x, float y)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;
	r = (r + sqrt(rad / (rad + dist)) * 3) / pi2 * tentacles;
	r -= floor(r);
	float m = (cos(r * pi2) + 1) * 0.4999;
	return ((r < 0.5) ? -m : m);
}

// SpiralLin
float SpiralLin::Calculate(float x, float y)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;
	r = (r + sqrt(dist / (w + h)) * 3) / pi2 * tentacles;
	return (r - floor(r) - 0.5) * 1.999;
}

// SpiralLin2
float SpiralLin2::Calculate(float x, float y)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;
	r = (r + sqrt(rad / (rad + dist)) * 3) / pi2 * tentacles;
	return (r - floor(r) - 0.5) * 1.999;
}

// Snail
float Snail::Calculate(float x, float y)
{
	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / (dist * 1.000001));
	if (x - x0 < 0)
		r = pi - r;
	r = (r + sqrt(dist / (w + h)) * 100 * fak) / pi2;
	return (r - floor(r) - 0.5) * 1.999;
}

// Grid
float Grid::Calculate(float x, float y)
{
	float xx = (x - x0) / hor;
	float yy = (y - y0) / ver;
	xx -= floor(xx);
	yy -= floor(yy);
	if (xx > 0.5)
		xx = 1 - xx;
	if (yy > 0.5)
		yy = 1 - yy;
	xx = sin(pi2 * xx);
	yy = sin(pi2 * yy);
	return (1 - xx * yy) * weight;
}

// Field
float Field::Calculate(float x, float y)
{
	return (cos(x * hor / w * pi) + cos(y * ver / h * pi) + 2) / 4 * weight;
}

// Waves
float Waves::Calculate(float x, float y)
{
	float z = ((x - x0) * hor + (y - y0) * ver) / (w + h);
//	return (z - floor(z) - 0.5) * 1.999;
	return (z - 0.5) * 1.999;
}

// CircleCos
float CircleCos::Calculate(float x, float y)
{
	float r = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y))
		/ (maxr + 0.1) * stretch;
	r -= floor(r);
	float m = (cos(r * pi2) + 1) * 0.4999;
	return ((r < 0.5) ? -m : m);
}

// WheelCos
float WheelCos::Calculate(float x, float y)
{
	float rad = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / rad);
	if (x - x0 < 0)
		r = pi - r;
	r = r / pi2 * tentacles;
	r -= floor(r);
	float m = (cos(r * pi2) + 1) * 0.4999;
	return ((r < 0.5) ? -m : m);
}

// WheelLin
float WheelLin::Calculate(float x, float y)
{
	float rad = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = asin((y0 - y) / rad);
	if (x - x0 < 0)
		r = pi - r;
	r = r / pi2 * tentacles;
	return 1 - 2 * (r - floor(r));
}

// CircleLin
float CircleLin::Calculate(float x, float y)
{
	float r = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y))
		/ (maxr + 0.1) * stretch;
	return (r - floor(r) - 0.5) * 1.999;
}

// Hole
float Hole::Calculate(float x, float y)
{
//	float dist = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y));
	float r = sqrt((x0 - x) * (x0 - x) + (y0 - y) * (y0 - y))
		/ (maxr + 0.1) * stretch;
	r = dir * (0.1 / (r + 0.1));
	return (r - floor(r) - 0.5) * 1.999;
}



// Function

// constructor
Function::Function(bool *cgo, char *cfb, float cw, float ch,
	int cstartcol)
{
	go = cgo;
	fb = cfb;
	w = cw;
	h = ch;
	startcol = cstartcol;
	prelist = new BList(10);
	postlist = new BList(10);
}

// destructor
Function::~Function()
{
	// empty and delete prelist
	while (PreCalc *item = (PreCalc *)prelist->ItemAt(0))
	{
		prelist->RemoveItem((long)0);
		delete item;
	}
	delete prelist;
	// empty and delete postlist
	while (PostCalc *item = (PostCalc *)postlist->ItemAt(0))
	{
		postlist->RemoveItem((long)0);
		delete item;
	}
	delete postlist;
}

// create calculation objects randomly
void Function::Init()
{
	// empty prelist
	while (PreCalc *item = (PreCalc *)prelist->ItemAt(0))
	{
		prelist->RemoveItem((long)0);
		delete item;
	}
	// empty postlist
	while (PostCalc *item = (PostCalc *)postlist->ItemAt(0))
	{
		postlist->RemoveItem((long)0);
		delete item;
	}



/*
//	float fak = rand() % 6; fak = (fak >= 3) ? fak - 6 : fak;
	float fak = 1;
	float x0 = float(rand()) / RAND_MAX * (w - 1);
	float y0 = float(rand()) / RAND_MAX * (h - 1);
	float stretch = -(float(rand()) / RAND_MAX * 4.5 + 0.5);
	postlist->AddItem(
		new CircleLin(fak, x0, y0, w, h, stretch));


//	float fak = rand() % 3 + 1;
	float fak = 1;
	float x0 = float(rand()) / RAND_MAX * (w - 1);
	float y0 = float(rand()) / RAND_MAX * (h - 1);
	float tentacles = (rand() % 9 + 2);
	postlist->AddItem(
		new SpiralCos(fak, w, h, x0, y0, tentacles));


	float x0 = float(rand()) / RAND_MAX * (w - 1);
	float y0 = float(rand()) / RAND_MAX * (h - 1);
	float tentacles = rand() % 12 + 3;
	postlist->AddItem(new WheelLin(x0, y0, tentacles));


	float x0 = float(rand()) / RAND_MAX * (w - 1);
	float y0 = float(rand()) / RAND_MAX * (h - 1);
	float tentacles
		= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
	float rad = float(rand()) / RAND_MAX * 9 + 1;
	postlist->AddItem(
		new SpiralLin2(w, h, x0, y0, rad, tentacles));


	{
		float x0 = float(rand()) / RAND_MAX * (w - 1);
		float y0 = float(rand()) / RAND_MAX * (h - 1);
		float rad = float(rand()) / RAND_MAX * 9 + 1;
		float fak = ((rand() % 2) * 2 - 1)
			* (float(rand()) / RAND_MAX * 1.9 + 0.1);
		prelist->AddItem(
			new Twist(x0, y0, rad, fak));
	}

	{
		float x0 = float(rand()) / RAND_MAX * (w - 1);
		float y0 = float(rand()) / RAND_MAX * (h - 1);
		float hor = float(rand()) / RAND_MAX * 385 + 15;
		float ver = float(rand()) / RAND_MAX * 385 + 15;
		float weight = float(rand()) / RAND_MAX * 0.5 + 0.05;
		postlist->AddItem(
			new Grid(x0, y0, hor, ver, weight));
	}

	{
		float x0 = float(rand()) / RAND_MAX * (w - 1);
		float y0 = float(rand()) / RAND_MAX * (h - 1);
		float fak = 0.1;
		postlist->AddItem(
			new Snail(w, h, x0, y0, fak));
	}


	{
		float x0 = float(rand()) / RAND_MAX * (w - 1);
		float y0 = float(rand()) / RAND_MAX * (h - 1);
//		float stretch = rand() % 199 + 1;
		int stretch = rand() % 5 + 1; stretch *=stretch;
		float dir = (rand() % 2) * 2 - 1;
		postlist->AddItem(
			new Hole(x0, y0, w, h, stretch = 1, dir));
	}

	return;
*/





	// precalc functions
	int num = rand() % 2 + 1;				// 1...2 functions
	for (int i = 0, numf1 = 1, numle1 = 1, numtw = 1; i < num; i++)
	{
		int choice = rand() + 1;
		while (choice >= 0)
		{
			choice %= PRE_FUNC_COUNT;
			switch (choice)
			{
				case FUNC1:
					if (numf1)
					{
						prelist->AddItem(new Func1(w, h));
						numf1--;
						choice = -1;
					}
					else
						choice++;
					break;
				case LENS1:
					if (numle1)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float loc = float(rand()) / RAND_MAX * (2.7) + 0.3;
						float inf = float(rand()) / RAND_MAX * 3 - 1.5;
						prelist->AddItem(
							new Lens1(x0, y0, w, h, loc, inf));
						numle1--;
						choice = -1;
					}
					else
						choice++;
					break;
				case TWIST:
					if (numtw)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float rad = float(rand()) / RAND_MAX * 9 + 1;
						float fak = ((rand() % 2) * 2 - 1)
							* (float(rand()) / RAND_MAX * 1.9 + 0.1);
						prelist->AddItem(
							new Twist(x0, y0, rad, fak));
						numtw--;
						choice = -1;
					}
					else
						choice++;
					break;
				default:
					return;
			}
		}
	}
	// postcalc functions
	num = rand() % 4 + 2;					// 2...5 functions
	for (int i = 0, numsp = 2, numgr = 1, numfi = 1, numwa = 1,
		numci = 2, numsn = 1, numho = 1; i < num; i++)
	{
		int choice = rand() + 1;
		while (choice >= 0)
		{
			choice %= POST_FUNC_COUNT;
			switch (choice)
			{
				// SPIRAL
				case SPIRAL:
					if (numsp)
					{
						switch (choice = rand() % SPIRAL_COUNT)
						{
							// SpiralCos
							case SPIRAL_COS:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								postlist->AddItem(
									new SpiralCos(w, h, x0, y0, tentacles));
								break;
							}
							// SpiralLin
							case SPIRAL_LIN:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								postlist->AddItem(
									new SpiralLin(w, h, x0, y0, tentacles));
								break;
							}
							// SpiralCos2
							case SPIRAL2_COS:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								float rad = float(rand()) / RAND_MAX * 9 + 1;
								postlist->AddItem(
									new SpiralCos2(w, h, x0, y0, rad, tentacles));
								break;
							}
							// SpiralLin2
							case SPIRAL2_LIN:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								float rad = float(rand()) / RAND_MAX * 9 + 1;
								postlist->AddItem(
									new SpiralLin2(w, h, x0, y0, rad, tentacles));
								break;
							}
							// WheelCos
							case WHEEL_COS:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								postlist->AddItem(new WheelCos(x0, y0, tentacles));
								break;
							}
							// WheelLin
							case WHEEL_LIN:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float tentacles
									= ((rand() % 2) * 2 - 1) * (rand() % 19 + 4);
								postlist->AddItem(new WheelLin(x0, y0, tentacles));
								break;
							}
						}
						numsp--;
						choice = -1;
					}
					else
						choice++;
					break;	// SPIRAL
				// CIRCLE
				case CIRCLE:
					if (numci)
					{
						switch (choice = rand() % CIRCLE_COUNT)
						{
							// CircleCos
							case CIRCLE_COS:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float stretch = ((rand() % 2) * 2 - 1)
									* (float(rand()) / RAND_MAX * 14.5 + 0.5);
								postlist->AddItem(
									new CircleCos(x0, y0, w, h, stretch));
								break;
							}
							// CircleLin
							case CIRCLE_LIN:
							{
								float x0 = float(rand()) / RAND_MAX * (w - 1);
								float y0 = float(rand()) / RAND_MAX * (h - 1);
								float stretch = ((rand() % 2) * 2 - 1)
									* (float(rand()) / RAND_MAX * 14.5 + 0.5);
								postlist->AddItem(
									new CircleLin(x0, y0, w, h, stretch));
								break;
							}
						}
						numci--;
						choice = -1;
					}
					else
						choice++;
					break;	// CIRCLE
				// Hole
				case HOLE:
					if (numho)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						int stretch = rand() % 5 + 1; //stretch *=stretch;
						float dir = (rand() % 2) * 2 - 1;
						postlist->AddItem(
							new Hole(x0, y0, w, h, stretch, dir));
						numho--;
						choice = -1;
					}
					else
						choice++;
					break;
				// Snail
				case SNAIL:
					if (numsn)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float fak = ((rand() % 2) * 2 - 1)
							* (float(rand()) / RAND_MAX * 1.9 + 0.1);
						postlist->AddItem(
							new Snail(w, h, x0, y0, fak));
						numsn--;
						choice = -1;
					}
					else
						choice++;
					break;
				// Grid
				case GRID:
					if (numgr)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float hor = float(rand()) / RAND_MAX * 385 + 15;
						float ver = float(rand()) / RAND_MAX * 385 + 15;
						float weight = float(rand()) / RAND_MAX * 0.5 + 0.05;
						postlist->AddItem(
							new Grid(x0, y0, hor, ver, weight));
						numgr--;
						choice = -1;
					}
					else
						choice++;
					break;
				// Waves
				case WAVES:
					if (numwa)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float hor = ((rand() % 2) * 2 - 1)
							* (float(rand()) / RAND_MAX * 19 + 1);
						float ver = ((rand() % 2) * 2 - 1)
							* (float(rand()) / RAND_MAX * 19 + 1);
						postlist->AddItem(
							new Waves(x0, y0, w, h, hor, ver));
						numwa--;
						choice = -1;
					}
					else
						choice++;
					break;
				// Field
				case FIELD:
					if (numgr)
					{
						float x0 = float(rand()) / RAND_MAX * (w - 1);
						float y0 = float(rand()) / RAND_MAX * (h - 1);
						float hor = float(rand()) / RAND_MAX * 29 + 1;
						float ver = float(rand()) / RAND_MAX * 29 + 1;
						float weight = float(rand()) / RAND_MAX * 0.5 + 0.05;
						postlist->AddItem(
							new Field(x0, y0, w, h, hor, ver, weight));
						numgr--;
						choice = -1;
					}
					else
						choice++;
					break;
				default:
					return;
			}
		}
	}
}

// draw pixel at (x, y)
void Function::DrawPixel(float x, float y, int wi)
{
	// precalc
	float xx = x, yy = y;
	for (int i = 0; PreCalc *item = (PreCalc *)prelist->ItemAt(i); i++)
		item->Calculate(x, y, &xx, &yy);
	// postcalc
	float col2 = 0;
	for (int i = 0; PostCalc *item = (PostCalc *)postlist->ItemAt(i); i++)
		col2 += item->Calculate(xx, yy);
	// calculate color and write pixel
	col2 = floor(col2 * 64 + 0.5);
	int col = col2;
	col %= 128;
	if (col < 0)
		col += 128;
	WritePixel(fb, x, y, col + startcol, wi);
}

// draw function starting with (x0, y0)
void Function::Draw(float x0, float y0)
{
	int wi = w;
	float x, y;
	float l = x0 - 1, r = x0, t = y0 - 1, b = y0;

	while ((t >= 0 || r < w || b < h || l >= 0) && *go)
	{
		// top
		if (t >= 0)
		{
			for (x = l + 1; x < r; x++)
				DrawPixel(x, t, wi);
			t--;
		}
		// right
		if (r < w)
		{
			for (y = t + 1; y < b; y++)
				DrawPixel(r, y, wi);
			r++;
		}
		// bottom
		if (b < h)
		{
			for (x = r - 1; x > l; x--)
				DrawPixel(x, b, wi);
			b++;
		}
		// left
		if (l >= 0)
		{
			for (y = b - 1; y > t; y--)
				DrawPixel(l, y, wi);
			l--;
		}
		if (11 - settings->drawing_speed)
			snooze(2000 * (10 - settings->drawing_speed));
	}
}

