// a Blanket module by Stephan Assmus, Ingo Weinhold

#include <Window.h>
#include <View.h>
#include <TextView.h>
#include <StringView.h>
#include <WindowScreen.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include "BrainWash.h"
#include "ScreenSaver.h"
#include "Functions.h"

// saver object
ScreenSaver *saver = 0;
BSlider *sl_cycle_speed = 0, *sl_drawing_gap = 0, *sl_drawing_speed = 0;

const char SETTINGS_FILE_NAME[] = "/boot/home/config/settings/brainwash_settings";

Settings defaults = {5, 5, 5};
Settings *settings;

// create a simple slider
inline BSlider *CreateSlider(BRect frame,const char *label, int min,
	int max, int def, const char *limlabl, const char *limlabr)
{
	BSlider *sl = new BSlider(frame, 0, label, 0,
		min, max, B_BLOCK_THUMB, B_FOLLOW_LEFT | B_FOLLOW_TOP,
		B_FRAME_EVENTS | B_WILL_DRAW | B_NAVIGABLE);
	sl->ResizeToPreferred();
	sl->SetLimitLabels(limlabl, limlabr);
	sl->SetHashMarkCount(max - min + 1);
	sl->SetHashMarks(B_HASH_MARKS_BOTTOM);
	sl->SetValue(def);
	return sl;
}

// I N I T I A L I Z E
void module_initialize(void *fsettings, long settings_size)
{
	if (fsettings && settings_size == sizeof(Settings))
		settings = (Settings *)fsettings;
	else
	{
		settings = new Settings;
		*settings = defaults;
	}
}

// C L E A N U P
void module_cleanup(void **fsettings, long *settings_size)
{
	*fsettings = settings;
	*settings_size = sizeof(Settings);
}

// S T A R T   S A V I N G
void module_start_saving(BView *v)
{
	if (!saver)
	{
		status_t error;
		saver = new ScreenSaver(B_8_BIT_640x480, &error);
		if (error != B_OK)
		{
			delete saver;
			saver = 0;
		}
	}
}

// S T O P   S A V I N G
void module_stop_saving()
{
	if (saver)
	{
		delete saver;
		saver = 0;
	}
}

// S T A R T   C O N F I G
void module_start_config(BView *inView)
{
	if (!inView->Window()->Lock())
		return;
	BRect frame;
	// title
	frame = inView->Bounds();
	frame.left += 7.0;
	frame.bottom = frame.top + 14.0;
	BStringView *view = 
		new BStringView(frame, B_EMPTY_STRING, "BrainWash");
	inView->AddChild(view);
	view->SetViewColor(inView->ViewColor());
	view->SetFont(be_bold_font);
	// info text
	frame.top = frame.bottom + 7.0;
	frame.bottom = frame.top + 40.0;
	BRect textArea = frame;
	textArea.OffsetTo(B_ORIGIN);
	BTextView *caption = new BTextView(frame, B_EMPTY_STRING, textArea,
						   			   B_FOLLOW_ALL, B_WILL_DRAW);
	caption->SetText("© 1998 Stephan Aßmus, Ingo Weinhold\n"
					 "<gottgeac@linux.zrz.tu-berlin.de>\n"
					 "<bonefish@cs.tu-berlin.de>\n");
	inView->AddChild(caption);
	caption->SetViewColor(inView->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);
	caption->MakeEditable(FALSE);
	caption->MakeSelectable(TRUE);
	caption->SetWordWrap(TRUE);	
	inView->Window()->UpdateIfNeeded();
	// the cycle_speed slider
	frame.top = frame.bottom + 10;
	frame.bottom = frame.top + 40.0;
	sl_cycle_speed = CreateSlider(frame, "cycle speed: ", 0, 10,
		settings->cycle_speed, "slow", "fast");
	inView->AddChild(sl_cycle_speed);
	// the drawing_gap slider
	frame = sl_cycle_speed->Frame();
	frame.top = frame.bottom + 10;
	frame.bottom = frame.top + 40.0;
	sl_drawing_gap = CreateSlider(frame, "drawing gap (secs): ", 0, 10,
		settings->drawing_gap, "0", "10");
	inView->AddChild(sl_drawing_gap);
	// the drawing_speed slider
	frame = sl_drawing_gap->Frame();
	frame.top = frame.bottom + 10;
	frame.bottom = frame.top + 40.0;
	sl_drawing_speed = CreateSlider(frame, "drawing speed: ", 1, 9,
		settings->drawing_speed, "slow", "fast");
	inView->AddChild(sl_drawing_speed);
	inView->Window()->Unlock();
}


// S T O P   C O N F I G
void module_stop_config()
{
	// set user modified values
	if (sl_cycle_speed)
	{
		settings->cycle_speed = sl_cycle_speed->Value();
		sl_cycle_speed = 0;
	}
	if (sl_drawing_gap)
	{
		settings->drawing_gap = sl_drawing_gap->Value();
		sl_drawing_gap = 0;
	}
	if (sl_drawing_speed)
	{
		settings->drawing_speed = sl_drawing_speed->Value();
		sl_drawing_speed = 0;
	}
}

const char alert_text1[] =
"BrainWash V1.0 by Stephan Aßmus & Ingo Weinhold";

const char alert_text2[] =
"Hi! I'm a Blanket screen saver module and usually live in\n\
'/boot/home/config/add-ons/Screen Savers'.";

const char *right_path = "/boot/home/config/add-ons/Screen Savers/BrainWash";

int main (int argc, char *argv[])
{
	BApplication app("application/x-vnd.Be-peexecutable");
	char buf[1024];
	sprintf(buf,"mv \"%s\" \"/boot/home/config/add-ons/Screen Savers\"", argv[0]);
	if (strcmp(argv[0], right_path) == 0)
	{
		BAlert *al = new BAlert("BrainWash", alert_text1, "Oh");
		al->Go();
	}
	else
	{
		BAlert *al = new BAlert("BrainWash", alert_text2, "Oh", "Go there");
		switch (al->Go())
		{
			case 0:
				break;
			case 1:
				system(buf);
				break;
		}
	}
	return 0;
}


