.\" $Id: trn.1,v 3.0 1992/12/14 00:14:10 davison Trn $
.\"
.\" This software is Copyright 1991 by Stan Barber. 
.\"
.\" Permission is hereby granted to copy, reproduce, redistribute or otherwise
.\" use this software as long as: there is no monetary profit gained
.\" specifically from the use or reproduction of this software, it is not
.\" sold, rented, traded or otherwise marketed, and this copyright notice is
.\" included prominently in any copy made. 
.\"
.\" The authors make no claims as to the fitness or correctness of this software
.\" for any use whatsoever, and it is provided as is. Any use of this software
.\" is at the user's own risk. 
.\"
.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.\" unbreakable dash.
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.ds qq ""
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
'br\}
.TH TRN 1 LOCAL
.UC 6
.SH NAME
trn - threaded read news program
.SH SYNOPSIS
.B trn [options] [newsgroups]
.SH DESCRIPTION
.I Trn
is a threaded version of
.I rn,
which is a replacement for the readnews(1) program.
Being \*(L"threaded\*(R" means that the articles are interconnected
in reply order.
Each discussion thread is a tree of articles where all the
reply (child) articles branch off from their respective originating
(parent) articles.
A representation of this tree (or a portion of it) is displayed in the
article header as you are reading news.
This gives you a better feel for how all the articles are related, and
even lets you see at a glance when an article has replies \*(-- a good
thing to check before posting.
In addition,
.I trn
has a thread selector that allows you to quickly browse through a
list of subjects and choose the ones you find interesting.
This thread selector sorts articles according to various criteria
and can be switched
into various display modes that allows you to pick all the subjects
separately (threads can have multiple subjects) or even pick individual
articles.
Any items you don't select can be saved for reading later or
marked as read with a single keystroke.
.PP
If you are already familiar with
.I trn
you may just want to read the
.IR "WHAT'S NEW" 
section.
People upgrading from
.I rn
will probably want to pay attention to the sections on
.IR "The Selector" ,
.IR "The Tree Display" ,
and the aforementioned
.IR "WHAT'S NEW" .
If you're impatient, just dive in and get started.
All the regular commands will be familiar to an
.I rn
or
.I trn
user, and the on-line help will give you a quick run-down of what commands
are available (just type \*(L'h\*(R' from any prompt).
I'd also suggest using the command:
.Sp
    trn \-x \-X
.Sp
to make sure some of the best features are turned on.
.Sh "Starting Trn"
If no newsgroups are specified, all the newsgroups which have unread news
will be presented to the user in the order in which they occur in the
.I .newsrc
file.
At the prompt for each group you can choose to read it, skip it, move it,
etc.
If a list of newsgroups is provided on the command line,
.I trn
will start up in \*(L"add\*(R" mode, using the list as a set of patterns to
add new newsgroups and restrict which newsgroups are displayed (see also
the discussion of the \*(L'a\*(R' command on the newsgroup-selection level).
.PP
.I Trn
operates on four levels: the newsgroup-selection level, the thread
selector, the article-reading level, and the paging level.
Each level has its own set of commands, and its own help menu.
At the paging level (the bottom level)
.I trn
behaves much like the
.IR more (1)
program.
At the article-reading level articles are presented to you in the
order of their replies, with the subjects being ordered by the date
of the oldest unread article (though there are commands for changing
the default display order).
In the thread selector you are presented with the subjects and
(usually) authors associated with each discussion thread, and given
a chance to choose which ones you wish to read now, save for later, or
manipulate in some way.
At the newsgroup-selection level (the top level), you may specify which
newsgroup you want next, or read them in the default order, which is the
order that the newsgroups occur in your
.I .newsrc
file.
(You will therefore want to rearrange your
.I .newsrc
file to put the most interesting newsgroups first.
This can be done with the \*(L'm\*(R' command on the Newsgroup Selection level.
WARNING: invoking readnews/vnews (the old user interface) in any way (including
as a news checker in your login sequence!) will cause your
.I .newsrc
to be disarranged again.)
.PP
On any level, at ANY prompt, help is available by typing an \*(L'h\*(R'.
This gives you a summary of available commands and what they do.
Remember this command, you'll need it.
.PP
Typing space to any question means to do the normal thing.
You will know what that is because
every prompt has a list of several plausible commands enclosed in
square brackets.
The first command in the list is the one which will be done if you type
a space.
(All input is done in cbreak mode, so carriage returns should not be typed
to terminate anything except certain multi-character commands.
Those commands will be obvious in the discussion below because they take an
argument.)
.PP
Upon startup,
.I trn
will do several things:
.Ip 1. 4
It will look for your
.I .newsrc
file, which is your list of subscribed-to
newsgroups.
If
.I trn
doesn't find a
.IR .newsrc ,
it will create one.
If it does find one, it will back it up under the name \*(L".\|oldnewsrc\*(R".
.Ip 2. 4
It will input your
.I .newsrc
file, listing out the first several newsgroups
with unread news.
.Ip 3. 4
It will perform certain consistency checks on your
.IR .newsrc .
If your
.I .newsrc
is out of date in any of several ways,
.I trn
will warn you and patch it up for you, but you may have to wait a little
longer for it to start up.
.Ip 4. 4
.I Trn
will next check to see if any new newsgroups have been created, and give
you the opportunity to add them to your
.IR .newsrc .
.Ip 5. 4
.I Trn
goes into the top prompt level \*(-- the newsgroup-selection level.
.Sh "Newsgroup Selection Level"
In this section the words \*(L"next\*(R" and \*(L"previous\*(R" refer to
the ordering of the newsgroups in your
.I .newsrc
file.
On the newsgroup-selection level, the prompt looks like this:
.Sp
====== 17 unread articles in talk.blurfl \*(-- read now? [ynq]
.Sp
unless the group is set for unthreaded reading, in which case the first
six characters are \*(L"******\*(R".
The following commands may be given at this level:
.Ip \+ 8
Enter this newsgroup through the selector.
.Ip y 8
Begin reading this newsgroup now.
.Ip SP 8
Enter the newsgroup by executing the default command listed in []'s.
.Ip .command 8
Do this newsgroup now, but execute
.I command
before displaying anything.
The command will be interpreted as if typed on the article selection level.
.Ip = 8
Start this newsgroup, but list subjects before displaying articles.
.Ip U 8
Enter this newsgroup through the unkill-articles prompt.
.Ip t 8
Toggle the newsgroup between threaded and unthreaded reading.
The default is threaded, and the current setting is stored in your .newsrc.
.Ip n 8
Go to the next newsgroup with unread news.
.Ip N 8
Go to the next newsgroup.
.Ip p 8
Go to the previous newsgroup with unread news.
If there is none, stay at the current newsgroup.
.Ip P 8
Go to the previous newsgroup.
.Ip \- 8
Go to the previously displayed newsgroup (regardless of whether it is
before or after the current one in the list).
.Ip 1 8
Go to the first newsgroup.
.Ip ^ 8
Go to the first newsgroup with unread news.
.Ip $ 8
Go to the end of the newsgroups list.
.Ip "g newsgroup" 8
Go to
.IR newsgroup ,
which can be the group's name or a zero-relative number of the groups in
your .newsrc (see the \*(L'L\*(R' command to list your .newsrc).
If it isn't currently subscribed to, you will be asked if you want to
subscribe.
.Ip "/pattern" 8
Scan forward for a newsgroup matching
.IR pattern .
Patterns do globbing like filenames, i.\|e., use * to match any sequence
of characters, and [] to specify a list of characters to match.
Use . to match a single character.
Unlike normal filename globbing, newsgroup-searching is not anchored to
the front and back of the filename, i.\|e. \*(L"/ski\*(R" will find
rec.skiing.
You may use ^ or $ to anchor the front or back of the search:
\*(L"/^test$\*(R" will find newsgroup test and nothing else
If you want to include newsgroups with 0 unread articles, append /r.
If the newsgroup is not found between the current newsgroup and the last
newsgroup, the search will wrap around to the beginning.
.Ip "?pattern" 8
Same as /, but search backwards.
.Ip u 8
Unsubscribe from the current newsgroup.
.Ip "l string" 8
List newsgroups not subscribed to which contain the string specified.
.Ip L 8 13v
Lists the current state of the
.IR .newsrc ,
along with status information.
.Sp
.nf
    \h'|0.5i'Status    \h'|2i'Meaning
    \h'|0.5i'<number>  \h'|2i'Count of unread articles in newsgroup.
    \h'|0.5i'READ      \h'|2i'No unread articles in newsgroup.
    \h'|0.5i'UNSUB     \h'|2i'Unsubscribed newsgroup.
    \h'|0.5i'BOGUS     \h'|2i'Bogus newsgroup.
    \h'|0.5i'JUNK      \h'|2i'Ignored line in .newsrc
\h'|2i'(e.\|g. readnews \*(L"options\*(R" line).
.fi
.Sp
(A bogus newsgroup is one that is not in the list of active newsgroups
in the active file, which on most systems is /usr/lib/news/active unless
you use NNTP.)
.Ip "m {name}" 8
Move the named newsgroup somewhere else in the
.IR .newsrc .
If no name is given, the current newsgroup is moved.
There are a number of ways to specify where you want the newsgroup \*(-- type
h for help when it asks where you want to put it.
.Ip c 8
Catch up \*(-- mark all unread articles in this newsgroup as read.
.Ip A 8
Abandon the changes made to the current newsgroup since
.I trn
was started.
Useful when you accidentally mark a group as read.
.Ip "o {pattern}" 8
.Ip "O {pattern}" 8
Only display those newsgroups whose name matches
.IR pattern .
Patterns are the same as for the \*(L'/\*(R' command.
Multiple patterns may be separated by spaces, just as on the
command line.
The restriction will remain in effect either until there are no articles
left in the restricted set of newsgroups, or another restriction command
is given.
Since
.I pattern
is optional, \*(L'o\*(R' by itself will remove the
restriction.
Using \*(L'O\*(R' will omit empty groups from the cycle.
.Ip "a pattern" 8
Add unsubscribed newsgroups matching
.IR pattern .
If any matching newsgroups are found, you will be asked for each one whether
you would like to add it.
If you want to add all the newsgroups, you can
type \*(L'Y\*(R' and they will be added the the end of the
.I .newsrc
file.
If you don't want to subscribe, all
the remaining groups can be ignored by typing \*(L'N\*(R'.
After any new newsgroups have been added, the \*(L'a\*(R' command also
restricts the current set of newsgroups just like the \*(L'O\*(R' command
does.
.Ip & 8
Print out the current status of command-line switches and any newsgroup
restrictions.
.Ip "&switch {switch}" 8
Set additional command-line switches.
.Ip && 8
Print out the current macro definitions.
.Ip "&&keys commands" 8
Define additional macros.
.Ip !command 8
Escape to a subshell.
One exclamation mark (!) leaves you in your own news directory.
A double exclamation mark (!!) leaves you in the spool
directory for news, which is usually /usr/spool/news unless you're
using NNTP to read news.
The environment variable SHELL will be used if defined.
If
.I command
is null, an interactive shell is started.
.Ip v 8
Print the current version number and information on where to send bug
reports.
.Ip q 8
Quit.
.Ip x 8
Quit, restoring .newsrc to its state at startup of
.IR trn .
The .newsrc you would have had if you had exited with \*(L'q\*(R' will be
called .newnewsrc, in case you didn't really want to type \*(L'x\*(R'.
.Ip ^K 8
Edit the global list of memorized commands (in the global KILL file) that
you wish to be performed in every newsgroup as it is started up (that is, when
it is selected at the newsgroup-selection level).
This file contains commands (one per line) such as /subject/:j or /author/f:+
to kill or select articles based on the indicated search criteria.
There is also a local list of commands for each newsgroup that can contain
kill/selection commands tailored for each specific group.
Because of the overhead involved in searching for articles to kill, it is
better if possible to use a local list rather than the global one.
Local memorized commands are usually maintained by using the \*(L'A\*(R'
or \*(L'T\*(R' commands from the article/pager level or in the selector.
There is also a K search modifier that appends any search command you
desire to add.
It is also possible to manually edit the file with the \*(L'^K\*(R'
command from anywhere inside a newsgroup.
If either of the environment variables VISUAL or EDITOR is set, the
specified editor will be invoked; otherwise a default editor
is invoked on the KILL file.
.Sh "The Selector"
Most people who don't have all day to read news will want to enter a newsgroup
by way of the selector.
This is accomplished by using the \*(L'+\*(R'
command at the newsgroup-selection or article/pager levels.
In fact, this may be the default command for entering a newsgroup, depending
on how your version of
.I trn
was configured and your use of the
.B \-X
option.
.PP
The selector displays a list of articles by their subjects and (usually)
authors.
The articles are grouped into threads by default (which may list multiple
subjects per selectable item if the subject has changed during the discussion)
and ordered by the date of their oldest unread article.
Thread or subject groups are also shown with a count of the number of
articles in each group.
Each selectable item is preceded by a letter or number that can be typed
to toggle its selection.
Items that are selected are flagged with a \*(L'+\*(R' after their letter.
Groups that have only some of their articles selected are flagged with
a \*(L'*\*(R'.
You can change the selector's mode (to pick each subject separately or
pick individual articles), order the list by a variety of sort
criteria, and switch the author display between its long, medium and short
styles using the commands detailed below.
.PP
The following commands are available in the selector:
.Ip "a-z,0-9,A-Z" 8
Select/deselect the indicated item by its letter or number.
There are quite a few letters omitted from the alpha characters to be
typed as commands \*(-- see below.
Also, the variable SELECTCHARS is available to customize which characters
you want to be used as selection letters, overriding their command function.
.Ip SP 8
Perform the default command.
This is usually > for most pages, and Z on the last page (although D and X
are also quite popular).
.Ip CR 8
Begin reading.
If no articles are selected, the current item is selected (unless you've
marked it as killed).
.Ip "Z,TAB" 8
Begin reading.
If no articles are selected, read all unread articles.
.Ip "\*(L'.\*(R'" 8
Toggle the current item's selection (the one under the cursor).
.Ip * 8
Same as \*(L'.\*(R' except that it affects all articles with the same
subject (useful in the article selector).
.Ip # 8
Make an overriding selection that reads the current item only,
temporarily ignoring all other selections.
.Ip "k, \*(L',\*(R'" 8
Mark the current item as killed.
.Ip "m, \e" 8
Unmark the current item.
.Ip \- 8
Set a range, as in a \- k.
Repeats the last marking action: selection, deselection, killing,
or unmarking.
.Ip @ 8
Toggle all visible selections.
.Ip M 8
Mark the current item's article(s) to return on newsgroup exit
and kill the item.
.Ip Y 8
Yank back and select the marked-to-return articles, clearing their
to-return status.
.Ip E 8
Exclude all unselected items from the selection list (narrow the display).
Press it again to pick from all available items.
.Ip "n, ]" 8
Move down to the next item (try the down-arrow keypad key also).
.Ip "p, [" 8
Move up to the previous item (try the up-arrow keypad key also).
.Ip < 8
Go to previous page (try the left-arrow keypad key also).
.Ip > 8
Go to next page (try the right-arrow keypad key also).
.Ip ^ 8
Go to the first page.
.Ip $ 8
Go to the last page.
.Ip S 8
Set the items the selector displays: threads, subjects or articles.
If the group is unthreaded setting this to threads will thread the
group.
.Ip = 8
Switch between the article selector and the subject/thread selector.
.Ip O 8
Pick the order for the items: date, subject, author, item count
(for thread/subject groups), and a subject-date grouping of
individual articles.
Typing the selection in lower-case will sort the articles in the
default direction, while using upper-case will reverse the sort.
There is a separate default sort order for the subject/thread selector
and the article selector.
See the
.B \-O
option to set your favorite selector mode and sort order as the default.
.Ip R 8
Reverse the current sort order.
.Ip L 8
Switch the selector's display between the long, medium and short
display styles.
See the
.B \-x
option to set your favorite style as the default.
.Ip U 8
Switch between selecting unread/read articles.
.Ip X 8
Mark all unselected articles as read and start reading.
.Ip D 8
Mark unselected articles on the current page as read and
begin reading if articles are selected, otherwise go to the next page.
.Ip J 8
Mark all selected articles as read (useful after performing some action
on them with the \*(L':\*(R' command).
.Ip c 8
Catch up \*(-- marks ALL articles as read without affecting their cross-posted
counterparts.
.Ip A 8
Add a subject-search command to the memorized list (a.\|k.\|a. a KILL file)
for this group.
You are prompted to choose selection (+), junking (j),
selection including all replies (.) or junking including all replies (,).
If the thread has more than one subject the first subject is the one
chosen for the memorized command.
.Ip T 8
Add a thread-oriented command to the memorized list for this group.
You are prompted to choose selecting the thread (+), junking the
thread (j), or clearing the auto-selection/junking for the thread (c).
(Note: there are three other options (\*(L'.\*(R', \*(L',\*(R',
and \*(L'C\*(R') on the
article-reading level \*(-- look there for an explanation of their use.)
.Ip ^K 8
Edit the local list of memorized commands (a.\|k.\|a. a KILL file) for this
newsgroup.
A detailed description of memorized commands is found in the Article Selection
section.
.Ip ":command" 8
Apply a command to all the selected threads or their selected articles.
You can also use ":E" to end a binary extraction or ":p" to post a new article.
Use \*(L"::command\*(R" to apply it to all non-selected threads/articles.
.Sp
Applicable commands include \*(L'+\*(R'/\*(L'-\*(R' (select/deselect
an article), \*(L"++\*(R"/\*(L"--\*(R" (select/deselect a thread),
\&\*(L"T+\*(R" (auto-select the entire thread), \*(L"Tj\*(R"
(auto-junk the entire thread), \*(L't\*(R'
(display article tree), \*(L"s dest\*(R" (save article to a destination),
\*(L"e dir\*(R" (extract to directory), \*(L'E\*(R' (end partial uudecode),
as well as: S, |, w, W, m, M, j, = and \*(L',\*(R'.
.Ip ":.command" 8
Apply a command to the current thread or the selected articles in the
current thread.
Use \*(L"::.command\*(R" to apply a command to the unselected articles in
the current thread.
.Ip "/pattern" 8
Scan all articles for a subject containing
.I pattern
and select it.
.Ip "/pattern/modifiers:command{:command}" 8
Apply the commands listed to articles matching the search command (possibly
with h, a, b, r, or K modifiers).
The default action, if no command is specified, is to select the article's
item in the selector (e.\|g. the entire thread (\*(L"++\*(R") in the thread
selector).
See the section on Regular Expressions and the description of pattern
searching in the Article Selection section.
.Sp
One example: to scan all the unread articles looking for \*(L"topic\*(R"
anywhere in the article and then select its group and save the articles to
the files topic.1, topic.2, etc. use \*(L"/topic/a:++:s topic.%#\*(R".
.Ip N 8
Go to the next newsgroup with unread news.
.Ip P 8
Go to the previous newsgroup with unread news.
.Ip & 8
Display or set the current status of command-line switches.
.Ip && 8
Display or set the current macro definitions.
.Ip !command 8
Escape to a subshell.
.Ip q 8
Quit this group.
.Ip "ESC,+" 8
Quit the selector to the article level.
Note: ESC won't work if trn has mapped your arrow keys with default macros
and the first character that your arrow keys send is an ESC.
.Ip Q 8
Quit the current newsgroup and return to the newsgroup-selection prompt
for this group.
.Sh "Article-Reading Level"
On the article-reading level,
.I trn
displays unread articles in thread sequence (reading each article and its
replies before going on to another topic) unless threads are disabled for
a particular group, in which case the default order is the order they
arrived at your site (numeric sequence).
In either case if you use the subject-search command (^N) you will switch
to reading the articles in date order within each matching subject.
(Making selections in the subject selector or using the
.B \-S
switch will automatically turn subject search mode on in an unthreaded group.)
.Sp
On the article-reading level you are
.I not
asked whether you want to read an article before the article is displayed;
rather,
.I trn
simply displays the first page (or portion of a page, at low baud rates) of an
article and asks if you want to continue.
The normal article-reading prompt comes at the END of an article
(although article-reading commands can also be given from within the middle
of an article in addition to the pager level commands).
The prompt at the end of an article looks like this:
.Sp 
End of article 248 (of 257) \*(-- what next? [npq]
.Sp
The following are the options at this point:
.Ip n,SP 8
Scan forward for next unread article.
(Note: the \*(L'n\*(R' (next) command when typed at the end of an article
does not mark the article as read, since an article is automatically marked
as read after the last line of it is printed.
It is therefore possible to type a sequence such as \*(L'mn\*(R' and leave
the article marked as unread.
The fact that an article is marked as read by typing n, N, ^N, F, R, e,
s, S, |, w, or W within the MIDDLE of the article is in fact a special
case.)
.Ip N 8
Go to the next article.
.Ip ^N 8
Find the next article with the same subject in date order.
This also makes subject search mode (^N) the default command at the end
of an article.
.Ip p 8
Scan backward for previous unread article.
If there is none, stay at the current article.
.Ip P 8
Go to the previous article.
.Ip \- 8
Go to the previously displayed article (regardless of whether that article
is before or after this article in the normal sequence).
.Ip ^P 8
Find the previous article with the same subject in date order.
Makes subject search mode (^N) the default.
.Ip _N 8
Go to the next article in numeric sequence.
.Ip _P 8
Go to the previous article in numeric sequence.
.Ip "<, >" 8
Browse the previous/next selected thread/subject.
If no selections have been made, all the threads that had unread news when
you entered the newsgroup (or last left the selector) are treated
as selected.
Entering an empty newsgroup makes all the already-read threads available
for browsing.
.Ip "[, ]" 8
Proceed to the left/right in the article tree.
Visits already-read articles as well as empty nodes.
Try using the left-/right-arrow keys also.
.Ip "{, }" 8
Go to the root/leaf of the article tree, even if the node is
already read or empty.
Proceeds to the very first/last node if you're already at a root/leaf in
a multi-root thread.
.Ip "(, )" 8
Go to the previous/next sibling in the thread, including \*(L"cousin\*(R"
siblings.
Try using the up-/down-arrow keys also.
.Ip t 8
Display the entire article tree and all its associated subjects.
If the group is not currently threaded, it will become threaded to
process this command.
.Ip ^R 8
Restart the current article.
.Ip v 8
Restart the current article verbosely, displaying the entire header.
.Ip ^L 8
Refresh the screen.
.Ip ^X 8
Restart the current article, and decrypt as a rot13 message.
.Ip X 8
Refresh the screen, and decrypt as a rot13 message.
.Ip b 8
Back up one page.
.Ip ^E 8
Display the last page of the article.
.Ip q 8
Quit this newsgroup and go back to the newsgroup-selection level.
.Ip ^ 8
Go to the first unread article.
.Ip $ 8
Go to the last article (actually, one past the last article).
.Ip "number" 8
Go to the numbered article.
.Ip _C 8
Switch to next available charset conversion.
.Ip "range{,range}:command{:command}" 8
Apply a set of commands to a set of articles.
A range consists of either <article number> or
<article\ number>\-<article\ number>.
A dot \*(L'.\*(R' represents the current article, and a dollar
sign \*(L'$\*(R' represents the last article.
.Sp
Applicable commands include \*(L'm\*(R' (mark as unread), \*(L'M\*(R'
(mark as read-until-exit), \*(L'j\*(R' (mark as read), \*(L"s dest\*(R"
(save to a destination), \*(L"e dir\*(R" (extract to directory),
\&\*(L"!command\*(R" (shell escape), \*(L"=\*(R" (print the subject),
\&\*(L'+\*(R'/\*(L'-\*(R' (select/deselect the article),
\&\*(L'T+\*(R' (auto-select the entire thread), \*(L'Tj\*(R'
(auto-junk the entire thread), \*(L"++\*(R"/\*(L"--\*(R" (select/deselect
the associated thread), \*(L'C\*(R' (cancel),
as well as S, |, w, W, and t.
.Ip ":command" 8
Apply a command to all the selected threads or their selected articles.
Use \*(L"::command\*(R" to apply it to all non-selected threads/articles.
For applicable commands, see the discussion above for the range command.
.Ip ":.command" 8
Apply a command to the current thread or the selected articles in the
current thread.
Use \*(L"::.command\*(R" to apply a command to the unselected articles in
the current thread.
.Ip j 8
Junk the current article (i.\|e. mark it as read).
If this command is used from within an article, you are left at the end of
the article, unlike \*(L'n\*(R', which looks for the next article.
.Ip m 8
Mark the current article as still unread.
(If you don't want to see this article for a while you're probably better
off using M instead of m, otherwise this article might get picked again
as the first available article sooner than you'd like.)
.Ip M 8
Mark the current article to return on newsgroup exit.
Until then, the current article will be marked as read.
This is useful for returning to an article in another session.
.Ip Y 8
Yank back the marked-to-return articles, clearing their to-return status.
If you are reading selected articles, the yanked articles come back selected.
.Ip /pattern 8
Scan forward for article containing
.I pattern
in the subject.
See the Regular Expressions section.
Together with the escape substitution facility described later, it becomes
easy to search for various attributes of the current article, such as
subject, article ID, author name, etc.
The previous pattern can be recalled with ESC.
If
.I pattern
is omitted, the previous pattern is assumed.
.Ip /pattern/f 8
Scan forward for article containing
.I pattern
in the from line.
If you are using thread files the article data you are matching against
MAY contain only the real name of the user.
If you want to always match the full from line, see the following
header-matching option that will read in the full from-line data if
it is not already available.
.Ip /pattern/Hheader 8
Scan forward for article containing
.I pattern
in the indicated
.I header.
Because we scan the entire string up to the end of the modifiers, this
modifier must be the last one.
For example, \*(L"/jsmoe@somesite.com/rHfrom:m+\*(R" will mark all
articles from \*(L"jsmoe@somesite.com\*(R" as unread and select them.
Note that if the header line isn't one that trn recognizes in its
header parser, you'll have to use the following full-header matching.
.Ip /pattern/h 8
Scan forward for an article containing
.I pattern
in the header.
.Ip /pattern/a 8
Scan forward for an article containing
.I pattern
anywhere in the article.
.Ip /pattern/b 8
Scan forward for an article containing
.I pattern
in the body of the article, but not the signature.
(The signature must be properly delimited to be ignored, however.)
.Ip /pattern/B 8
Scan forward for an article containing
.I pattern
anywhere in the body of the article.
.Ip /pattern/r 8
Scan read articles also.
.Ip /pattern/c 8
Make search case sensitive.
Ordinarily upper- and lower-case are considered the same.
.Ip /pattern/t 8
Force the search to start at the top of the group (useful while reading
the group, since the default is to start at the current article).
.Ip /pattern/I 8
Force the search to ignore the THRU line when executed as a memorized
command.
If the command portion is a selection command (i.\|e. it starts with
a \*(L'+\*(R' or a \*(L'.\*(R') this is the default behavior.
.Ip /pattern/N 8
Force the search to NOT ignore the THRU line when executed as a memorized
command (useful on selection commands -- see also \-k).
.Ip "/pattern/modifiers:command{:command}" 8
Apply the commands listed to articles matching the search command (possibly
with h, a, b, or r modifiers).
Applicable commands include \*(L'm\*(R' (mark as UNread), \*(L'M\*(R'
(mark as read-until-exit), \*(L'j\*(R' (junk -- mark as read in all groups),
\&\*(L'x\*(R' (mark as read in this group),
\&\*(L"s dest\*(R" (save to a dest), \*(L"e dir\*(R" (extract to dir),
\&\*(L"!command\*(R" (shell escape), \*(L"=\*(R" (print the subject),
\&\*(L'+\*(R' (select the article), \*(L'-\*(R' deselect the article,
\&\*(L'T+\*(R' (auto-select the entire thread), \*(L'Tj\*(R'
(auto-junk the entire thread), \*(L"++\*(R" (select the associated thread),
\&\*(L"--\*(R" deselect the associated thread), and \*(L'C\*(R' (cancel).
If the first command is \*(L'm\*(R' or \*(L'M\*(R', modifier r is assumed.
A K may be included in the modifiers (not the commands) to cause the
entire command (sans K) to be saved to the local KILL file, where it will
be applied to every article that shows up in the newsgroup.
.Sp
For example, to save all articles in a given newsgroup to the line printer
and mark them read, use \*(L"/^/\||\|lpr:j\*(R".
If you type \*(L"/^/K\||\|lpr:j\*(R", this will happen every time you enter the
newsgroup.
.Ip ?pattern 8
Scan backward for article containing
.I pattern
in the subject.
May be modified as the forward search is: ?pattern?modifiers[:commands].
It is likely that you will want an r modifier when scanning backward.
.Ip k 8
Mark as read all articles with the same subject as the current article.
(Note: there is no single character command to temporarily mark as read (M
command) articles matching the current subject.
That can be done with \*(L"/<ESC>s/M\*(R", however.)
.Ip \, 8
Mark the current article and all its replies as read.
.Ip J 8
Junk all the articles in the current thread, even if it contains multiple
subjects.
.Ip A 8
Add a subject-search command to the memorized list for this group (in the
KILL file).
You are prompted to choose selection (+), junking (j),
selection including all replies (.) or junking including all replies (,).
.Ip K 8
This is a synonym for the command \*(L"Aj\*(R" which adds a command to
junk the current subject to the memorized commands for the group.
See also the K modifier on searches above.
.Ip T 8
Add a thread-oriented command to the memorized list for this group.
You are prompted to choose selection of entire thread (+), junking of
entire thread (j), selection of an article and its replies (.), junking
of an article and its replies (,), clearing the auto-selection/junking
for this thread (c), or clearing the auto-selection/junking for an article
and its replies (C).
.Ip ^K 8
Edit the local list of memorized commands (a.\|k.\|a. a KILL file) for this
newsgroup.
Each line of the KILL file is either a subject-affecting command of the
form /pattern/x or a thread-affecting command of the form <message-id> Tx.
The first line in the KILL file has the form \*(L"THRU <number>\*(R",
which tells
.I trn
the maximum article number that the KILL file has been applied to.
The THRU value is usually only used to keep header or article searches
from happening multiple times.
Subject and from-line searches are quite fast if the group has cached data
around (e.\|g. a .\|thread or .\|overview file).
If it doesn't, the THRU line is used to set a lower boundary on the
search to keep the startup time as short as possible.
If trn skipped some selections (or you're not sure), wait for the group to
finish being cached (e.\|g. visiting the selector forces the caching of
all unread articles), quit the group, and re-enter.
.Sp
To see only newgroup articles in the control newsgroup, for instance, you
might include the line
.Sp
/newgroup/:+
.Sp
which selects all subjects containing \*(L"newgroup\*(R".
You can add lines automatically via the A and T commands as well as the
K search modifier, but editing is the only way to remove subject commands
(thread commands die automatically as the thread dies).
If either of the environment variables VISUAL or EDITOR is set, the
specified editor will be invoked; otherwise a default editor (normally vi)
is invoked on the KILL file.
.Sp
The KILL file may also contain switch-setting lines beginning with \*(L'&\*(R'
(see the section on \*(L"Options\*(R") and special commands beginning
with \*(L'*\*(R'.
There are two such commands at the moment:  \*(L"*j\*(R" (junk all articles
from THRU to the end of the group) and \*(L"*X\*(R" (junk all
.I unselected
articles from THRU to the end of the group).
Additionally, any line beginning with \*(L'X\*(R' is executed on exit
from the newsgroup rather than on entrance.
This can be used to set switches back to a default value.
One use for this capability is to set your save directory to a custom value
upon entry to a newsgroup and set it back on exit using the \-ESAVEDIR option.
See also the
.B \-/
option for another solution to multiple save directories without using KILL
files.
.Ip r 8
Reply through net mail.
The environment variables MAILPOSTER and MAILHEADER may be used to modify
the mailing behavior of
.I trn
(see the environment section).
If the current article does not exist (such as the \*(L"End of newsgroup\*(R"
pseudo-article you can get to with a \*(L'$\*(R' command), invokes the mailer
to nobody in particular.
.Ip R 8
Reply, including the current article in the header file generated.
(See \*(L'F\*(R' command below).
The YOUSAID environment variable controls the format of the attribution line.
.Ip ^F 8
Forward the current article.
.Ip f 8
Submit a follow-up article.
If the current article does not exist (such as the \*(L"End of newsgroup\*(R"
pseudo-article you can get to with a \*(L'$\*(R' command), posts an original
(root) article.
.Ip F 8
Submit a follow-up article, and include the old article, with lines prefixed
either by \*(L">\*(R" or by the argument to the
.B \-F
switch.
.I Trn
will attempt to provide an attribution line in front of the quoted article,
generated from the From: line of the article.
Unfortunately, the From: line doesn't always contain the right name; you
should double check it against the signature and change it if necessary,
or you may have to apologize for quoting the wrong person.
The environment variables NEWSPOSTER, NEWSHEADER and ATTRIBUTION may be
used to modify the posting behavior of
.I trn
(see environment section).
.Ip C 8
Cancel the current article, but only if you are the contributor or superuser.
.Ip z 8
Supersede the current article, but only if you are the contributor.
.Ip Z 8
Same as the \*(L'z\*(R' command, but you start with a copy of the
original article to work with.
.Ip c 8
Catch up in this newsgroup; i.\|e., mark all articles as read.
.Ip U 8
Unkill articles.
You can choose to unkill the current thread, sub-thread (the current article
and its replies), all the articles, or start up the selector
to choose specific articles to unkill.
.Ip u 8
Unsubscribe from this newsgroup.
.Ip "s destination" 8
Save to a filename or pipe using sh.
If the first character of the destination is a vertical bar, the rest of
the command is considered a shell command to which the article is passed
through standard input.
The command is subject to filename expansion.
(See also the environment variable PIPESAVER.)
If the destination does not begin with a vertical bar, the rest of the
command is assumed to be a filename of some sort.
An initial tilde \*(L'~\*(R' will be translated to the name of the home
directory, and an initial environment variable substitution is also allowed.
If only a directory name is specified, the environment variable SAVENAME
is used to generate the actual name.
If a non-absolute filename is specified, the environment variable
SAVEDIR will be used to generate the actual directory.
If nothing is specified, then obviously both variables will be used.
Since the current directory for
.I trn
while doing a save command is your
private news directory, typing \*(L"s ./filename\*(R" will force the file
to your news directory.
Save commands are also run through % interpretation, so that you can
enter \*(L"s %O/filename\*(R" to save to the directory you were in when you ran
.IR trn ,
and \*(L"s %t\*(R" to save to a filename consisting of the Internet address
of the sender.
.Sp
After generating the full pathname of the file to save to,
.I trn
determines if the file exists already, and if so, appends to it.
.I trn
will attempt to determine if an existing file is a mailbox or a normal file,
and save the article in the same format.
If the output file does not yet exist,
.I trn
will by default ask you which format you want, or you can make it skip the
question with either the
.B \-M
or
.B \-N
switch.
If the article is to be saved in mailbox format, the command to do so is
generated from the environment variable MBOXSAVER.
Otherwise, NORMSAVER is used.
.Ip "S destination" 8
Save to a filename or pipe using a preferred shell, such as csh.
Which shell is used depends first on what you have the environment variable
SHELL set to, and in the absence of that, on what your news administrator
set for the preferred shell when he or she installed
.IR trn .
.Ip "| command" 8
Shorthand for \*(L"s | command\*(R".
.Ip "w destination" 8
The same as \*(L"s destination\*(R", but saves without the header.
.Ip "W destination" 8
The same as \*(L"S destination\*(R", but saves without the header.
.Ip "e directory" 8
Extract a shell archive or uuencoded binary to the designated directory.
The article is first scanned to try discover what type of data is
encapsulated.
If a \*(L"cut here\*(R" line is found, the first non-blank line after it
must be either the start of a shar header, or the \*(L"begin\*(R"
or \*(L"table\*(R" line of a uuencoded binary.
The default for extracting shars is to send the data portion of the file
to /bin/sh, but that can be overridden with the UNSHAR variable (see the
ENVIRONMENT section).
Uudecoding is done internally by a decoder that can handle the data
being split up over multiple articles, and extracted one piece at a time.
To decode a multi-article file, either execute the \*(L'e\*(R'
command in each article in sequence, use an article range to execute the
command, or use the \*(L":e\*(R" command to repeat the command for each of the
currently selected articles.
When the \*(L'e\*(R' command is not followed by any arguments, it will
repeat the arguments from the last extraction.
All directory specifications are relative to the value of SAVEDIR, so you
can use the command \*(L"e .\*(R" to force an extraction to SAVEDIR itself.
If a uudecoding is in progress (i.\|e. the last piece wasn't extracted yet)
and you exit the group, the partial file will be removed.
This also occurs if you start to extract a new uuencoded file before the
previous one was finished.
See also the \*(L'E\*(R' command for ending a multi-part uudecoding
manually.
.Sp
There is one special case that is handled differently: if the first file in a
recognizable shar file is a uuencoded binary that was packed with lines
starting with an \*(L'X\*(R', we will not unshar the file but instead
uudecode it.
If this causes problems, you can override the default extraction method
by following the directory with an explicit command to execute, as
described below.
.Ip "e directory|command" 8
This form of the \*(L'e\*(R' command allows you to extract other data
formats than shar or uuencoded files or to override the decisions made
by the automatic extraction selection described above.
In normal operation, all data following what we recognize as
a \*(L"cut here\*(R" line will be sent to the specified command.
Additionally, the distinctive beginning of a shell archive is also recognized
without a preceding cut line.
When the command is run, the default directory will be set to the
specified directory, or the value
of SAVEDIR if unspecified.
Entering the \*(L'e\*(R' command without arguments will repeat your
previous extract command.
You can use the command \*(L"e dir|\*(R" to extract to a new directory
using the previously-specified command.
.Ip E 8
This command ends any multi-part uuencoded file extraction that you began,
but are unable (or unwilling) to complete.
The partially extracted file is removed.
.Ip & 8
Print out the current status of command-line switches.
.Ip "&switch {switch}" 8
Set additional command-line switches.
.Ip && 8
Print out current macro definitions.
.Ip "&&keys commands" 8
Define an additional macro.
.Ip !command 8
Escape to a subshell.
One exclamation mark (!) leaves you in your own news directory.
A double exclamation mark (!!) leaves you in the spool
directory of the current newsgroup.
The environment variable SHELL will be used if defined.
If
.I command
is null, an interactive shell is started.
.Sp
You can use escape key substitutions described later to get to many
run-time values.
The command is also run through % interpretation, in case it is being called
from a range or search command.
.Ip \+ 8
Start the selector in the last-used mode.
If the newsgroup is unthreaded and the default selector mode is threads,
we temporarily switch to subject selection unless manually overridden.
.Ip _a 8
Start the selector in article mode.
.Ip _s 8
Start the selector in subject mode.
.Ip _t 8
Start the selector in thread mode.
.Ip _T 8
Start the selector in thread mode unless the group isn't threaded, in
which case we settle for the subject selector.
.Ip = 8
List subjects of unread articles.
.Ip # 8
Print last article number.
.Ip _+ 8
Select the entire thread associated with the current article.
.Ip _- 8
Deselect the entire thread associated with the current article.
.Sh "Pager Level"
At the pager level (within an article), the prompt looks like this:
.Sp
\*(--MORE\*(--(17%)
.Sp
and a number of commands may be given:
.Ip SP 8
Display next page.
.Ip x 8
Display next page and decrypt as a rot13 message.
.Ip d 8
Display half a page more.
.Ip CR 8
Display one more line.
.Ip q 8
Go to the end of the current article (don't mark it either read or unread).
Leaves you at the \*(L"What next?\*(R" prompt.
.Ip j 8
Junk the current article.
Mark it read and go to the end of the article.
.Ip ^L 8
Refresh the screen.
.Ip X 8
Refresh the screen and decrypt as a rot13 message.
.Ip b 8
Back up one page.
.Ip ^E 8
Display the last page of the article.
.Ip _C 8
Switch to next available charset conversion.
.Ip t 8
Display the entire article tree, including its associated subjects, and
continue reading.
If the group is not currently threaded, it will be threaded first.
.Ip gpattern 8
Goto (search forward for)
.I pattern
within current article.
Note that there is no space between the command and the pattern.
If the pattern is found, the page containing the pattern will be displayed.
Where on the page the line matching the pattern goes depends on the value
of the
.B \-g
switch.
By default the matched line goes at the top of the screen.
.Ip G 8
Search for g pattern again.
.Ip ^G 8
This is a special version of the \*(L'g\*(R' command that is for skipping
articles in a digest.
It is equivalent to setting \*(L"\-g4\*(R" and then executing the command
\*(L"g^Subject:\*(R".
.Ip TAB 8
This is another special version of the \*(L'g\*(R' command that is for
skipping inclusions of older articles.
It is equivalent to setting \*(L"\-g4\*(R" and then executing the command
\*(L"g^[^c]\*(R", where \fIc\fR is the first character of the last line
on the screen.
It searches for the first line that doesn't begin with the same character
as the last line on the screen.
.Ip !command 8
Escape to a subshell.
.PP
The following commands skip the rest of the current article, then behave just
as if typed to the \*(L"What next?\*(R" prompt at the end of the article.
See the documentation at the article selection level for these commands.
.Sp	
    # $ & / = ? A c C f F k K T ^K J , m M r R ^R u U v Y ^
.br
    p P ^P - < > [ ] { } number
.br
    range{,range} command{:command}
.Sp
The following commands also skip to the end of the article, but have the
additional effect of marking the current article as read:
.Sp
    n N ^N e s S | w W
.Sp
.Sh "Miscellaneous facts about commands"
An \*(L'n\*(R' typed at either the \*(L"Last newsgroup\*(R" prompt or a
\*(L"Last article\*(R" prompt will cycle back to the top of the newsgroup
or article list, whereas a \*(L'q\*(R' will quit the level.
(Note that \*(L'n\*(R' does not mean \*(L"no\*(R", but rather
\*(L"next\*(R".)
A space will of course do whatever is shown as the
default, which will vary depending on whether
.I trn
thinks you have more articles or newsgroups to read.
.PP
The \*(L'b\*(R' (backup page) command may be repeated until the beginning of
the article is reached.
If
.I trn
is suspended (via a ^Z), then when the job is resumed, a refresh (^L) will
automatically be done (Berkeley-type systems only).
If you type a command such as \*(L'!\*(R' or \*(L's\*(R' which takes you
from the middle of the article to the end, you can always get back into the
middle by typing \*(L'^L\*(R'.
.PP
In multi-character commands such as \*(L'!\*(R', \*(L's\*(R', \*(L'/\*(R',
etc, you can interpolate various run-time values by typing escape and a
character.
To find out what you can interpolate, type escape and \*(L'h\*(R', or check
out the single character % substitutions for environment variables in the
Interpretation and Interpolation section, which are the same.
Additionally, typing a double escape will cause any % substitutions in the
string already typed in to be expanded.
.Sh "The Tree Display"
When reading a threaded newsgroup,
.I trn
displays a character representation of the article tree in the upper right
corner of the header.
For example, consider the following display:
.Sp
.nf
.in +4n
(1)+-(1)--(\fI2\fP)--\fI[2]\fP
\h'\w'(1)'u'|-(1)+-<3>
\h'\w'(1)'u'|\h'\w'-(1)'u'\\-[1]
\h'\w'(1)'u'\\-(1)+-[1]--[1]
\h'\w'(1)+-(1)'u'\\-[1]
.in -4n
.fi
.Sp
This tree represents an initial article that has three direct replies
(the second column with three (1)'s).
Each reply has further replies branching off from them.
In two cases the subject line was altered in the reply, as indicated
by the increasing numbers.
.PP
The third subject is not selected for reading, as indicated by the <>'s.
Note you can always forcefully visit an unselected article with \*(L'N\*(R'
and \*(L'P\*(R' as well as the thread-navagation commands (which are
typically macro'ed to the arrow keys on your keypad).
.PP
When there is only one subject associated with a thread, all the nodes
are marked with the number 1.
When the first subject change arrives, it is marked with the number 2,
and so on.
If you were to look at this thread in the thread selector, the three
subjects associated with it would be listed in the same order as the
ascending digits.
In those rare cases where more than 9 subjects are associated with each
thread, the nodes are marked with the letters A-Z, and then by a-z.
.PP
The articles that have already been read are enclosed in ()'s,
Unread articles are displayed in []'s, and unread-but-unselected articles
are displayed in <>'s.
The currently displayed article has its entire node highlighted in the
display.
The previously displayed article has only its number highlighted.
If the group has not been completely threaded yet, some articles will
appear as (?) until trn can determine if the referenced article truly
exists or not.
If you visit such an article and wait for trn to finish threading the
group, the screen will refresh as soon as the presence or absence of
the article is determined.
.Sh "Options"
.I Trn
has a nice set of options to allow you to tailor the interaction
to your liking.
(You might like to know that the author swears by
\*(L"\-x6ms \+e \-mu \-S -XX -N -B -p\*(R".)
These options may be set on the command line, via the TRNINIT
environment variable, via a file pointed to by the TRNINIT variable, or
from within
.I trn
via the & command.
Options may generally be unset by typing \*(L"+switch\*(R".
Options include:
.TP 5
.B \-a
causes trn to always thread the unread articles on entry to a group.
Without this option trn may enter a group in a partially-threaded
state and process the unthreaded articles in the background.
The down side of this is that the tree display may not be complete when
it is first displayed and you may start out at an odd position in the
first thread's article tree.
.TP 5
.B \-A
tells trn to attempt to create some default macros that will map your
arrow keys to useful trn functions (this is the default).
Use 
.B +A
to turn this behavior off.
.TP 5
.B \-b
will force trn to read each thread in a breadth-first order, rather than
depth-first.
.TP 5
.B \-B
will turn on a spinner that twirls when trn is doing background
article-processing.
A gizmo for those interested in what's going on behind the scenes.
.TP 5
.B \-c
checks for news without reading news.
If a list of newsgroups is given on the command line, only those newsgroups
will be checked; otherwise all subscribed-to newsgroups are checked.
Whenever the
.B \-c
switch is specified, a non-zero exit status from
.I trn
means that there is unread news in one of the checked newsgroups.
The
.B \-c
switch does not disable the printing of newsgroups with unread news;
this is controlled by the
.B \-s
switch.
(The
.B \-c
switch is not meaningful when given via the & command.)
.TP 5
.B \-C<number>
tells
.I trn
how often to checkpoint the
.IR .newsrc ,
in articles read.
Actually, this number says when to start thinking about doing a checkpoint
if the situation is right.
If a reasonable check-pointing situation doesn't arise within 10 more
articles, the
.I .newsrc
is check-pointed willy-nilly.
.TP 5
.B \-d<directory name>
sets your private news directory to something other than ~/News.
The directory name will be globbed (via csh) if necessary (and if possible).
The value of SAVEDIR (where articles are saved) is initially set to this
directory, but is often manipulated via the
.B \-/
option or by manipulating SAVEDIR directly (perhaps via the memorized
commands (the KILL file) for a group.
Any KILL files (see the K command in the Article Selection section)
also reside in this directory and its subdirectories, by default.
In addition, shell escapes leave you in this directory.
.TP 5
.B \-D<flags>
enables debugging output.
See common.h for flag values.
Warning: normally
.I trn
attempts to restore your
.I .newsrc
when an unexpected signal or internal error occurs.
This is disabled when any debugging flags are set.
.TP 5
.B \-e
causes each page within an article to be started at the top of the screen,
not just the first page.
(It is similar to the
.B \-c
switch of
.IR more (1).)
You never have to read scrolling text with this switch.
This is helpful especially at certain baud rates because you can start reading
the top of the next page without waiting for the whole page to be printed.
It works nicely in conjunction with the
.B \-m
switch, especially if you use half-intensity for your highlight mode.
See also the
.B \-L
switch.
.TP 5
.B \-E<name>=<val>
sets the environment variable <name> to the value specified.
Within
.IR trn ,
\*(L"&\-ESAVENAME=%t\*(R" is similar to \*(L"setenv SAVENAME '%t'\*(R" in
.IR csh ,
or \*(L"SAVENAME='%t'; export SAVENAME\*(R" in
.IR sh .
Any environment variables set with
.B \-E
will be inherited by subprocesses of
.IR trn .
.TP 5
.B \-f
will make trn avoid various sleep calls and the prompt after the processing
of the memorized commands that are intended to allow you time to read a
message before the screen clears.
This allows the advanced user to cruise along a little faster at the
expense of readability.
The \-t (terse) option turns on -f by default, but you can override this
by specifying \+f after the \-t option.
.TP 5
.B \-F<string>
sets the prefix string for the \*(L'F\*(R' follow-up command to use in
prefixing each line of the quoted article.
For example, \*(L"\-F<tab>\*(R" inserts a tab on the front of each line
(which will cause long lines to wrap around, unfortunately),
\*(L"\-F>>>>\*(R" inserts \*(L">>>>\*(R" on every line, and
\*(L"\-F\*(R" by itself causes nothing to be inserted, in case you want to
reformat the text, for instance.
The initial default prefix is \*(L">\*(R".
.TP 5
.B \-g<line>
tells
.I trn
which line of the screen you want searched-for strings to show up on when
you search with the \*(L'g\*(R' command within an article.
The lines are numbered starting with 1.
The initial default is \*(L"\-g1\*(R", meaning the first line of the screen.
Setting the line to less than 1 or more than the number of lines on the screen
will set it to the last line of the screen.
.TP 5
.B \-G
selects the "fuzzy" processing on the go command when you don't type in a
valid group name.
With this option on trn will attempt to find the group you probably meant
to type, but it can be a little slow about it, so it's not on by default.
.TP 5
.B \-h<string>
hides (disables the printing of) all header lines beginning with
.IR string .
For instance, \-hx- will disable the printing of all \*(L"X-Foo:\*(R"
headers.
Case is not significant.
The default for unrecognized headers can be set with
the \-hunrecognized option.
Alternately you could use \-h (no string) to disable all headers except the
Subject line and then use
.B +h
to select only those lines you want to see.
You may wish to use the baud-rate switch modifier below to hide more lines
at lower baud rates.
.TP 5
.B \-H<string>
works just like
.B \-h
except that instead of setting the hiding flag for a header line, it sets
the magic flag for that header line.
Certain header lines have magic behavior that can be controlled this way.
At present, the following actions are caused by the flag for the particular
line:
the Date line prints the date in local time if the group is threaded;
the From line will only print the commented portion of the user name;
the Newsgroups line will only print when there are multiple newsgroups;
the Subject line will be underlined and (when threaded) the
keyword \*(L'Subject:\*(R' is replaced by its subject number (e.\|g. [1]);
and the Expires line will always be suppressed if there is nothing on it.
In fact, all of these actions are the default, and you must use
.B +H
to undo them.
.TP 5
.B \-i=<number>
specifies how long (in lines) to consider the initial page of an
article \*(-- normally this is determined automatically depending on baud rate.
(Note that an entire article header will always be printed regardless of the
specified initial page length.
If you are working at low baud rate and wish to reduce the size of the
headers, you may hide certain header lines with the
.B \-h
switch.)
.TP 5
.B \-I
tells trn to append all new, unsubscribed groups to the end of the .newsrc.
.TP 5
.B \-j
forces trn to leave control characters unmolested in messages.
.TP 5
.B \-J{<number>}
causes trn to join similar subjects into a common thread if they are the
same up to the indicated number of characters (the default is 30).
You can turn this on and off for specific groups by putting the following
lines into your kill file for the group(s):
.Sp
&-J30
.br
X&+J
.TP 5
.B \-k
tells trn to ignore the THRU line when processing selection searches
(i.\|e. searches with a command portion that starts with a \*(L'+\*(R'
or a \*(L'.\*(R') in the memorized commands (aka kill files).
This is turned on by default, so use
.B +k
if you want to turn it off.
.TP 5
.B \-K
is used to keep a trn from checking for new news while you're in the group.
Use this when your kill-file processing is so slow that you don't want the
group to expand while you're reading.
If you only want specific groups to be affected, put these lines into
your kill file for the group(s):
.Sp
&-K
.br
X&+K
.TP 5
.B \-l
disables the clearing of the screen at the beginning of each
article, in case you have a bizarre terminal.
.TP 5
.B \-L
tells
.I trn
to leave information on the screen as long as possible by not blanking
the screen between pages, and by using clear to end-of-line.
(The
.IR more (1)
program does this.)
This feature works only if you have the requisite termcap
capabilities.
The switch has no effect unless the
.B \-e
switch is set.
.TP 5
.B \-m=<mode>
enables the marking of the last line of the previous page
printed, to help the user see where to continue reading.
This is most helpful when less than a full page is going to be displayed.
It may also be used in conjunction with the
.B \-e
switch, in which case the page is erased, and the first line (which is
the last line of the previous page) is highlighted.
If
.B \-m=s
is specified, the standout mode will be used, but if
.B \-m=u
is specified, underlining will be used.
If neither
.B =s
or
.B =u
is specified, standout is the default.
Use
.B +m
to disable highlighting.
.TP 5
.B \-M
forces mailbox format in creating new save files.
Ordinarily you are asked which format you want.
.TP 5
.B \-N
forces normal (non-mailbox) format in creating new save files.
Ordinarily you are asked which format you want.
.TP 5
.B \-o
will act like old versions of trn and not junk cross-referenced articles
when using thread commands to junk articles in the current group (such as
the selector's \*(L'X\*(R' command).
.TP 5
.B \-O<mode>{<order>}
specifies the selector's mode and (optionally) the sort order.
The modes are \*(L'a\*(R'rticle, \*(L's\*(R'ubject, or \*(L't\*(R'hread.
The orders are \*(L'd\*(R'ate, \*(L's\*(R'ubject, \*(L'a\*(R'uthor,
article \*(L'c\*(R'ount per group, \*(L'n\*(R'umeric,
or subject-date \*(L'g\*(R'roups.
The order can be capitalized to reverse the indicated order.
For example, to choose the article selector in subject order specify
\*(L"-Oas\*(R".
.TP 5
.B \-p{opt}
tells trn to auto-select your postings and their replies as it encounters them
in the various groups you read.
The optional parameter is either a \*(L'.\*(R', \*(L'p\*(R', or \*(L'+\*(R'
(it defaults to \*(L'.\*(R' if omitted) and affects what command trn should
execute when it encounters your postings.
The default is to execute the command \*(L"T.\*(R" on each of your postings
which tells trn to memorize the auto-selection of this article and all its
replies.
Using \-pp tells trn to use the same command, but start the selection with
the parent article, so that you see any other replies to the same article.
Using \-p+ tells trn to select the whole thread that contains your reply.
.TP 5
.B \-q
bypasses the automatic check for new newsgroups when starting 
.IR trn .
.TP 5
.B \-Q<set>
defines the set of available charset conversions. This can be useful
to restrict the available conversions to those your terminal can handle
and/or to specify an alternate default. The first element of this set
is taken as default for each article.
.TP 5
.B \-r
causes
.I trn
to restart in the last newsgroup read during a previous session with
.IR trn .
It is equivalent to starting up normally and then getting to the newsgroup
with a g command.
.TP 5
.B \-s
with no argument suppresses the initial listing of newsgroups with unread
news, whether
.B \-c
is specified or not.
Thus
.B \-c
and
.B \-s
can be used together to test \*(L"silently\*(R" the status of news from
within your
.I .login
file.
If
.B \-s
is followed by a number, the initial listing is suppressed after that many
lines have been listed.
Presuming that you have your
.I .newsrc
sorted into order of interest,
.B \-s5
will tell you the 5 most interesting newsgroups that have unread news.
This is also a nice feature to use in your
.I .login
file, since it not only tells you whether there is unread news, but also how
important the unread news is, without having to wade through the entire
list of unread newsgroups.
If no 
.B \-s
switch is given 
.B \-s5
is assumed, so just putting \*(L"rn \-c\*(R"
into your
\&.login file is fine.
.TP 5
.B \-S<number>
causes
.I trn
to enter subject search mode (^N) automatically whenever an unthreaded
newsgroup is
started up with <number> unread articles or more.
Additionally, it causes any \*(L'n\*(R' typed while in subject search mode
to be interpreted as \*(L'^N\*(R' instead.
(To get back out of subject search mode, the best command is probably
\&\*(L'^\*(R'.)
If <number> is omitted, 3 is assumed.
.TP 5
.B \-t
puts
.I trn
into terse mode.
This is more cryptic but useful for low baud rates.
(Note that your system administrator may have compiled
.I trn
with either verbose or terse messages only to save memory.)
You may wish to use the baud-rate switch modifier below to enable terse mode
only at lower baud rates.
.TP 5
.B \-T
allows you to type ahead of trn.
Ordinarily trn will eat typeahead to prevent your autorepeating space bar from
doing a very frustrating thing when you accidentally hold it down.
If you don't have a repeating space bar, or you are working at low baud
rate, you can set this switch to prevent this behavior.
You may wish to use the baud-rate switch modifier below to disable typeahead
only at lower baud rates.
.TP 5
.B \-u
sets the unbroken-subject-line mode in the selector, which simply truncates
subjects that are too long instead of dumping the middle portion prior to
the last two words of the subject.
.TP 5
.B \-U
tells trn to not write the .newsrc file out after visiting each group.
While this is \*(L"unsafe\*(R" it can be faster if you have a really
huge .newsrc.
.TP 5
.B \-v
sets verification mode for commands.
When set, the command being executed is displayed to give some feedback that
the key has actually been typed.
Useful when the system is heavily loaded and you give a command that takes
a while to start up.
.TP 5
.B \-V
will output trn's version number and quit.
.TP 5
.B \-x{<number>}{<list>}
Enable the extended (threaded) features of
.I trn
beyond the
.I rn
compatibility mode
(this may be the default on your system, use +x if you yearn for the good
ol' days).
The <number> is the maximum number of article-tree lines (from 0 to 11)
you want displayed in your header.
Use the <list> to choose which thread selector styles you like
(\*(L's\*(R'hort, \*(L'm\*(R'edium, or \*(L'l\*(R'ong), and in what order
they are selected with the \*(L'L\*(R' command.
For example, use
.B \-xms
to start with the medium display mode and only switch between it and
the short mode.
You can omit either or both of the parameters, in which case a default of
.B \-x6lms
is assumed.
.TP 5
.B \-X{<number>}{<commands>}
If you like using the selector, you'll probably want to use this
option to make the selector command (+) the default when a newsgroup
is started up with at least <number> unread articles.
(Your installer may have chosen to make -X0 the default on your system.)
It is also used to select which commands you want to be the defaults while
using the thread selector.
For example,
.B \-X2XD
will make the thread selector the default command for entering a newsgroup
with at least 2 unread articles, and set the default command for the LAST
page of the thread selector to be the
.B X
command and the default command for all other pages to be the
.B D
command.
Either or both parameters can be omitted, as well as the second default
command (e.\|g.
.B \-XX
would change the default newsgroup entry to use the selector and the default
command for the last page of the selector to be \*(L'X\*(R').
The default is
.B \-X0Z>
if just
.B \-X
is specified.
To set the default selector commands without having \*(L'+\*(R' be the
default entry into a newsgroup, specify a high number, like 9999.
.TP 5
.B \-z
sets the minimum number of minutes that must elapse before the active file
is refetched to look for new articles.
A value of 0 or using +z turns this off.
.TP 5
.B \-Z
is used to select what style of database you want trn to access.
Use \-Zt for thread files, \-Zo for overview files, and +Z for none.
The default is whatever your newsadmin compiled into trn, and can
be \-Zot to try to access either one.
.TP 5
.B \-/
sets SAVEDIR to \*(L"%p/%c\*(R" and SAVENAME to \*(L"%a\*(R", which means
that by default articles are saved in a subdirectory of your private news
directory corresponding to the name of the the current newsgroup, with the
filename being the article number.
.B +/
sets SAVEDIR to \*(L"%p\*(R" and SAVENAME to \*(L"%^C\*(R", which by
default saves articles directly to your private news directory, with the
filename being the name of the current newsgroup, first letter capitalized.
(Either
.B +/
or
.B \-/
may be default on your system, depending on the feelings of your news
administrator when he, she or it installed
.IR trn .)
You may, of course, explicitly set SAVEDIR and SAVENAME to other
values \*(-- see discussion in the environment section.
.PP
Any switch may be selectively applied according to the current baud-rate.
Simply prefix the switch with +speed to apply the switch at that speed or
greater, and \%\-speed to apply the switch at that speed or less.
Examples: \%\-1200\-hposted suppresses the Posted line at 1200 baud or less;
\%+9600\-m enables marking at 9600 baud or more.
You can apply the modifier recursively to itself also: \%+300\-1200\-t sets
terse mode from 300 to 1200 baud.
.PP
Similarly, switches may be selected based on terminal type:
.Sp
	\-=vt100+T		set +T on vt100
.br
	\-=tvi920\-ETERM=mytvi	get a special termcap entry
.br
	\-=tvi920\-ERNMACRO=%./.rnmac.tvi
.br
				set up special key-mappings
.br
	+=paper\-v		set verify mode if not hardcopy
.PP
Some switch arguments, such as environment variable values, may require
spaces in them.
Such spaces should be quoted via ", ', or \e in the conventional fashion,
even when passed via TRNINIT or the & command.
.Sh "Regular Expressions"
The patterns used in article searching are regular expressions such as
those used by
.IR ed (1).
In addition, \ew matches an alphanumeric character and \eW a non-alphanumeric.
Word boundaries may be matched by \eb, and non-boundaries by \eB.
The bracketing construct \e(\ ...\ \e) may also be used, and \edigit matches
the digit'th substring, where digit can range from 1 to 9.
\e0 matches whatever the last bracket match matched.
Up to 10 alternatives may given in a pattern, separated by \e|, with the
caveat that \e(\ ...\ \e|\ ...\ \e) is illegal.
.Sh "Character Set Conversions"
.I trn
can use character set conversions when displaying articles. This helps
users in non-English-speaking countries to display special characters
on 7-bit displays.
.I trn
assumes that articles use the ISO-8859-1 character set and converts
the special characters (e.g., \*(L"umlauts\*(R") to a string of ASCII
characters. 
Currently the following conversions are supported (see the 
.I \-Q
option):
.TP 5
.B p
Plain. No change. This is the default.
.TP 5
.B a
ISO->ASCII. Special characters are mapped to ASCII, e.g. the umlaut-o
character becomes oe.
.TP 5
.B m
ISO->ASCII monospaced. Special characters are mapped to exactly one
similar-looking ASCII character, e.g. umlaut-o becomes o. Used where
correct spacing is more important than accuracy.
.TP 5
.B t
TeX->ISO. Assuming your display can handle the ISO-8859-1 charset, 
.I trn
transforms umlauts in the TeX notation, which is commonly used in
Germany, to real ISO characters, e.g. "a becomes umlaut-a.
.PP
The selected conversion, if different from 
.BR p ,
will be displayed in the article level and pager prompt. The
conversion is also used when including original articles in a reply or
followup. It is not used when saving articles to files.
.Sh "Interpretation and Interpolation"
Many of the strings that
.I trn
handles are subject to interpretations of several types.
Under filename expansion, an initial \*(L"~/\*(R" is translated to the name
of your home directory, and \*(L"~name\*(R" is translated to the login
directory for the user specified.
Filename expansion will also expand an initial environment variable, and
also does the backslash, caret and percent expansion mentioned below.
.PP
All interpreted strings go through backslash, caret and percent
interpretation.
The backslash escapes are the normal ones (such as \en, \et, \e033, etc.).
The caret escapes indicate control codes (such as ^i, ^l, etc.).
If you wish to pass through a backslash or a caret it must be escaped with
a backslash.
The special percent escapes are similar to printf percent escapes.
These cause the substitution of various run-time values into the string.
The following are currently recognized:
.Ip %a 8
Current article number.
.Ip %A 8
Full name of current article (%P/%c/%a).
.Ip %b 8
Destination of last save command, often a mailbox.
.Ip %B 8
The byte offset to the beginning of the part of the article to be saved,
set by the save command.
The \*(L's\*(R' and \*(L'S\*(R' commands set it to 0, and the \*(L'w\*(R'
and \*(L'W\*(R' commands set it to the byte offset of the body of the article.
.Ip %c 8
Current newsgroup, directory form.
.Ip %C 8
Current newsgroup, dot form.
.Ip %d 8
Full name of newsgroup directory (%P/%c).
.Ip %D 8
\*(L"Distribution:\*(R" line from the current article.
.Ip %e 8
The last command executed to extract data from an article.
.Ip %E 8
The last directory where an extracted file went.
.Ip %f 8
\*(L"From:\*(R" line from the current article, or the \*(L"Reply-To:\*(R"
line if there is one.
This differs from %t in that comments (such as the full name) are not
stripped out with %f.
.Ip %F 8
\*(L"Newsgroups:\*(R" line for a new article, constructed from
\*(L"Newsgroups:\*(R" and \*(L"Followup-To:\*(R" lines of current article.
.Ip %g 8
The general mode of
.I trn,
for use in conditional macros.
.Sp
.nf
	I	Init mode.
	s	Selector mode.
	r	Rn mode.
	i	Input mode (newline terminated).
	p	Prompt mode (single-character input).
	c	Choice mode (multi-choice input).
.fi
.Ip %h 8
Name of the header file to pass to the mail or news poster,
containing all the information that the poster program needs in the
form of a message header.
It may also contain a copy of the current article.
The format of the header file is controlled by the MAILHEADER and NEWSHEADER
environment variables.
.Ip %H 8
Host name (your machine's name).
.Ip %i 8
\*(L"Message-I.D.:\*(R" line from the current article, with <> guaranteed.
.Ip %I 8
The reference indication mark for citing prior articles (see the
.B \-F
switch.)
.Ip %l 8
The news administrator's login name, if any.
.Ip %L 8
Login name (yours).
.Ip %m 8
The current mode of
.I trn,
for use in conditional macros.
.Sp
.nf
	i	Initializing.
	n	Newsgroup-list level.
	f	End (finis) of newsgroup-list level.
	t	The thread/subject/article selector.
	c	Newsrc selector.
	w	Newsgroup selector.
	j	Addgroup selector.
	l	Option selector.
	a	Article level ("What next?").
	e	End of the article level.
	p	Pager level ("MORE" prompt).
	u	Unkill prompt.
	d	Selector mode prompt.
	o	Selector order prompt.
	m	Memorize thread command prompt.
	r	Memorize subject command prompt.
	z	Option edit prompt.
	k	Processing memorized (KILL-file) commands.
	A	Add this newsgroup?
	B	Abandon confirmation.
	C	Catchup confirmation.
	D	Delete bogus newsgroups?
	F	Is follow-up a new topic?
	M	Use mailbox format?
	R	Resubscribe to this newsgroup?
	K	Press any key prompt.
.fi
.Sp
Note that yes/no questions are all upper-case modes.
If, for example, you wanted to disallow defaults on all yes/no questions,
you could define the following macro:
.Sp
.nf
\e040	%(%m=[A-Z]?h: )
.fi
.Ip %M 8
The number of articles marked to return via the \*(L'M\*(R' command.
If the same article is Marked multiple times, \*(L"%M\*(R" counts it
multiple times in the current implementation.
.Ip %n 8
\*(L"Newsgroups:\*(R" line from the current article.
.Ip %N 8
Full name (yours).
.Ip %o 8
Organization (yours).
.Ip %O 8
Original working directory (where you ran trn from).
.Ip %p 8
Your private news directory, normally ~/News.
.Ip %P 8
Public news spool directory, normally /usr/spool/news on systems that don't use NNTP.
.Ip %q 8
The value of the last \*(L"quoted\*(R" input string (see the %" interp).
.Ip %r 8
Last reference on references line of current article (parent article id).
.Ip %R 8
References list for a new article, constructed from the references and article
ID of the current article.
.Ip %s 8
Subject, with all Re's and (nf)'s stripped off.
.Ip %S 8
Subject, with one \*(L"Re:\*(R" stripped off.
.Ip %t 8
\*(L"To:\*(R" line derived from the \*(L"From:\*(R" and \*(L"Reply-To:\*(R"
lines of the current article.
This always returns an Internet format address.
.Ip %T 8
\*(L"To:\*(R" line derived from the \*(L"Path:\*(R" line of the
current article to produce a uucp path.
.Ip %u 8
The number of unread articles in the current newsgroup.
.Ip %U 8
The number of unread articles in the current newsgroup, not counting the
the current article.
When threads are selected, this count reflects only selected articles.
.Ip %v 8
The number of unselected articles, not counting the current article
if it is unselected.
.Ip %w 8
The directory where mthreads keeps its tmp files.
.Ip %W 8
The directory where thread files are placed.
.Ip %x 8
The news library directory.
.Ip %X 8
The trn library directory.
.Ip %z 8
The length of the current article in bytes.
.Ip %Z 8
The number of selected threads.
.Ip %~ 8
Your home directory.
.Ip %. 8
The directory containing your dot files, which is your home directory unless
the environment variable DOTDIR is defined when trn is invoked.
.Ip %# 8
The current count for a multi-file save, starting with 1.
This value is incremented by one for each file saved or extracted within a
single command.
.Ip %$ 8
Current process number.
.Ip %/ 8
Last search string.
.Ip %? 8
A space unless the current interp string is > 79 characters, at which point
it turns into a newline.
.Ip %% 8
A percent sign.
.Ip "%{name} or %{name\-default}" 8
The environment variable \*(L"name\*(R".
.Ip %[name] 8
The value of header line \*(L"Name:\*(R" from the current article.
The \*(L"Name:\ \*(R" is not included.
For example \*(L"%D\*(R" and \*(L"%[distribution]\*(R" are equivalent.
The name must be spelled out in full.
.Ip %`command` 8
Inserts the output of the command, with any embedded newlines translated
to space.
.Ip %""prompt"" 8
Prints prompt on the terminal, then inputs one string, and inserts it.
.Ip "%(test_text=pattern?then_text:else_text)" 8
If
.I test_text
matches
.IR pattern ,
has the value
.IR then_text ,
otherwise
.IR else_text .
The \*(L":else_text\*(R" is optional, and if absent, interpolates the null string.
The = may be replaced with != to negate the test.
To quote any of the meta-characters
(\*(L'=\*(R', \*(L'?\*(R', \*(L':\*(R', or \*(L')\*(R'),
precede with a backslash.
.Ip %digit 8
The digits 1 through 9 interpolate the string matched by the nth bracket
in the last pattern match that had brackets.
If the last pattern had alternatives, you may not know the number of the
bracket you want \*(-- %0 will give you the last bracket matched.
.PP
Modifiers: to capitalize the first letter, insert \*(L'^\*(R':
\*(L"%^C\*(R" produces something like \*(L"Rec.humor\*(R".
Inserting \*(L'_\*(R' causes the first letter following the last
\&\*(L'/\*(R' to be capitalized: \*(L"%_c\*(R" produces \*(L"rec/Humor\*(R".
.PP
Inserting \*(L'\\\*(R' will insert a backslash before any characters that
would be magic in a regular expression, including \*(L'%\*(R':
\*(L"%\\C\*(R" produces \*(L"rec\\.humor\*(R".
.PP
Inserting \*(L"'\*(R" will insert a backslash before any single-quotes in
the result, suitable for enclosing in single-quotes and sending to a shell:
\*(L"'%'s'\*(R" might produce \*(L"'I'\\''m a subject'\*(R".
.PP
Inserting \*(L"''\*(R" will insert a backslash before any double-quotes in
the result, suitable for enclosing in double-quotes and sending to a shell.
.PP
Inserting \*(L">\*(R" will strip out just the address portion
of an address string such as the From line.
.PP
Inserting \*(L")\*(R" will strip out just the comment (real name) portion
of an address string such as the From line.
.PP
Inserting \*(L":FMT\*(R" will format the result according to the printf-style
FMT string: \*(L"%:-50.50s\*(R" left-justifies the subject into a 50
character field.
.SH ENVIRONMENT
The following environment variables are paid attention to by
.IR trn .
In general the default values assumed for these variables by
.I trn
are reasonable, so if you are using
.I trn
for the first time, you can safely ignore this section.
Note that the defaults below may not correspond precisely to the defaults
on your system.
To find the actual defaults you would need to look in config.h and common.h
in the trn source directory, and the file INIT in the trn library directory.
.PP
Those variables marked (%) are subject to % interpolation, and those marked
(~) are subject to both % interpolation and ~ interpretation.
.Ip "ATTRIBUTION (%)" 8
Gives the format of the attribution line in front of the quoted article
included by an F command.
.Sp
Default: In article %i,%?%)f <%>f> wrote:
.Ip "AUTOSUBSCRIBE" 8
When
.I trn
is checking for new newsgroups and finds one
matching one of the patterns in AUTOSUBSCRIBE, the new group is
automatically added to the end of the .newsrc, subscribed.
Newsgroups not matching this or AUTOUNSUBSCRIBE, below, are offered
to the user.
.Sp
AUTOSUBSCRIBE is a comma separated list of newsgroup patterns ala
\&\*(L'o\*(R', \*(L'/\*(R', etc.
It can also include \*(L"but not\*(R" entries preceded by \*(L'!\*(R'.
\*(L"a,b,!c,d\*(R" is read as \*(L"matching a or b, unless it also
matches c; matching d regardless\*(R".
Another way to look at it is \*(L"(((a or b) and not c) or d)\*(R".
To automatically subscribe to all local
groups but be choosy about non-local groups, one might say \*(L"*,!*.*\*(R".
.Sp
Default: (none)
.Ip "AUTOUNSUBSCRIBE" 8
AUTOUNSUBSCRIBE is very similar to AUTOSUBSCRIBE, above, but
new newsgroups matching it are automatically added to the end
of the .newsrc file, unsubscribed.
If a newsgroup matches AUTOSUBSCRIBE, AUTOUNSUBSCRIBE is not consulted.
.Sp
Default: (none)
.Ip "CANCEL (~)" 8
The shell command used to cancel an article.
.Sp
Default: inews \-h < %h
.Ip "CANCELHEADER (%)" 8 13v
The format of the file to pass to the CANCEL command in order to cancel
an article.
.Sp
Default:
.br
Newsgroups: %n
.br
Subject: cmsg cancel %i
.br
References: %R
.br
Reply-To: %L@%H (%N)
.br
Distribution: %D
.br
Organization: %o
.sp 1
%i cancelled from trn.
.Ip DOTDIR 8
Where to find your dot files, if they aren't in your home directory.
Can be interpolated using \*(L"%.\*(R".
.Sp
Default: $HOME
.Ip "EDITOR (~)" 8
The name of your editor, if VISUAL is undefined.
.Sp
Default: whatever your news administrator compiled in, usually vi.
.Ip "EXSAVER (%)" 8
The shell command to execute in order to extract data to either /bin/sh
or a user-specified command.
.Sp
Default: tail +%Bc %A | %e
.Ip "FIRSTLINE (%)" 8
Controls the format of the line displayed at the top of an article.
Warning: this may go away.
.Sp
The default (ignoring the Marked to return display in unthreaded
groups) is approximately:
.Sp
%C #%a%(%Z=^0$?%(%U!=^0$? (%U more\e)): (%U + %v more\e))
.Ip "FORWARDHEADER (%)" 8
The format of the header file for forwarding messages.
See also FORWARDPOSTER.
.Sp
Default:
.Sp
To: 
.br
Subject: %(%i=^$?:[subject] (fwd\e\e)
.br
%(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
.br
)Newsgroups: %n
.br
In-Reply-To: %i)
.br
%(%[references]=^$?:References: %[references]
.br
)Organization: %o
.br
Cc: 
.br
Bcc: \en\en
.Ip "FORWARDPOSTER (~)" 8
The shell command to be used by the forward command (^F)
in order to allow you to edit and deliver the file.
.I trn
will not itself call upon an editor for replies \*(-- this
is a function of the program referenced by FORWARDPOSTER.
See also FORWARDHEADER and MAILPOSTER.
.Sp
Default: Rnmail \-h %h
.Ip HIDELINE 8
If defined, contains a regular expression which matches article lines to
be hidden, in order, for instance, to suppress quoted material.
A recommended string for this purpose is \*(L"^>...\*(R", which \fIdoesn't\fR
hide lines with only \*(L'>\*(R', to give some indication that quoted
material is being skipped.
If you want to hide more than one pattern, you can use \*(L"\||\|\*(R" to
separate the alternatives.
You can view the hidden lines by restarting the article with the \*(L'v\*(R'
command.
.Sp
There is some overhead involved in matching each line of the article against
a regular expression.
You might wish to use a baud-rate modifier to enable this feature only at
low baud rates.
.Sp
Default: undefined
.Ip HOME 8
Your home directory.
Affects ~ interpretation, and the location of your
dot files if DOTDIR is not defined.
.Sp
Default: $LOGDIR
.Ip "KILLGLOBAL (~)" 8
Where to find the KILL file to apply to every newsgroup.
See the \*(L'^K\*(R' command at the newsgroup-selection level.
.Sp
Default: %p/KILL
.Ip "KILLLOCAL (~)" 8
Where to find the KILL file for the current newsgroup.
See the commands \*(L'K\*(R' and \*(L'^K\*(R' at the article selection level,
and the search modifier \*(L'K\*(R'.
.Sp
Default: %p/%c/KILL
.Ip LOGDIR 8
Your home directory if HOME is undefined.
Affects ~ interpretation, and the location of your
dot files if DOTDIR is not defined.
.Sp
Default: none.
.Sp
Explanation: you must have either $HOME or $LOGDIR.
.Ip LOGNAME 8
Your login name, if USER is undefined.
May be interpolated using \*(L"%L\*(R".
.Sp
Default: value of getlogin().
.Ip LOCALTIMEFMT 8
The format used by strftime() to print the local time.
The Date line is only displayed in local time if the group is threaded
(see the \-H option for more information on Date).
.Sp
Default: %a %b %e %X %Z %Y
.Sp
which is the same format as the
.IR date (1)
command.
.Ip "MAILCALL (~)" 8
What to say when there is new mail.
.Sp
Default: (Mail)
.Ip "MAILFILE (~)" 8
Where to check for mail.
.Sp
Default: /usr/spool/mail/%L
.Ip "MAILHEADER (%)" 8
The format of the header file for replies.
See also MAILPOSTER.
.Sp
Default:
.Sp
To: %t
.br
Subject: %(%i=^$?:Re: %S
.br
%(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
.br
)Newsgroups: %n
.br
In-Reply-To: %i)
.br
%(%[references]=^$?:References: %[references]
.br
)Organization: %o
.br
Cc: 
.br
Bcc: \en\en
.Ip "MAILPOSTER (~)" 8
The shell command to be used by the reply commands (r and R)
in order to allow you to enter and deliver the response.
.I trn
will not itself call upon an editor for replies \*(-- this
is a function of the program referenced by MAILPOSTER.
See also MAILHEADER.
.Sp
Default: Rnmail \-h %h
.Ip "MBOXSAVER (~)" 8
The shell command to save an article in mailbox format.
.Sp
Default: %X/mbox.saver %A %P %c %a %B %C "%b" \e
.br
"From %t %`date`"
.Sp
Explanation: the first seven arguments are the same as for NORMSAVER.
The eighth argument to the shell script is the new From line
for the article, including the posting date,
derived either directly from the Posted: line, or not-so-directly from
the Date: line.
Header munging at its finest.
.Ip MODSTRING 8
The string to insert in the group summary line, which heads each article,
for a moderated group.
See also NOPOSTRING.
.Sp
Default: " (moderated)"
.Ip NAME 8
Your full name.
May be interpolated using \*(L"%N\*(R".
.Sp
Default: name from /etc/passwd, or ~/.fullname.
.Ip "NEWSHEADER (%)" 8 16v
The format of the header file for follow-ups.
See also NEWSPOSTER.
.Sp
Default:
.Sp
%(%[followup-to]=^$?:%(%[followup-to]=^%n$?:X-ORIGINAL-NEWSGROUPS: %n
.br
))Newsgroups: %(%F=^$?%C:%F)
.br
Subject: %(%S=^$?%"\en\enSubject: ":Re: %S)
.br
Summary:
.br
Expires: 
.br
%(%R=^$?:References: %R
.br
)Sender: 
.br
Followup-To: 
.br
%(%{REPLYTO}=^$?:Reply-To: %{REPLYTO}
.br
)Distribution: %(%i=^$?%"Distribution: ":%D)
.br
Organization: %o
.br
Keywords: %[keywords]
.br
Cc: \en\en
.Ip NEWSORG 8
Either the name of your organization, or the name of a file containing the
name of your organization.
(For use at sites where the ORGANIZATION environmental variable is already
in use.
NEWSORG will override ORGANIZATION if both are present.)
May be interpolated using \*(L"%o\*(R".
.Sp
Default: whatever your news administrator compiled in.
.Ip "NEWSPOSTER (~)" 8
The shell command to be used by the follow-up commands (f and F)
in order to allow you to enter and post a follow-up news article.
If not set,
.I trn
handles the whole process and calls inews directly.
See also NEWSHEADER.
.Ip NNTPSERVER 8
The hostname of your NNTPSERVER.
[This does not apply unless you are running the NNTP version of trn.]
.Sp
Default: the hostname listed in the server file, usually
/usr/local/lib/rn/server.
.Ip NOPOSTRING 8
The string to insert in the group summary line, which heads each article,
for a group to which local posting is not allowed.
See also MODSTRING.
.Sp
Default: " (no posting)"
.Ip "NORMSAVER (~)" 8
The shell command to save an article in the normal (non-mailbox) format.
.Sp
Default: %X/norm.saver %A %P %c %a %B %C "%b"
.Ip ORGANIZATION 8
Either the name of your organization, or the name of a file containing the
name of your organization.
(If NEWSORG is set, it will override ORGANIZATION.)
May be interpolated using \*(L"%o\*(R".
.Sp
Default: whatever your news administrator compiled in.
.Ip PAGESTOP 8
If defined, contains a regular expression which matches article lines to
be treated as form-feeds.
There are at least two things you might want to do with this.
To cause page breaks between articles in a digest, you might define it
as \*(L"^--------\*(R".
To force a page break before a signature, you could define it
as \*(L"^-- $\*(R".
(Then, when you see \*(L"--\*(R" at the bottom of the page, you can skip
the signature if you so desire by typing \*(L'n\*(R' instead of space.)
To do both, you could use \*(L"^--\*(R".
If you want to break on more than one pattern, you can use \*(L"\||\|\*(R" to
separate the alternatives.
.Sp
There is some overhead involved in matching each line of the article against
a regular expression.
You might wish to use a baud-rate modifier to enable this feature only at
low baud rates.
.Sp
Default: undefined
.Ip "PIPESAVER (%)" 8
The shell command to execute in order to accomplish a save to a pipe
(\*(L"s\ |\ command\*(R" or \*(L"w\ |\ command\*(R").
The command typed by the user is substituted in as %b.
.Sp
Default: %(%B=^0$?<%A:tail +%Bc %A |) %b
.Sp
Explanation: if %B is 0, the command is \*(L"<%A %b\*(R", otherwise
the command is \*(L"tail +%Bc %A | %b\*(R".
.Ip REPLYTO 8
The value of the \*(L"Reply-To:\*(R" header, if needed.
.Sp Default: \*(L" \*(R".
.Ip RNINIT 8
This variable is used when initializing trn in rn-compatibility mode
(see the \-x switch) or when the TRNINIT variable isn't defined.
See the TRNINIT variable for a description.
.Ip "RNMACRO (~)" 8
The name of the file containing macros and key mappings when running trn
as rn.
See also the TRNMACRO variable and the CUSTOM MACROS section.
.Sp
Default: %./.rnmac
.Ip "SAVEDIR (~)" 8
The name of the directory to save to, if the save command does not specify
a directory name.
.Sp
Default:
.br
   If
.B \-/
is set: %p/%c
.br
   If
.B +/
is set: %p
.Ip "SAVENAME (%)" 8
The name of the file to save to, if the save command contains only a
directory name.
.Sp
Default:
.br
   If
.B \-/
is set: %a
.br
   If
.B +/
is set: %^C
.Ip "SELECTCHARS" 8
The characters used by the thread selector to select the associated thread
of discussion.
You can specify up to 64 visible characters, including upper- and lower-case
letters, numbers, and many punctuation characters.
Selection characters override command characters in the selector, but are
not excluded from macro expansion, so be careful.
.br
Default: abdefgijlorstuvwxyz1234567890BCFGHIKMVW
.br
(You'll notice various characters are omitted to allow them to be typed
as commands in the selector.)
.Ip SHELL 8
The name of your preferred shell.
It will be used by the \*(L'!\*(R', \*(L'S\*(R' and \*(L'W\*(R' commands.
.Sp
Default: whatever your news administrator compiled in.
.Ip "SUBJLINE (%)" 8
Controls the format of the lines displayed by the \*(L'=\*(R' command at
the article selection level.
.Sp
Default: %s
.Ip "SUPERSEDEHEADER (%)" 8 16v
The format of the header file for a supersede article.
.Sp
Default:
.Sp
From: %L@%H (%N)
.br
Newsgroups: %n
.br
Subject: %S
.br
Distribution: %D
.br
Organization: %o
.br
Supersedes: %i
.Ip TERM 8
Determines which termcap entry to use, unless TERMCAP contains the entry.
.Ip TERMCAP 8
Holds either the name of your termcap file, or a termcap entry.
.Sp
Default: /etc/termcap, normally.
.Ip TRNINIT 8
Default values for switches may be passed to
.I trn
by placing them in the TRNINIT variable (or RNINIT if you're starting
trn in rn-compatibility mode).
Any switch that is set in this way may be overruled 
on the command line, or via the \*(L'&\*(R' command from within
.IR trn .
Binary-valued switches that are set with \*(L"\-switch\*(R" may be unset
using \*(L"+switch\*(R".
.Sp
If TRNINIT begins with a \*(L'/\*(R' it is assumed to be the name of a file
containing switches.
You can put comments in this file by preceding them with a \*(L'#\*(R'
as long as this is the first character on a line or it follows some
white-space (which delimits the switches in the file).
If you want to set many environment variables but don't want to keep
them all in your environment, or if the use of any of these variables
conflicts with other programs, you can use this feature along with the
.B \-E
switch to set the environment variables upon startup.
.Sp
Default: \*(L" \*(R".
.Ip "TRNMACRO (~)" 8
The name of the file containing macros and key mappings.
If the file is not found, the RNMACRO variable is used to look for your
rn macros.
For information on what to put into this file, see the CUSTOM MACROS section.
.Sp
Default: %./.trn/macros
.Ip "UNSHAR (~)" 8
The shell command to execute in order to accomplish the unshar'ing of a
shell archive.
.Sp
Default: /bin/sh
.Ip USER 8
Your login name.
May be interpolated using \*(L"%L\*(R".
.Sp
Default: $LOGNAME
.Ip "VISUAL (~)" 8
The name of your editor.
.Sp
Default: $EDITOR
.Ip XTERMMOUSE 8
If you set this variable to \*(L'y\*(R' (yes), trn will enable the use of the
xterm mouse in the selector if you are using an xterm.
Once enabled left-clicking on an item selects it while middle-clicking an
item will move to that item.
If you click the top (header) line of the selector it moves up a page.
If you click the bottom (footer) line of the selector it executes the
default command for the page (left click) or goes down a page (middle
click).
You can also use the right mouse button to move up or down a page by
clicking in the upper-half or lower-half of the screen, respectively.
.Ip "YOUSAID (%)" 8
Gives the format of the attribution line in front of the quoted article
included by an R command.
.Sp
Default: In article %i you write:
.SH "AUTOMATIC MACROS"
On startup
.I trn
attempts to build a set of macros that map your keypad arrow keys to
useful functions.
These default actions are mentioned in the prior description of each level's
commands.
If you don't like this (or trn gets it wrong), you can disable the automatic
macros by using the
.B \-A
option.
.SH "CUSTOM MACROS"
When
.I trn
starts up it looks for a file containing macro definitions (see environment
variables TRNMACRO and RNMACRO).
Any sequence of commands may be bound to any sequence of keys, so you
could re-map your entire keyboard if you desire.
Blank lines or lines beginning with # in the macro file are considered
comments; otherwise
.I trn
looks for two fields separated by white space.
The first field gives the sequence of keystrokes that trigger the macro,
and the second field gives the sequence of commands to execute.
Both fields are subject to % interpolation, which will also translate
backslash and caret sequences.
(The keystroke field is interpreted at startup time, but the command field
is interpreted at macro execution time so that you may refer to % values
in a macro.)
For example, if you want to reverse the roles of carriage return and
space in
.I trn
.Sp
^J	\e040
.br
^M	\e040
.br
\e040	^J
.Sp
will do just that.
By default, all characters in the command field are interpreted as the
canonical
.I trn
characters, i.\|e. no macro expansion is done.
Otherwise the above pair of macros would cause an infinite loop.
To force macro expansion in the command field, enclose the
macro call with ^( ... ^) thusly:
.Sp
@s	|mysavescript
.br
@w	w^(@s^)
.Sp
You can use the %() conditional construct to construct macros that work
differently under different circumstances.
In particular, the current mode (%m) of
.I trn
could be used to make a command that only works at a particular level.
This is particularly vital for the selector which uses most of
the lower-case letters to select the associated item in its display.
For example,
.Sp
a	%(%m=t?a:s art.hold\en)
.Sp
will return the original letter (a) in the selector, and the command
\*(L"s art.hold\en\*(R" everywhere else.
.Sp
%(%{TERM}=vt100?^[[O)	/^J
.Sp
will do the binding only if the terminal type is vt100,
though if you have many of these it would be better to have separate
files for each terminal.
.Sp
If you want to bind a macro to a function key that puts a common garbage character
after the sequence (such as the carriage return on the end of Televideo 920
function sequences), DO NOT put the carriage return
into all the sequences or you will waste a CONSIDERABLE amount of internal
storage.
Instead of \*(L"^AF^M\*(R", put \*(L"^AF+1\*(R", which indicates to
.I trn
that it should gobble up one character after the F.
.SH "WHAT'S NEW"
Here's a quick run-down of
.IR trn 's
features and commands aimed at the knowledgeable
.I rn
or
.I trn
user.
.PP
The addition of true reference-line threading is one of the biggest
improvements over rn.
This threading allows you to read a discussion in reply order with
an article's replies being attached to the article that inspired them.
Threads will encompass multiple subjects whenever a reply to an article
in the thread arrives with a different subject.
This is usually done to better indicate the topic in the reply
when it diverges from the original subject.
.PP
Another big improvement is the selector, which is bound
to the \*(L'+\*(R' key.
The selector displays a list of threads, subjects, or individual articles
to allow you to select the topics that interest you by typing their
associated letter.
The difference between the thread and the subject selector is that the
subject selector displays all subjects with a separate selection letter,
even those tied together via their references.
This can be quite useful if you select some threads and desire to weed
out some extraneous discussions: you could switch the selector into
exclusive mode (\*(L'E\*(R' shows only selected threads) and then into
subject mode (\*(L'Ss\*(R') to separate the threads into their component
subjects and deselect or kill the subjects you don't care about.
You don't have to go to all this trouble using the selector if you prefer
to just hit the \*(L'k\*(R' key when you start reading a subject you're not
interested in.
The selector can also switch between showing unread articles and
articles that have already been read, allowing you to selectively re-read
discussions (this is the \*(L'U\*(R' command in the selector).
.PP
Another threaded addition is the article-tree display in the
upper-right corner of the header.
Looking at the tree gives you a feel for how the articles you are
reading relate to each other, allowing you to see at a glance when
there are lots of replies and decide if you want to junk an uninteresting
set of replies or perhaps tough it out.
.PP
The header display has also been modified to hide a few more lines by default
(e.\|g. References), but, as always, you can override these with \-h.
There is also some more \*(L"magic\*(R" in the header: the From header can
be trimmed to be just the comment portion (if available), and the Date
header is displayed in local time (by default).
Use \-H and +H to turn header magic on and off.
.PP
Once you begin reading articles, use the regular movement commands (n, N,
p, P, etc.) as you normally would.
You'll find that these commands track the reply order shown in the tree
display.
Then try using ^N and ^P, which follow a subject in the order the articles
were posted.
Finally, check out the [, ], (, ), {, and } commands to move around in the
article tree a bit more directly.
The first four commands should also be bound to your keypad's arrow keys,
making them easier to type.
For example, typing \*(L'[\*(R' (left) takes you to your parent article,
even if it was already read, which is very useful for tracking down the
cited portion of the article in its original context.
.PP
There are additional kill commands for the entire thread (J) and the
current article and all its replies (,).
.PP
The KILL files have been extended and the commands inside them are now
referred to memorized commands, since they are often used for selection
rather than killing of articles.
There are new, easier ways to add memorized commands using the \*(L'A\*(R'dd
and \*(L'T\*(R'hread commands.
The \*(L'A\*(R' command is subject-oriented, while the \*(L'T\*(R' command
is article-oriented (meaning they affect a specific set of articles rather
than any article that happens to have a matching subject).
They both prompt you for what kind of command you want to add,
making both auto-killing and auto-selecting just as easy.
.PP
There is also an easy way to skip around among the various threads with
the < and > commands.
Use them if you want to skip a set of article and read them later instead
of junking them.
.PP
Note: your news administrator has the option of turning thread processing
off for individual groups, and thus it is possible for some groups to not
have any pre-processed thread information available for use.
When
.I trn
encounters such a group, it generates the thread information on the fly
while entering the group.
For really large groups (or really slow systems), this can take an
appreciable amount of time.
If you can't talk your news administrator into pre-threading the group,
you can turn off the threading on a group-by-group basis using
the \*(L't\*(R' command at the newsgroup-selection level.
Groups turned off in this way are read in the
.I rn
style \*(-- articles arranged in arrival order unless you specify the
\-S option, which reads the articles in date order by subject.
.PP
Take note of the \*(L"e dir\*(R" command, which is used to extract a shell
archive or uuencoded file into the specified directory.
It is even possible to extract other data formats if you specify the
appropriate filter command (e.\|g. \*(L"e dir|cmd\*(R".
.PP
Also, if you plan to use macro definitions, it is good to keep in mind
that the selector uses most of the lower-case letters for
selection, and thus it is a good idea to explicitly set the mode(s) in
which a macro applies.
For example, if you want to press \*(L'f\*(R' from the article pager/selector
to forward the current article to the user \*(L"smith\*(R", you could define:
.Sp
.nf
	f	%(%m=[pa]?|mail smith\en:f)
.fi
.Sp
This checks the current mode (%m) and if it is \*(L'p\*(R' or \*(L'a\*(R'
it expands it to the string \*(L"|mail smith\en\*(R", otherwise it returns
the letter \*(L'f\*(R'.
In some cases, you may simply wish to exclude the selector from a
macro with the conditional \*(L"%m!=t\*(R".
.PP
Finally, you'll probably want to use the new options,
.B \-x
and
.B \-X
to ensure that all the newest features are available for use.
These options might be on by default, depending on how your administrator
decided to install
.IR trn .
.SH AUTHORS
Rn was created by Larry Wall <lwall@jpl-devvax.jpl.nasa.gov>
.br
and is now under the direction of Stan Barber <sob@bcm.tmc.edu>.
.br
Threaded version by Wayne Davison <wayne@clari.net>
.br
(Mail all bug reports for trn to Wayne.)
.br
Regular expression routines are borrowed from emacs, by James Gosling.
.br
Hashing routines are modified versions from Geoffrey Collyer.
.SH FILES
.Ip "%./.newsrc" 1.25i
status of your news reading
.Ip "%./.oldnewsrc" 1.25i
backup copy of your
.I .newsrc
from start of session
.Ip "%./.rnlock" 1.25i
lock file so you don't screw up your
.I .newsrc
.Ip "%./.rnlast" 1.25i
info from last run of trn
.Ip "%./.rnsoft" 1.25i
soft pointers into /usr/lib/news/active to speed startup, synchronous with
.I .newsrc
.Ip "%./.rnhead" 1.25i
temporary header file to pass to a mailer or news poster
.Ip "%./.[t]rnmac" 1.25i
macro and keymap definitions
.Ip "%p" 1.25i
your news save directory, usually ~/News
.Ip "%x/active" 1.25i
the list of active newsgroups, usually /usr/lib/news/active on systems that don't use NNTP
.Ip "%P" 1.25i
the public news spool directory, usually /usr/spool/news on systems that don't use NNTP
.Ip "%X/INIT" 1.25i
system-wide default switches
.SH SEE ALSO
newsrc(5), more(1), readnews(1), Pnews(1), Rnmail(1)
.SH DIAGNOSTICS
Generally self-documenting, as they say.
.SH BUGS
The
.B \-h
switch can only hide header lines that
.I trn
knows about.
.PP
The \*(L'\-\*(R' command doesn't cross newsgroup boundaries, and only undoes
the last article selection.
.PP
If you edit your
.I .newsrc
while
.I trn
is running,
.I trn
will happily wipe out your changes when it decides to
write out the
.I .newsrc
file.
.PP
Marking of duplicate articles as read in cross-referenced newsgroups will
not work unless the Xref patch is installed in inews.
.PP
If you get carried away with % or escape substitutions, you can overflow
buffers.
