#ifndef ROBIN_HOOD_SERVER_H
#define ROBIN_HOOD_SERVER_H

#include "HTTPFileServer.h"

class RHServer : public HTTPFileServer
{
	public:
		RHServer( FieldList *virtualHosts, const char *defaultFileName = "index.html" );
		virtual ~RHServer( void );
		
		virtual HTTPHandler *NewCopy( void );
		
		virtual bool MessageReceived( HTTPRequest *request );
		
	protected:
		virtual bool HandleGet( void );
		virtual bool HandlePost( void );
		virtual bool InvokeCGI( void );
		
		status_t FindWebDirectory( void );
		
		virtual void ConnectionOpened( const char *remote_addr );
		virtual void ConnectionClosed( status_t status );
	
	protected:
		FieldList 			*virtualHosts;
		int32				sn; // Serial Number
		bigtime_t			startTime;
		int32 				contentLength;
};

#endif
