// Robin Hood Web Server - A web server for BeOS
// Copyright (C) 1999 Joe Kloss

// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License 
// as published by the Free Software Foundation; either version 2 
// of the License, or (at your option) any later version. 

// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
// GNU General Public License for more details. 

// You should have received a copy of the GNU General Public License 
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Contact Info:
// Author: Joe Kloss
// E-mail: axly@deltanet.com
// Postal Address: 25002 Ravenswood, Lake Forest, CA 92630, USA

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <NodeInfo.h>
#include "RHSSI.h"
#include "RHCGI.h"
#include "DataIOUtils.h"
#include "StringUtils.h"
#include "HTTPMessage.h"
#include "HTTPUtils.h"
#include "DataIOPump.h"
#include "RHLogger.h"

status_t invoke_ssi( BDataIO *input, BDataIO *output, BPath *virtualPath, BPath *CWD, int32 sn )
{
	BPath		previousCWD;
	status_t	status = B_NO_ERROR;
	
	char		lineBuffer[4096];
	char		command[64];
	char		tag[1024];
	char		tagName[64];
	char		tagValueQ[1024];
	char		tagValue[1024];
	
	const char	*sPtr, *ePtr, *tPtr;
	
	// Save Current Working Directory
	previousCWD.SetTo( getcwd( lineBuffer, 4096 ) );
	
	// Set Current Working Directory
	chdir( CWD->Path() );
	
	// Read lines until eof
	while( io_getline( input, lineBuffer, 4096 ) )
	{
		// Look for ssi command in line
		if( (sPtr = strstr( lineBuffer, "<!--#" )) )
		{
			sPtr += 5; // Move to command
			if( (ePtr = strstr( sPtr, "-->" )) )
				*((char *)ePtr) = 0; // Terminate string
			sPtr = get_next_token( command, sPtr, 64 );
			if( strcasecmp( command, "config" ) == 0 )
			{
				// Read tags
				while( *sPtr && (sPtr = get_next_token( tag, sPtr, 1024, " ", "\"" )) )
				{
					
				}
			}
			else if( strcasecmp( command, "include" ) == 0 )
			{
				// Read tags
				while( *sPtr && (sPtr = get_next_token( tag, sPtr, 1024, " ", "\"" )) )
				{
					BPath		includePath;
					
					// Break tag into name and value
					tPtr = tag;
					if( *tPtr && (tPtr = get_next_token( tagName, tPtr, 64, "=" ))
						&& *tPtr && (tPtr = get_next_token( tagValueQ, tPtr, 1024, "=" )) )
					{
						// remove any quotes around tag
						get_next_token( tagValue, tagValueQ, 1024, "\"" );
						if( strcasecmp( tagName, "virtual" ) == 0 )
							includePath.SetTo( virtualPath->Path(), tagValue+1 );
						else if( strcasecmp( tagName, "file" ) == 0 )
							includePath.SetTo( tagValue );
						else
							break;
						BFile		includeFile;
						
						if( includeFile.SetTo( includePath.Path(), B_READ_ONLY ) == B_NO_ERROR )
						{
							BNodeInfo	theNode( &includeFile );
							char		mimeType[1024];
							
							theNode.GetType( mimeType );
							// Should we invoke SSI recursively?
							if( strcmp( mimeType, "text/x-server-parsed-html" ) == 0 )
							{
								BPath		NWD( includePath );
								NWD.GetParent( &NWD );
								invoke_ssi( &includeFile, output, virtualPath, &NWD, sn );
							}
							else // Append file
							{
								DataIOPump		ioPump;
								ioPump.StartPump( &includeFile, output );
							}
						}
					}
				}
			}
			else if( strcasecmp( command, "exec" ) == 0 )
			{
				// Read tags
				while( *sPtr && (sPtr = get_next_token( tag, sPtr, 1024, " ", "\"" )) )
				{
					// Break tag into name and value
					tPtr = tag;
					if( *tPtr && (tPtr = get_next_token( tagName, tPtr, 64, "=" ))
						&& *tPtr && (tPtr = get_next_token( tagValueQ, tPtr, 1024, "=" )) )
					{
						// remove any quotes around tag
						get_next_token( tagValue, tagValueQ, 1024, "\"" );
						
						if( strcasecmp( tagName, "cmd" ) == 0 )
						{
							FILE	*stream;
							if( (stream = popen ( tagValue, "r" )) )
							{
								while( fgets( lineBuffer, 4096, stream) )
									io_printf( output, "%s", lineBuffer );
								pclose( stream );
							}
						}
						else if( strcasecmp( tagName, "cgi" ) == 0 )
						{
							HTTPRequest		request;
							HTTPResponse	response;
							brokenURI		brURI;
							BMallocIO		replyIO;
							
							request.SetRequestLine( "GET", tagValue );
							request.SetReplyIO( &replyIO );
							request.ParseURI( &brURI );
							uri_unescape_str( brURI.path, brURI.path, 2048 );
							if( strncmp( brURI.path, "cgi-bin/", 8 ) == 0 )
							{
								invoke_cgi( &request, &response, &brURI, virtualPath, sn, false );
								response.InitMessage();
								replyIO.Seek( 0, SEEK_SET );
								response.ReceiveMessage( &replyIO );
								int32 statusCode = response.GetStatusCode();
								if( statusCode == 302 )
								{
									if( response.FindHeader( kHEAD_LOCATION, lineBuffer, 4096 ) )
										io_printf( output, "<A HREF=\"%s\">", lineBuffer );
								}
								else if( (statusCode >= 200)&&(statusCode < 300) )
								{
									if( response.FindHeader( kHEAD_TYPE, lineBuffer, 4096 ) )
									{
										if( strncmp( lineBuffer, "text/", 5 ) == 0 )
										{
											DataIOPump		ioPump;
											ioPump.StartPump( &replyIO, output );
										}
									}
								}
							} // End if( strncmp( brURI->path, "cgi-bin/", 8 ) == 0 )
						} // End else if( strcasecmp( tagName, "cgi" ) == 0 )
					} // Break tag into name and value
				} // End while( *sPtr && (sPtr = get_next_token( tag, sPtr, 64, " " )) )
			} // End else if( strcasecmp( command, "exec" ) == 0 )
		} // End Look for ssi command in line
		else // no ssi command; just copy the line
			io_printf( output, "%s\n", lineBuffer );
	} // End while( io_getline( input, lineBuffer, 4096 ) )
	
	// Restore previous Current Working Directory
	chdir( previousCWD.Path() );
	return status;
}