// Robin Hood Web Server - A web server for BeOS
// Copyright (C) 1999 Joe Kloss

// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License 
// as published by the Free Software Foundation; either version 2 
// of the License, or (at your option) any later version. 

// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
// GNU General Public License for more details. 

// You should have received a copy of the GNU General Public License 
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Contact Info:
// Author: Joe Kloss
// E-mail: axly@deltanet.com
// Postal Address: 25002 Ravenswood, Lake Forest, CA 92630, USA

#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include "RHAuthenticate.h"

static const char *kRealm = "Basic realm=\"Sherwood\"";
bool http_authenticate( HTTPRequest *request, HTTPResponse *response, BPath *path, mode_t bitMask )
{
	struct stat		access;
	char			fieldValue[1024];
	
	if( stat( path->Path(), &access ) < 0 )
	{
		if( errno == ENOENT ) // File not found
			response->SetHTMLMessage( 404 );
		else
			response->SetHTMLMessage( 500 ); // Unknown error...
		request->SendReply( response );
		return false;
	}
	
	if( !(access.st_mode & bitMask) )
	{
		if( request->FindHeader( kHEAD_AUTHORIZATION, fieldValue, 1024 ) )
		{
			char		user[256];
			char		pass[256];
			
			getusername( user, 256 );
			getpassword( pass, 256 );
			if( !basic_authenticate( fieldValue, user, pass ) )
			{
				response->AddHeader( kHEAD_AUTHENTICATE, kRealm );
				response->SetHTMLMessage( 401 ); // Unauthorized
				request->SendReply( response );
				return false;
			}
			return true;
		}
		else
		{
			response->AddHeader( kHEAD_AUTHENTICATE, kRealm );
			response->SetHTMLMessage( 401 ); // Unauthorized
			request->SendReply( response );
			return false;
		}
	}
	return true;
}