// Robin Hood Web Server - A web server for BeOS
// Copyright (C) 1999 Joe Kloss

// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License 
// as published by the Free Software Foundation; either version 2 
// of the License, or (at your option) any later version. 

// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
// GNU General Public License for more details. 

// You should have received a copy of the GNU General Public License 
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Contact Info:
// Author: Joe Kloss
// E-mail: axly@deltanet.com
// Postal Address: 25002 Ravenswood, Lake Forest, CA 92630, USA

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Environment.h"

static const int kBlockSize = 4096;

Environment::Environment( void )
{
	InitEnvironment();
}

Environment::Environment( char **envir )
{
	InitEnvironment();
	CopyEnv( envir );
}

void Environment::InitEnvironment( void )
{
	next = 0;
	pointerSize = sizeof( char * );
	totalVars = kBlockSize/pointerSize;
	
	blocks = 1;
	env = (char **)malloc( kBlockSize );
	env[0] = NULL;
}

Environment::~Environment( void )
{
	MakeEmpty();
	free( env );
}

const char *Environment::GetEnv( const char *name, int *index )
{
	char	*var, *s;
	int		length = strlen( name );
	
	for( int i=0; (var=env[i]); i++ )
	{
		if( strncmp( name, var, length ) == 0 )
		{
			if( index )
				*index = i;
			if( (s = strchr( var, '=' )) )
				return s+1;
			else
				return var+length;
		}
	}
	return NULL;
}

const char *Environment::GetEnv( int index )
{
	if( index < next )
		return env[index];
	else
		return NULL;
}

void Environment::PutEnv( const char *string )
{
	AllocateBlock();
	env[next] = (char *)malloc( strlen(string)+1 );
	strcpy( env[next], string );
	next++;
	env[next] = NULL;
}

void Environment::PutEnv( const char *name, const char *value )
{
	int		index;
	
	if( GetEnv( name, &index ) )
	{
		free( env[index] );
	}
	else
	{
		AllocateBlock();
		index = next++;
		env[next] = NULL;
	}
	env[index] = (char *)malloc( strlen(name)+strlen(value)+2 );
	sprintf( env[index], "%s=%s", name, value );
}

char **Environment::GetEnvironment( void )
{
	return env;
}

void Environment::MakeEmpty()
{
	char	*var;
	for( int i=0; (var=env[i]); i++ )
		free( var );
	env[0] = NULL;
	next = 0;
}

void Environment::CopyEnv( char **envir )
{
	char	*var;
	for( int i=0; (var=envir[i]); i++ )
		PutEnv( var );
}

int Environment::CountVariables()
{
	return next;
}

void Environment::AllocateBlock( void )
{
	// Do we need more storage?
	if( next == totalVars )
	{
		blocks++;
		env = (char **)realloc( env, blocks*kBlockSize );
		totalVars = (kBlockSize*blocks)/pointerSize;
	}
}
