#ifndef TALKD_H
#define TALKD_H


#include <net/socket.h>
#include <net/netdb.h>


/* Sun */
/* #define TALK_DAEMON_PORT_ID 517 */

/* RS6000 */
#define TALK_DAEMON_PORT_ID 518


/* AF_INET is define to be 1 in the BeOS headers. */
#define BSD43_AF_INET 2


#define TRANSACTION_REPEAT_DELAY 2
#define MAX_LIFE                 60


#define HOST_NAME_SIZE 64
#define NAME_SIZE      12
#define TTY_SIZE       16


struct my_sockaddr_in {
	struct sockaddr_in addr;
	char be_bug_filler[4];
};


/* client to server request message format */
typedef struct {
	u_char vers;
	char type;
	u_short filler;
	long id_num;
	struct sockaddr_in addr;
	char be_bug_filler1[4]; /* added because of BeOS sockaddr size bug */
	struct sockaddr_in ctl_addr;
	char be_bug_filler2[4]; /* added because of BeOS sockaddr size bug */
	long pid;
	char l_name[NAME_SIZE];
	char r_name[NAME_SIZE];
	char r_tty[TTY_SIZE];
} CTL_MSG;

/* structure for earlier than BSD 4.2 */
typedef struct {
	char type;
	char l_name[NAME_SIZE];
	char r_name[NAME_SIZE];
	char filler;
	long id_num;
	long pid;
	char r_tty[TTY_SIZE];
	struct sockaddr_in addr;
	char be_bug_filler1[4]; /* added because of BeOS sockaddr size bug */
	struct sockaddr_in ctl_addr;
	char be_bug_filler2[4]; /* added because of BeOS sockaddr size bug */
} CTL_MSG_OLD;


/* server to client response message format */
typedef struct {
	u_char vers;            /* protocol version */
	u_char type;            /* type of request message */
	u_char answer;          /* respose to request message */
	u_char pad;
	u_long id_num;          /* message id */
	struct sockaddr addr;   /* address for establishing conversation */
	char be_bug_filler1[4]; /* added because of BeOS sockaddr size bug */   
} CTL_RESPONSE;

/* structure for earlier than BSD 4.2 */
typedef struct {
   char type;
   char answer;
   u_short filler;
   u_long id_num;
	struct sockaddr_in addr;
	char be_bug_filler1[4]; /* added because of BeOS sockaddr size bug */
} CTL_RESPONSE_OLD;


/* protocol version */
#define	TALK_VERSION	1


/* message type values */
#define LEAVE_INVITE  0 /* leave invitation with server (local) */
#define LOOK_UP       1 /* check for invitation by callee (remote) */
#define DELETE        2 /* delete invitation by caller (remote) */
#define ANNOUNCE      3 /* announce invitation by caller (remote) */
#define DELETE_INVITE 4 /* delete my invitation (local) */
#define AUTO_LOOK_UP  5 /* look up auto-invitation (remote) */
#define AUTO_DELETE   6 /* delete erroneous auto-invitation (remote) */


/* answer values */
#define SUCCESS           0 /* operation completed properly */
#define NOT_HERE          1 /* callee not logged in */
#define FAILED            2 /* operation failed for unexplained reason */
#define MACHINE_UNKNOWN   3 /* caller's machine name unknown */
#define PERMISSION_DENIED 4 /* callee's tty doesn't permit announce */
#define UNKNOWN_REQUEST   5 /* request has invalid type value */
#define BADVERSION        6 /* request has invalid protocol version */
#define BADADDR           7 /* request has invalid addr value */
#define BADCTLADDR        8 /* request has invalid ctl_addr value */


static char *talkd_answer_string[] = {
	"Success.",                                                      /* SUCCESS */
	"Your party is not logged on.",                                  /* NOT_HERE */
	"The target machine is too confused to talk to us.",             /* FAILED */
	"The target machine is unknown.",                                /* MACHINE_UNKNOWN */
	"Your party is refusing messages.",                              /* PERMISSION_REFUSED */
	"The target machine cannot handle a remote talk.",               /* UNKNOWN_REQUEST */
	"The target machine indicated a protocol mismatch.",             /* BADVERSION */
	"The target machine indicated a protocol botch (addr).",         /* BADADDR */
	"The target machine indicated a protocol botch (control_addr).", /* BADCTLADDR */
};


#endif /* TALKD_H */