#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "talkd.h"


static ulong gethostaddr(void);
static int open_control_socket(struct sockaddr_in *addr, struct in_addr machine_addr);
void process_request(CTL_MSG *req, CTL_RESPONSE *rsp);


ulong gethostaddr(void)
{
	struct sockaddr_in addr;
	int sock, size;
	struct hostent *host;

	memset((char *)&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = 0;

 	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		printf("socket() failed in gethostaddr()\n");
		exit(0);
	}
	
	if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
		printf("bind() failed in gethostname()\n");
		closesocket(sock);
		exit(0);
	}

	/* This fills in the control_addr structure with the bound address information. */
	size = sizeof(addr);
	if ((getsockname(sock, (struct sockaddr *)&addr, &size)) < 0) {
		printf("getsockname() failed in gethostname()\n");
		closesocket(sock);
		exit(0);
	}

	closesocket(sock);

	/*
	if (!(host = gethostbyaddr((char *)&(addr.sin_addr.s_addr), 4, AF_INET))) {
		addr.sin_addr.s_addr = INADDR_ANY;
	}
	*/

	if (addr.sin_addr.s_addr == INADDR_ANY)
		return INADDR_LOOPBACK;

	return addr.sin_addr.s_addr;
}


int open_control_socket(struct sockaddr_in *addr, struct in_addr machine_addr)
{
	int control_socket, size;
	int rc;

	memset((char *)addr, 0, sizeof(*addr));
	addr->sin_family = AF_INET;
	addr->sin_addr = machine_addr;
	addr->sin_port = TALK_DAEMON_PORT_ID;

	if ((control_socket = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		printf("talkd: socket() failed for control socket\n");
		exit(0);
	}
	
	if (bind(control_socket, (struct sockaddr *)addr, sizeof(*addr)) < 0) {
		printf("talkd: bind() failed for control socket\n");
		exit(0);
	}

	/* This fills in the control_addr structure with the bound address information. */
	size = sizeof(*addr);
	if ((rc = getsockname(control_socket, (struct sockaddr *)addr, &size)) < 0) {
		printf("talkd: getsockname() failed for control socket\n");
		exit(0);
	}
	
	//printf("address = %s\n", inet_ntoa(addr->sin_addr));
	
	return control_socket;
} 


void main(int argc, char *argv)
{
	CTL_MSG request;
	CTL_RESPONSE response;

	struct in_addr my_machine_addr;
	struct sockaddr_in my_addr;
	struct in_addr his_in_addr;
	char sockopt_data[1] = {0};
	
	int rc, control_socket, size;
	
	int read_mask, nready, restart;
	struct timeval wait;
	
	my_machine_addr.s_addr = gethostaddr();
	control_socket = open_control_socket(&my_addr, my_machine_addr);

	wait.tv_sec = TRANSACTION_REPEAT_DELAY;
	wait.tv_usec = 0;

	restart = 0;

	while (true) {	
		read_mask = 1 << control_socket;
		nready = select(32, (struct fd_set *)&read_mask, 0, 0, &wait);

		if (nready == 0) {
			//printf("timeout...\n");
			/* select() timeout */
			continue;
		} else if (nready < 0) {
			printf("talkd: select() failed\n");
			restart = 1;
		}	else {
			rc = recvfrom(control_socket, (char *)&request, sizeof(request), 0,
							  (struct sockaddr *)&(request.ctl_addr), &size);

			if (rc <= 0) {
				printf("talkd: recvfrom() failed\n");
				printf("%d\n", rc);
				restart = 1;
			} else if (rc != sizeof(request)) {
				continue;
			}
		}

		if (restart == 1) {
			printf("talkd: waiting to restart the talk daemon\n");

			closesocket(control_socket);

			sleep(5*TRANSACTION_REPEAT_DELAY);
				
			my_machine_addr.s_addr = gethostaddr();
			control_socket = open_control_socket(&my_addr, my_machine_addr);
				
			printf("talkd: the talk daemon has been restarted\n");

			restart = 0;
			continue;
		}

		process_request(&request, &response);

		rc = sendto(control_socket, (char *)&response, sizeof(response), 0, 
						(struct sockaddr *)&(request.ctl_addr), sizeof(request.ctl_addr));

		if (rc != sizeof(response)) {
			printf("talkd: sendto() failed\n");
		}
	}
	
	closesocket(control_socket); 
}