#include <stdio.h>
#include "talkd.h"
#include "table.h"


table_entry *table = NULL;
int table_size = 0;
struct  timeval tp;
struct  timezone txp;


/* Generate a unique non-zero sequence number. */
int new_id(void)
{
	static int current_id = 0;

	current_id = (current_id + 1) % MAX_ID;
	
	if (current_id == 0)
		current_id = 1;

	return current_id;
}


/* Insert an invitation into the table. */
void insert_invitation(CTL_MSG *request, CTL_RESPONSE *response)
{
	table_entry *entry;
	long current_time;

	gettimeofday(&tp, &txp);
	current_time = tp.tv_sec;
	
	request->id_num = new_id();
	response->id_num = htonl(request->id_num);

	entry = (table_entry *)malloc(sizeof(table_entry));
	entry->request = *request;
	entry->time = current_time;
	entry->prev = NULL;
	entry->next = table;
	if (entry->next != NULL)
		entry->next->prev = entry;

	table = entry;

	table_size++;
	printf("talkd: %d pending talk request(s)\n", table_size);
}


/* Look for a complimentary request. */
CTL_MSG *find_matching_request(CTL_MSG *request)
{
	table_entry *entry;
	long current_time;

	gettimeofday(&tp, &txp);
	current_time = tp.tv_sec;

	for (entry = table; entry != NULL; entry = entry->next) {
		if ((current_time - entry->time) > MAX_LIFE) {
			printf("talkd: an old talk request is being deleted\n");
			delete_entry(entry);
			continue;
		}
		
		if ((strcmp(request->l_name, entry->request.r_name) == 0) &&
			 (strcmp(request->r_name, entry->request.l_name) == 0) &&
			 (entry->request.type == LEAVE_INVITE))
			return (&entry->request);
	}
	
	return NULL;
}


/* Look for an identical request. */
CTL_MSG *find_identical_request(CTL_MSG *request)
{
	table_entry *entry;
	long current_time;

	gettimeofday(&tp, &txp);
	current_time = tp.tv_sec;

	for (entry = table; entry != NULL; entry = entry->next) {
		if ((current_time - entry->time) > MAX_LIFE) {
			printf("talkd: an old talk request is being deleted\n");
			delete_entry(entry);
			continue;
		}

		if ((strcmp(request->r_name, entry->request.r_name) == 0) &&
			 (strcmp(request->l_name, entry->request.l_name) == 0) &&
			 (request->type == entry->request.type) &&
			 (request->pid == entry->request.pid)) {
			entry->time = current_time;
			return (&entry->request);
		}
	}

	return NULL;
}


/* Delete invitation with id equal 'id_num' from the table. */
int delete_invitation(int id_num)
{
	table_entry *entry;

	entry = table;
	for (entry = table; entry != NULL; entry = entry->next) {
		if (entry->request.id_num == id_num)
			break;
	}
	
	if (entry != NULL) {
		delete_entry(entry);
		return SUCCESS;
	}
	
	return NOT_HERE;
}


/* Delete an entry from the table. */
void delete_entry(table_entry *entry)
{
	if (table == entry) {
		table = entry->next;
	} else if (entry->prev != NULL) {
		entry->prev->next = entry->next;
	}

	if (entry->next != NULL)
		entry->next->prev = entry->prev;

	free(entry);

	table_size--;
	printf("talkd: %d pending talk request(s)\n", table_size);
}