#include <stdio.h>
#include <string.h>
#include "talkd.h"
#include "table.h"


void announce_talk_request(CTL_MSG *req, CTL_RESPONSE *rsp);
int announce(CTL_MSG *req, char *remote_host_name);


void process_request(CTL_MSG *req, CTL_RESPONSE *rsp)
{
	char local_user_name[NAME_SIZE];
	ulong host_address;
	struct hostent *host;
	char host_name[HOST_NAME_SIZE];
	CTL_MSG *entry;
	
	getusername(local_user_name, NAME_SIZE);
	
	host_address = req->ctl_addr.sin_addr.s_addr;
	if (host_address == INADDR_LOOPBACK) {
		gethostname(host_name, HOST_NAME_SIZE);
	} else {
		if (host = gethostbyaddr((char *)&host_address, 4, AF_INET)) {
			strncpy(host_name, host->h_name, HOST_NAME_SIZE);
		} else {
			gethostname(host_name, HOST_NAME_SIZE);
		}
	}

	req->id_num = ntohl(req->id_num);
	req->addr.sin_family = ntohs(req->addr.sin_family);
	req->ctl_addr.sin_family = ntohs(req->ctl_addr.sin_family);
	req->pid = ntohl(req->pid);

	if (req->vers != TALK_VERSION) {
		rsp->answer = BADVERSION;
		return;
	}

#if 0	
	/* AF_INET == 2 in BSD4.3 */
	if (req->addr.sin_family != BSD43_AF_INET) {
		rsp->answer = BADADDR;
		return;
	}

	/* AF_INET == 2 in BSD4.3 */
	if (req->ctl_addr.sin_family != BSD43_AF_INET) {
		rsp->answer = BADCTLADDR;
		return;
	}
#endif
		
	rsp->vers = TALK_VERSION;
	rsp->type = req->type;
	rsp->id_num = htonl(0);
	
	switch (req->type) {
	case LEAVE_INVITE :
		printf("talkd: a talk invitation was posted by '%s@%s' for '%s'\n",
				 req->l_name, host_name, req->r_name);

		if (entry = find_identical_request(req)) {
			rsp->id_num = htonl(entry->id_num);
			rsp->answer = SUCCESS;
		} else {
			insert_invitation(req, rsp);
			rsp->answer = SUCCESS;
		}
		
		break;
		
	case LOOK_UP :
		printf("talkd: '%s@%s' is looking for a standing talk invitation from '%s'\n", 
				 req->l_name, host_name, req->r_name);

		if (entry = find_matching_request(req)) {
			rsp->id_num = htonl(entry->id_num);
			rsp->addr = *(struct sockaddr *)&entry->addr;
			rsp->addr.sa_family = htons(rsp->addr.sa_family);
			rsp->answer = SUCCESS;
		} else {
			rsp->answer = NOT_HERE;
		}
		
		break;
	
	case DELETE :
		printf("talkd: '%s@%s' is deleting his/her talk invitation for '%s'\n",
				 req->l_name, host_name, req->r_name);

		rsp->answer = delete_invitation(req->id_num);
		
		break;
		
	case ANNOUNCE :
		printf("talkd: '%s@%s' is requesting to talk with '%s'\n",
				 req->l_name, host_name, req->r_name);

		announce_talk_request(req, rsp);
		
		break;

	default :		
		printf("talkd: an unknown request type %d was encountered\n", req->type);

		rsp->answer = UNKNOWN_REQUEST;
	}
}


void announce_talk_request(CTL_MSG *req, CTL_RESPONSE *rsp)
{
	char local_user_name[NAME_SIZE];
	ulong remote_address;
	struct hostent *remote_host;
	char remote_host_name[HOST_NAME_SIZE];
	CTL_MSG *entry;

	getusername(local_user_name, NAME_SIZE);

	if (strcmp(local_user_name, req->r_name) != 0) {
		rsp->answer = NOT_HERE;
		return;
	}
	
	remote_address = req->ctl_addr.sin_addr.s_addr;
	if (remote_address == INADDR_LOOPBACK) {
		gethostname(remote_host_name, HOST_NAME_SIZE);
	} else {
		remote_host = gethostbyaddr((char *)&remote_address, 4, AF_INET);
		if (remote_host) {
			strncpy(remote_host_name, remote_host->h_name, HOST_NAME_SIZE);
		} else {
			rsp->answer = MACHINE_UNKNOWN;
			return;
		}
	}
	
	entry = find_identical_request(req);
	if (entry == NULL) {
		insert_invitation(req, rsp);
		rsp->answer = announce(req, remote_host_name);
		return;
	}
	
	if (req->id_num > entry->id_num) {
		/* This is an explicit re-announce, so update the id_num
			field to avoid duplicates and re-announce the talk. */
		entry->id_num = new_id();
		rsp->id_num = htonl(entry->id_num);
		
		/* Each  announce launches another application. Therefore, 
			I'm not doing and re-announces. */
		/* rsp->answer = announce(req, remote_host_name); */
		rsp->answer = SUCCESS;
	} else {
		/* a duplicated request, so ignore it */
		rsp->id_num = htonl(entry->id_num);
		rsp->answer = SUCCESS;
	}										 
}