#include "jabber.h"


// Window Code

void jabber_window::MessageReceived(BMessage *message)
{
	switch (message->what) {
	case OPEN_CONNECTION :
		int xdim = 400;
		int ydim = 80;
	
		BPoint upper_left = ConvertToScreen(BPoint(0,0));
		
		int left = upper_left.x + 50;
		int top = upper_left.y + 90;

		// Make sure the prompt window will be on the screen.
		BRect screen_frame = BScreen(B_MAIN_SCREEN_ID).Frame();
		if (!(screen_frame.Contains(BRect(left, top, left+xdim, top+ydim)))) {
			left = (screen_frame.right - xdim) / 2;
			top = (screen_frame.bottom - ydim) / 2;
		}
		
		prompt_window *get_remote_addr =
			new prompt_window(BRect(left, top, left+xdim, top+ydim));

		get_remote_addr->Show();
		break;
		
	case CLOSE_CONNECTION :
		be_app->PostMessage(CLOSE_CONNECTION);
		((jabber *)be_app)->OpenAlertWindow("The talk connection was broken.");
		break;
	}
}


bool jabber_window::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}


// Prompt window for remote user's address.

prompt_window::prompt_window(BRect frame) :
	BWindow(frame, "Open Connection", B_MODAL_WINDOW, B_NOT_RESIZABLE)
{
	BView *background_view = new BView(BRect(0,0,400,80), 
												  NULL, B_FOLLOW_ALL_SIDES, B_WILL_DRAW);
		
	input_box = new BTextControl(BRect(5, 15, 395, 40),
										  "input_box", "Remote User's Address:",
										  "", new BMessage(HAVE_REMOTE_ADDRESS));
	input_box->SetAlignment(B_ALIGN_LEFT, B_ALIGN_LEFT);
	input_box->SetDivider(125);
		
	BButton *cancel_button = new BButton(BRect(75,45,150,70), "cancel_button", "Cancel",
													 new BMessage(ABORT));
		
	BButton *ok_button = new BButton(BRect(250,45,325,70), "ok_button", "OK",
												new BMessage(HAVE_REMOTE_ADDRESS));

	rgb_color bg = {216,216,216,255};
	background_view->SetViewColor(bg);
	background_view->AddChild(input_box);
	background_view->AddChild(cancel_button);
	background_view->AddChild(ok_button);
				
	Lock();
	AddChild(background_view);
	Unlock();
}


void prompt_window::MessageReceived(BMessage *message)
{
	char buffer[512];

	switch (message->what) {
	case HAVE_REMOTE_ADDRESS :
		BMessage *init_message = new BMessage(INIT_TALK_PARAMS);
		
		char buffer[512];
		sprintf(buffer, "%s",  input_box->Text());
		init_message->AddString("ruser", buffer);

		be_app->PostMessage(OPEN_CONNECTION);
		be_app->PostMessage(init_message);
		Quit();
		break;
	case ABORT :
		Quit();
		break;
	}
}


// This window is displayed while a connect is being made.

wait_window::wait_window(BRect frame) :
	BWindow(frame, "Wait Window", B_MODAL_WINDOW, B_NOT_RESIZABLE)
{
	BView *background_view = new BView(BRect(0,0,400,80), 
												  NULL, B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

	BStringView *wait_str = new BStringView(BRect(75,0,400,32), "waiting_string", 
														 "Waiting to connect...");
	
	BButton *abort_button = new BButton(BRect(250,45,325,70), "abort_button", "Abort",
													 new BMessage(ABORT));
	rgb_color bg = {216,216,216,0};
	background_view->SetViewColor(bg);
	background_view->AddChild(wait_str);
	background_view->AddChild(abort_button);
	
	Lock();
	AddChild(background_view);
	Unlock();
}


void wait_window::MessageReceived(BMessage *message)
{
	char buffer[512];

	switch (message->what) {
	case ABORT :
		be_app->PostMessage(CLOSE_CONNECTION);
		Quit();
		break;
	}
}


// This window is displayed to notify the user of some event.

alert_window::alert_window(BRect frame, char *text) :
	BWindow(frame, "Alert Window", B_MODAL_WINDOW, B_NOT_RESIZABLE)
{
	BView *background_view = new BView(BRect(0,0,400,80), 
												  NULL, B_FOLLOW_ALL_SIDES, B_WILL_DRAW);

	BStringView *str_view = new BStringView(BRect(75,0,400,32), "alert_string", text);
	
	BButton *abort_button = new BButton(BRect(250,45,325,70), "ok_button", "OK",
													 new BMessage(B_QUIT_REQUESTED));
	rgb_color bg = {216,216,216,0};
	background_view->SetViewColor(bg);
	background_view->AddChild(str_view);
	background_view->AddChild(abort_button);
	
	Lock();
	AddChild(background_view);
	Unlock();
}