#include "jabber.h"


// View Code

jabber_view::jabber_view(BRect frame) :
	BView(frame, NULL, B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	BMenuBar *menubar;
	BMenu *menu;
	BMenuItem *item;

	menubar = new BMenuBar(BRect(0,0,0,0), "MenuBar");

	// File Menu	
	menu = new BMenu("File");
	menubar->AddItem(menu);
	
	item = new BMenuItem("About" B_UTF8_ELLIPSIS, new BMessage(B_ABOUT_REQUESTED));
	item->SetTarget(be_app);
	menu->AddItem(item);

	item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
	menu->AddItem(item);

#if 0
	// Edit Menu
	menu = new BMenu("Edit");
	menubar->AddItem(menu);

	item = new BMenuItem("Copy", new BMessage(B_COPY));
	item->SetEnabled(false);
	menu->AddItem(item);
	
	item = new BMenuItem("Paste", new BMessage(B_PASTE));
	menu->AddItem(item);
#endif

	// Connection Menu
	menu = new BMenu("Connection");
	menubar->AddItem(menu);
	
	open_item = new BMenuItem("Open", new BMessage(OPEN_CONNECTION));
	menu->AddItem(open_item);

	close_item = new BMenuItem("Close", new BMessage(CLOSE_CONNECTION));
	close_item->SetEnabled(false);
	menu->AddItem(close_item);

	AddChild(menubar);
	
	//BRect talk_area = Bounds();
	//talk_area.top += menubar->Bounds().Height()+1;
	
	BTextView *remote_view;
	local_input_view *local_view;
	BScrollView *scroll_view;

	// Create the local BTextView.
	local_view = new local_input_view(BRect(5,25,481,215), 
												 "Local", BRect(1,1,475,189), 0, B_WILL_DRAW);
	local_view->MakeEditable(false);
	scroll_view = new BScrollView("Local", local_view, 
											B_FOLLOW_LEFT|B_FOLLOW_TOP, 0, false, true);
	AddChild(scroll_view);

	((jabber *)be_app)->SetLocalTextView(local_view);
	
	// Create the remote BTextView.
	remote_view = new BTextView(BRect(5,225,481,415), 
										 "Remote", BRect(1,1,475,189), 0, B_WILL_DRAW);
	remote_view->MakeEditable(false);
	scroll_view = new BScrollView("Remote", remote_view, 
											B_FOLLOW_LEFT|B_FOLLOW_TOP, 0, false, true);
	AddChild(scroll_view);

	((jabber *)be_app)->SetRemoteTextView(remote_view);
}


void jabber_view::EnableOpen(bool status)
{
	open_item->SetEnabled(status);
	close_item->SetEnabled(!status);
}


void local_input_view::KeyDown(const char *bytes, int32 numBytes)
{
	int32 start, finish;

	Select(INT_MAX, INT_MAX);

	// Filter out illegal characters and send everything else
	// to the screen and stream_socket.
	if (numBytes == 1) {
		if (isprint(bytes[0]) || (bytes[0] == B_RETURN) || 
			 (bytes[0] == B_BACKSPACE) || (bytes[0] == B_TAB)) {
			GetSelection(&start, &finish);
			if (!((start > 0) && (ByteAt(start-1) == B_RETURN) && (bytes[0] == B_BACKSPACE))) {
				BMessage *local_input = new BMessage(LOCAL_INPUT);
				local_input->AddString("text", bytes);
				((jabber *)be_app)->PostMessage(local_input);
				delete local_input;

				BTextView::KeyDown(bytes, numBytes);
			}
		}
	}
}


void local_input_view::Cut(BClipboard *clipboard)
{
	BTextView::Copy(clipboard);
}


void local_input_view::Paste(BClipboard *clipboard)
{
	if (clipboard->Lock()) {
		BMessage *clipper = clipboard->Data();

		char *text;
		char *copy;
		ssize_t size;
		if (clipper->FindData("text/plain", B_MIME_TYPE, &text, &size) == B_OK) {
			copy = new char[size + 1];
			strncpy(copy, text, size);
			copy[size] = '\0';

			Select(INT_MAX, INT_MAX);
			Insert(copy);
			ScrollToSelection();
			
			BMessage *local_input = new BMessage(LOCAL_INPUT);
			local_input->AddString("text", copy);
			((jabber *)be_app)->PostMessage(local_input);
			delete local_input;
			delete copy;
		}
		
		clipboard->Unlock();
	}
}