#include "jabber.h"


/* This function also returns your current IP address.  It relies
	on the ability to create a socket, bind that socket, then call
	the getsockname() function. */
ulong TalkIO::gethostaddr(void)
{
	struct sockaddr_in addr;
	int sock, size;
	struct hostent *host;

	memset((char *)&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = 0;

 	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		printf("socket() failed in gethostaddr()\n");
		exit(0);
	}
	
	if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
		printf("bind() failed in gethostname()\n");
		closesocket(sock);
		exit(0);
	}

	/* This fills in the control_addr structure with the bound address information. */
	size = sizeof(addr);
	if ((getsockname(sock, (struct sockaddr *)&addr, &size)) < 0) {
		printf("getsockname() failed in gethostname()\n");
		closesocket(sock);
		exit(0);
	}

	closesocket(sock);

	//if (!(host = gethostbyaddr((char *)&(addr.sin_addr.s_addr), 4, AF_INET))) {
	//	addr.sin_addr.s_addr = INADDR_ANY;
	//}

	if (addr.sin_addr.s_addr == INADDR_ANY)
		return INADDR_LOOPBACK;

	return addr.sin_addr.s_addr;
}


bool TalkIO::any(char c, char *cp)
{
	while (*cp) {
		if (c == *cp++)
			return true;
	}
	
	return false;
}


bool TalkIO::open_stream_socket(void)
{
	int size;

	memset((char *)&stream_addr, 0, sizeof(stream_addr));
	stream_addr.sin_family = AF_INET;
	stream_addr.sin_addr = my_machine_addr;
	stream_addr.sin_port = 0;
	
	if ((stream_socket = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		//printf("ERROR: socket() failed for stream socket\n");
		return false;
	}
	
	if (bind(stream_socket, (struct sockaddr *)&stream_addr, sizeof(stream_addr)) < 0) {
		//printf("ERROR: bind() failed for stream socket\n");
		return false;
	}

	// This fills in the stream_addr structure with the bound address information.
	size = sizeof(stream_addr);
	if ((getsockname(stream_socket, (struct sockaddr *)&stream_addr, &size)) < 0) {
		//printf("ERROR: getsockname() failed for stream socket\n");
		return false;
	}
	
	return true;
}


bool TalkIO::open_control_socket(void)
{
	int size;

	memset((char *)&control_addr, 0, sizeof(control_addr));
	control_addr.sin_family = AF_INET;
	control_addr.sin_addr = my_machine_addr;
	control_addr.sin_port = 0;

	if ((control_socket = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		//printf("ERROR: socket() failed for control socket\n");
		return false;
	}
	
	if (bind(control_socket, (struct sockaddr *)&control_addr, sizeof(control_addr)) < 0) {
		//printf("ERROR: bind() failed for control socket\n");
		return false;
	}

	// This fills in the control_addr structure with the bound address information.
	size = sizeof(control_addr);
	if ((getsockname(control_socket, (struct sockaddr *)&control_addr, &size)) < 0) {
		//printf("ERROR: getsockname() failed for control socket\n");
		return false;
	}
 	
 	if (his_machine_addr.s_addr == my_machine_addr.s_addr) {
	 	his_machine_addr = control_addr.sin_addr;	
	}
	my_machine_addr = control_addr.sin_addr;

	return true;
}


bool TalkIO::check_local(void)
{
	request.ctl_addr = control_addr;
	request.ctl_addr.sin_family = htons(BSD43_AF_INET);
	//request.ctl_addr.sin_family = htons(AF_INET);
	request.ctl_addr.sin_port = htons(request.ctl_addr.sin_port);
	request.ctl_addr.sin_addr.s_addr = htonl(request.ctl_addr.sin_addr.s_addr);
	request.addr.sin_family = htons(BSD43_AF_INET);
	//request.addr.sin_family = htons(AF_INET);
	
	control_transaction(his_machine_addr, LOOK_UP);

	switch (response.answer) {
	case SUCCESS :
		// an invitation was found waiting
		//printf("DEBUG: an invitation was found waiting\n");
		request.id_num = htonl(response.id_num);
		
		if (connect(stream_socket, &(response.addr), sizeof(response.addr)) < 0) {
			//printf("ERROR: connect() failed\n");
			return false;
		}			
		break;
		
	default :
		// no invitation was found
		return false;
	}

	return true;
}		  


void TalkIO::invite_remote(void)
{
	request.addr = stream_addr;
	request.addr.sin_family = htons(BSD43_AF_INET);
	//request.addr.sin_family = htons(AF_INET);
	request.id_num = htonl(-1);
		
	// This thread will send out announcements.
	announce_thread = spawn_thread(announce_invite_hook, "announce_invite_hook",
											 B_NORMAL_PRIORITY, this);
	//resume_thread(announce_thread);

	// This thread will wait for a connection to be made.
	accept_thread = spawn_thread(accept_connection_hook, "accept_connection_hook",
										  B_NORMAL_PRIORITY, this);
	resume_thread(accept_thread);
}


void TalkIO::delete_invite(void)
{
	request.id_num = htonl(remote_id);
	control_transaction(his_machine_addr, DELETE);

	request.id_num = htonl(local_id);
	control_transaction(my_machine_addr, DELETE);
}


void TalkIO::delete_invite_fast(void)
{
	struct my_sockaddr_in daemon_addr;

	daemon_addr.addr.sin_family = AF_INET;
	daemon_addr.addr.sin_port = TALK_DAEMON_PORT_ID;
	
	request.type = DELETE;
	
	daemon_addr.addr.sin_addr = his_machine_addr;
	request.id_num = htonl(remote_id);
	sendto(control_socket, (char *)&request, sizeof (request), 0,
			 (struct sockaddr *)&daemon_addr, sizeof (daemon_addr));

	daemon_addr.addr.sin_addr = my_machine_addr;
	request.id_num = htonl(local_id);
	sendto(control_socket, (char *)&request, sizeof (request), 0,
			 (struct sockaddr *)&daemon_addr, sizeof (daemon_addr));
}


void TalkIO::set_edit_characters(void)
{
	// 0 - RUB, 1 - KILL, 2 - WORD
	char my_edit_char[3] = {B_BACKSPACE, 0xff, 0xff};
	int read_mask, control_mask, nready;
	struct timeval wait;

	wait.tv_sec = 10*TRANSACTION_REPEAT_DELAY;
	wait.tv_usec = 0;

	control_mask = 1 << stream_socket;
	
	if (send(stream_socket, my_edit_char, sizeof(my_edit_char), 0) < 0) {
		printf("ERROR: edit characters were not sent successfully\n");
	}

	read_mask = control_mask;
	nready = select(32, (struct fd_set *)&read_mask, 0, 0, &wait);

	if (recv(stream_socket, his_edit_char, sizeof(his_edit_char), 0) < 0) {
		printf("ERROR: edit characters were not received successfully\n");
	}
}


void TalkIO::announce_invite(void)
{
	//printf("DEBUG: announce_invite() thread is running\n");
	
	// Usually the ANNOUNCE is before the LEAVE_INVITE, but it was causing
	// synchronization problems because of communication delays when the
	// talk request was local.  If the user pressed "Accept" before the
	// invitation was left with the daemon, then the newly launched talk 
	// program would do its own announce and leave another invitation since 
	// it could not find a standing invitation.  I'm not sure if this will
	// work with other talk daemons.

	request.ctl_addr = control_addr;
	request.ctl_addr.sin_family = htons(BSD43_AF_INET);
	//request.ctl_addr.sin_family = htons(AF_INET);
	request.ctl_addr.sin_port = htons(request.ctl_addr.sin_port);
	request.ctl_addr.sin_addr.s_addr = htonl(request.ctl_addr.sin_addr.s_addr);
	request.addr.sin_family = htons(BSD43_AF_INET);
	//request.addr.sin_family = htons(AF_INET);

	int answer;

	// This thread will loop forever, it will be killed when it is
	// no longer needed.
	while (true) {
		control_transaction(my_machine_addr, LEAVE_INVITE);
		local_id = ntohl(response.id_num);
		answer = response.answer;

		if (answer != SUCCESS) {
			delete_invite();
			be_app->Lock();
			((jabber *)be_app)->CloseWaitWindow();
			((jabber *)be_app)->OpenAlertWindow(talkd_answer_string[answer]);
			be_app->Unlock();
			be_app->PostMessage(CLOSE_CONNECTION);
			break;
		}

		control_transaction(his_machine_addr, ANNOUNCE);
		remote_id = ntohl(response.id_num);
		answer = response.answer;
		
		if (answer != SUCCESS) {
			delete_invite();
			be_app->Lock();
			((jabber *)be_app)->CloseWaitWindow();
			((jabber *)be_app)->OpenAlertWindow(talkd_answer_string[answer]);
			be_app->Unlock();
			be_app->PostMessage(CLOSE_CONNECTION);
			break;
		}

		request.id_num = htonl(remote_id + 1);
		sleep(10*TRANSACTION_REPEAT_DELAY);
	}

	//printf("DEBUG: announce_invite() thread is exiting\n");
}


int32 TalkIO::announce_invite_hook(void *arg)
{
	TalkIO *looper;
	looper = (TalkIO *)arg;
	looper->announce_invite();
	
	return B_OK;
}


void TalkIO::accept_connection(void)
{
	//printf("DEBUG: accept_connection() thread is running\n");
	int new_socket;
	
	if (listen(stream_socket, 5) < 0) {
		//printf("ERROR: listen() failed, accept_connection() failed\n");
		return;
	}

	resume_thread(announce_thread);

	while ((new_socket = accept(stream_socket, 0, 0)) < 0) {
		//printf("ERROR: accept() failed, accept_connection() failed\n");
		kill_thread(announce_thread);
		return;
	}

	kill_thread(announce_thread);
	
	closesocket(stream_socket);
	stream_socket = new_socket;

	delete_invite();

	PostMessage(SPAWN_READ_THREAD);

	//printf("DEBUG: accept_connection() thread is exiting\n");
}


int32 TalkIO::accept_connection_hook(void *arg)
{
	TalkIO *looper;
	looper = (TalkIO *)arg;
	looper->accept_connection();

	return B_OK;
}


void TalkIO::read_from_stream(void)
{
	//printf("DEBUG: read_from_stream() thread is running\n");	
	
	char buffer[512];
	int read_mask, control_mask, nready, rc;
	struct timeval wait;

	set_edit_characters();

	wait.tv_sec = TRANSACTION_REPEAT_DELAY;
	wait.tv_usec = 0;

	control_mask = 1 << stream_socket;

	be_app->Lock();
	((jabber *)be_app)->LocalViewMakeEditable(true);
	((jabber *)be_app)->CloseWaitWindow();
	be_app->Unlock();
	
	beep();
	
	while (true) {
		read_mask = control_mask;
		nready = select(32, (struct fd_set *)&read_mask, 0, 0, &wait);
		
		if (nready <= 0) {
			continue;
		}
		
		if (read_mask & control_mask) {
			Lock();
			if ((rc = recv(stream_socket, buffer, sizeof(buffer), 0)) <= 0) {
				//printf("ERROR: recv() failed\n");		
				Unlock();
				break;
			} else {
				Unlock();
			}

			buffer[rc] = '\0';
			
			for (int i=0; i<strlen(buffer); i++) {
				if (buffer[i] == his_edit_char[0])
					buffer[i] = B_BACKSPACE;
			}
			
			BMessage *remote_input = new BMessage(REMOTE_INPUT);
			remote_input->AddString("text", buffer);
			be_app->PostMessage(remote_input);
			delete remote_input;
		}
	}

	be_app->Lock();
	((jabber *)be_app)->LocalViewMakeEditable(false);
	((jabber *)be_app)->OpenAlertWindow("The talk connection was broken.");
	be_app->Unlock();
	be_app->PostMessage(CLOSE_CONNECTION);

	//printf("DEBUG: read_from_stream() thread is exiting\n");
}


int32 TalkIO::read_from_stream_hook(void *arg)
{
	TalkIO *looper;
	looper = (TalkIO *)arg;
	looper->read_from_stream();

	return B_OK;
}


void TalkIO::MessageReceived(BMessage *message)
{
	const char *text;

	switch (message->what) {
	case START_TALKING :
		if (!check_local()) {
			PostMessage(INVITE_REMOTE);
		} else {
			PostMessage(SPAWN_READ_THREAD);
		}
		break;
	
	case INVITE_REMOTE :
		invite_remote();
		break;
		
	case SPAWN_READ_THREAD :
		//printf("DEBUG: spawning read_from_stream() thread\n");
		read_thread = spawn_thread(read_from_stream_hook, "read_from_stream",
											B_NORMAL_PRIORITY, this);
		resume_thread(read_thread);
		break;
	
	case LOCAL_INPUT :
		text = message->FindString("text");
		Lock();
		send(stream_socket, text, strlen(text), 0);
		Unlock();
		break;
		
	case ABORT :
		Quit();
		break;
	}
}


void TalkIO::Quit(void)
{
	delete_invite_fast();

	CloseSockets();

	if (announce_thread > 0)
		kill_thread(announce_thread);
		
	if (accept_thread > 0)
		kill_thread(accept_thread);
		
	if (read_thread > 0)
		kill_thread(read_thread);
	
	BLooper::Quit();
}


bool TalkIO::InitParameters(char *remote_address, char *remote_tty)
{
	register char *cp;	
	char my_name[NAME_SIZE], *his_name;
	char my_machine_name[HOST_NAME_SIZE], *his_machine_name;
	char *my_tty, *his_tty;
	ulong temp;
	struct hostent *my_host, *remote_host;

	getusername(my_name, NAME_SIZE);
	gethostname(my_machine_name, HOST_NAME_SIZE);
	my_tty = "";

	/* check for, and strip out, the machine name of the target */
	for (cp = remote_address; *cp && !any(*cp, "@:!."); cp++);
	if (*cp == '\0') {
		/* a local to local talk */
		his_name = remote_address;
		his_machine_name = my_machine_name;

		//printf("DEBUG: this is a local talk to '%s'\n", his_name);
	} else {
		if (*cp++ == '@') {
			/* user@host */
			his_name = remote_address;
			his_machine_name = cp;
		} else {
			/* host.user or host!user or host:user */
			his_name = cp;
			his_machine_name = remote_address;
		}
		*--cp = '\0';

		//printf("DEBUG: this is a remote talk to '%s' at '%s'\n", his_name, his_machine_name);
	}
	his_tty = remote_tty;

	my_machine_addr.s_addr = gethostaddr();

	if (strcmp(his_machine_name, my_machine_name) == 0) {
		his_machine_addr = my_machine_addr;
	} else {
		if (remote_host = gethostbyname(his_machine_name)) {
			his_machine_addr.s_addr = *(ulong *)remote_host->h_addr;
		} else {
			//printf("DEBUG: the host '%s' is unknown\n", his_machine_name);
			return false;
		}
	}

	//printf("DEBUG: my_machine_addr = %s, ", inet_ntoa(my_machine_addr));
	//printf("his_machine_addr = %s\n", inet_ntoa(his_machine_addr));

	/* initialize the message template */
	request.vers = TALK_VERSION;
	request.id_num = htonl(0);
	request.addr.sin_family = htons(AF_INET);
	request.ctl_addr.sin_family = htons(AF_INET);
	request.pid = htonl(getpid());
	strncpy(request.l_name, my_name, NAME_SIZE);
	request.l_name[NAME_SIZE - 1] = '\0';
	strncpy(request.r_name, his_name, NAME_SIZE);
	request.r_name[NAME_SIZE - 1] = '\0';
	strncpy(request.r_tty, his_tty, TTY_SIZE);
	request.r_tty[TTY_SIZE - 1] = '\0';

	return true;
}


bool TalkIO::OpenSockets(void)
{
	if (!open_control_socket()) {
		CloseSockets();
		return false;
	}
	
	if (!open_stream_socket()) {
		CloseSockets();
		return false;
	}		

	return true;
}


void TalkIO::CloseSockets(void)
{
	if (control_socket >= 0) {
		closesocket(control_socket);
		control_socket = -1;
	}
			
	if (stream_socket >= 0) {
		closesocket(stream_socket);
		stream_socket = -1;
	}
}


bool TalkIO::control_transaction(struct in_addr target_addr, int type)
{
	struct my_sockaddr_in daemon_addr, from_addr;
	int read_mask, control_mask, rc, nready;
	struct timeval wait;
	int size, attempts;

	daemon_addr.addr.sin_family = AF_INET;
	daemon_addr.addr.sin_addr = target_addr;
	daemon_addr.addr.sin_port = TALK_DAEMON_PORT_ID;

	request.type = type;
	
	control_mask = 1 << control_socket;

	do {
		wait.tv_sec = TRANSACTION_REPEAT_DELAY;
		wait.tv_usec = 0;
		
		attempts = 0;
		do {
			attempts++;
			//printf("DEBUG: control_transaction() sending...\n");
			rc = sendto(control_socket, (char *)&request, sizeof (request), 0,
							(struct sockaddr *)&daemon_addr, sizeof (daemon_addr));

			if ((rc != sizeof (request)) || (attempts > 5)) {
				//printf("ERROR: sendto() failed, control_transaction() failed\n");
				response.answer = FAILED;
				return false;
			}
			
			read_mask = control_mask;
			nready = select(32, (struct fd_set *)&read_mask, 0, 0, &wait);
		} while (nready == 0);

		attempts = 0;
		do {
			attempts++;
			//printf("DEBUG: control_transaction() receiving...\n");
			rc = recvfrom(control_socket, (char *)&response, sizeof (response), 0,
								(struct sockaddr *)&from_addr, &size);
			
			if ((rc <= 0) || (attempts > 5)) {
				//printf("ERROR: recv() failed, control_transaction() failed\n");
				response.answer = FAILED;
				return false;
			}
			
			read_mask = control_mask;
			nready = select(32, (struct fd_set *)&read_mask, 0, 0, &wait);
		} while ((nready > 0) && (response.vers != TALK_VERSION || response.type != type));
	} while (response.vers != TALK_VERSION || response.type != type);

	response.id_num = ntohl(response.id_num);
	response.addr.sa_family = ntohs(response.addr.sa_family);

	//printf("DEBUG: control_transaction() result = %s\n", talkd_answer_string[response.answer]);

	return true;
}