#ifndef JABBER_H
#define JABBER_H


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <Application.h>
#include <Window.h>
#include <Screen.h>
#include <View.h>
#include <Menu.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <Beep.h>
#include <TextView.h>
#include <StringView.h>
#include <ScrollView.h>
#include <TextControl.h>
#include <Alert.h>
#include "talkd.h"


static const char *APP_SIG="application/x-vnd.dungan-Jabber";


#define TALK_REQUESTED      'treq'
#define INIT_TALK_PARAMS    'init'
#define OPEN_CONNECTION     'open'
#define CLOSE_CONNECTION    'clos'
#define CHECK_LOCAL         'locl'
#define INVITE_REMOTE       'invt'
#define SPAWN_READ_THREAD   'spnr'
#define START_TALKING       'strt'
#define LOCAL_INPUT         'lcli'
#define REMOTE_INPUT        'rmti'
#define HAVE_REMOTE_ADDRESS 'hrad'
#define ABORT               'abrt'


class jabber_window : public BWindow {
public :
	jabber_window(BRect frame)  :
		BWindow(frame, "Jabber", B_TITLED_WINDOW, B_NOT_RESIZABLE) {}
	virtual void MessageReceived(BMessage *message);
	virtual bool QuitRequested(void);
};


class prompt_window : public BWindow {
	BTextControl *input_box;
public :
	prompt_window(BRect frame);
	virtual void MessageReceived(BMessage *message);
};


class wait_window : public BWindow {
public :
	wait_window(BRect frame);
	virtual void MessageReceived(BMessage *message);	
};


class alert_window : public BWindow {
public :
	alert_window(BRect frame, char *text);
};


class jabber_view : public BView {
	BMenuItem *open_item;
	BMenuItem *close_item;
public :
	jabber_view(BRect frame);
	void EnableOpen(bool status);
};


class local_input_view : public BTextView {
public:
	local_input_view(BRect frame, const char *name, BRect textRect,
		uint32 resizeMask, uint32 flags) :
		BTextView(frame, name, textRect, resizeMask, flags) {}
	virtual void KeyDown(const char *bytes, int32 numBytes);
	
	virtual void Cut(BClipboard *clipboard);
	virtual void Paste(BClipboard *clipboard);
};


class TalkIO : public BLooper {
	CTL_MSG request;
	CTL_RESPONSE response;
	
	struct in_addr my_machine_addr, his_machine_addr;
	struct sockaddr_in control_addr, stream_addr;
	
	int local_id, remote_id;
	int control_socket, stream_socket;

	char his_edit_char[3];

	ulong gethostaddr(void);
	bool any(char c, char *cp);
	bool open_stream_socket(void);
	bool open_control_socket(void);
	bool control_transaction(struct in_addr target_addr, int type);
	bool check_local(void);
	void invite_remote(void);
	void delete_invite(void);
	void delete_invite_fast(void);
	void set_edit_characters(void);
	
	void announce_invite(void);	
	static int32 announce_invite_hook(void *arg);
	void accept_connection(void);
	static int32 accept_connection_hook(void *arg);
	void read_from_stream(void);
	static int32 read_from_stream_hook(void *arg);
public:
	thread_id announce_thread;
	thread_id accept_thread;
	thread_id read_thread;

	TalkIO(void) : BLooper("TalkIO"),
		control_socket(-1), stream_socket(-1) {}
	bool InitParameters(char *remote_address, char *remote_tty);
	virtual void MessageReceived(BMessage *message);
	virtual void Quit(void);

	bool OpenSockets(void);
	void CloseSockets(void);
};


class jabber : public BApplication {
	jabber_window *window;
	jabber_view *view;
	BTextView *local_view;
	BTextView *remote_view;
	wait_window *wait_win;

	TalkIO *talkio;	

	thread_id talkio_thread;
public :
	jabber(void) : BApplication(APP_SIG),
		talkio_thread(-1) {}

	virtual void ReadyToRun(void);
	virtual void AboutRequested(void);
	virtual bool QuitRequested(void);
	virtual void MessageReceived(BMessage *message);

	void SetLocalTextView(BTextView *view) { local_view = view; }
	void SetRemoteTextView(BTextView *view) {	remote_view = view; }

	void LocalViewMakeEditable(bool state) { 
		window->Lock();
		local_view->MakeEditable(state);
		window->Unlock();
	}

	void OpenWaitWindow(void);
	void CloseWaitWindow(void);
	void OpenAlertWindow(char *text);
};


#endif /* JABBER_H */
